/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.library.executor.AbstractReflectiveInheritanceType;
import org.eclipse.ocl.pivot.internal.library.executor.DomainProperties;
import org.eclipse.ocl.pivot.internal.library.executor.DomainReflectiveFragment;
import org.eclipse.ocl.pivot.internal.library.executor.DomainReflectivePackage;
import org.eclipse.ocl.pivot.types.AbstractFragment;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class DomainReflectiveType
extends AbstractReflectiveInheritanceType {
    @NonNull
    protected final DomainReflectivePackage evaluationPackage;
    @NonNull
    protected final Class domainClass;
    private DomainProperties allProperties;

    public DomainReflectiveType(@NonNull DomainReflectivePackage evaluationPackage, @NonNull Class domainClass) {
        super(ClassUtil.nonNullModel(domainClass.getName()), DomainReflectiveType.computeFlags(domainClass));
        this.evaluationPackage = evaluationPackage;
        this.domainClass = domainClass;
    }

    @Override
    @NonNull
    protected AbstractFragment createFragment(@NonNull CompleteInheritance baseInheritance) {
        return new DomainReflectiveFragment(this, baseInheritance);
    }

    @Override
    @NonNull
    public Type getCommonType(@NonNull IdResolver idResolver, @NonNull Type type) {
        if (this == type) {
            return this.getPivotClass();
        }
        DomainReflectiveType firstInheritance = this;
        CompleteInheritance secondInheritance = type.getInheritance(idResolver.getStandardLibrary());
        CompleteInheritance commonInheritance = firstInheritance.getCommonInheritance(secondInheritance);
        return commonInheritance.getPivotClass();
    }

    @Override
    @NonNull
    public Iterable<? extends CompleteInheritance> getInitialSuperInheritances() {
        List<Class> superClasses = this.domainClass.getSuperClasses();
        final Iterator iterator = superClasses.iterator();
        return new Iterable<CompleteInheritance>(){

            @Override
            public Iterator<CompleteInheritance> iterator() {
                return new Iterator<CompleteInheritance>(){
                    @NonNull
                    private StandardLibrary standardLibrary;
                    private boolean gotOne;
                    {
                        this.standardLibrary = (this).DomainReflectiveType.this.evaluationPackage.getStandardLibrary();
                        this.gotOne = false;
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.gotOne || iterator.hasNext();
                    }

                    @Override
                    public CompleteInheritance next() {
                        Type next = null;
                        if (!this.gotOne) {
                            this.gotOne = true;
                            if (!iterator.hasNext()) {
                                next = this.standardLibrary.getOclAnyType();
                            }
                        }
                        if (next == null) {
                            next = (Class)iterator.next();
                        }
                        return next.getInheritance(this.standardLibrary);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    @NonNull
    public List<Class> getSuperClasses() {
        return this.domainClass.getSuperClasses();
    }

    @Override
    @Nullable
    public Operation getMemberOperation(@NonNull OperationId operationId) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Property getMemberProperty(@NonNull String name) {
        DomainProperties allProperties2 = this.allProperties;
        if (allProperties2 == null) {
            this.allProperties = allProperties2 = new DomainProperties(this);
        }
        return allProperties2.getMemberProperty(name);
    }

    @Override
    @NonNull
    public String getMetaTypeName() {
        return this.domainClass.getMetaTypeName();
    }

    @Override
    @NonNull
    public List<Constraint> getOwnedInvariants() {
        return this.domainClass.getOwnedInvariants();
    }

    @Override
    @NonNull
    public List<Operation> getOwnedOperations() {
        return this.domainClass.getOwnedOperations();
    }

    @Override
    @NonNull
    public List<Property> getOwnedProperties() {
        return this.domainClass.getOwnedProperties();
    }

    @Override
    @NonNull
    public List<Constraint> getOwnedConstraints() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Package getOwningPackage() {
        return this.evaluationPackage;
    }

    @Override
    @NonNull
    public Class getPivotClass() {
        return this.domainClass;
    }

    @Override
    @NonNull
    public TypeId getTypeId() {
        return this.domainClass.getTypeId();
    }

    @Override
    @NonNull
    public TemplateParameters getTypeParameters() {
        return this.domainClass.getTypeParameters();
    }

    @Override
    public boolean isOrdered() {
        return this.domainClass.isOrdered();
    }

    @Override
    public boolean isUnique() {
        return this.domainClass.isUnique();
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.evaluationPackage)) + "::" + String.valueOf(this.name);
    }
}

