/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractIterationManager;
import org.eclipse.ocl.pivot.library.LibraryTernaryOperation;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;

public class ExecutorDoubleIterationManager
extends AbstractIterationManager {
    @NonNull
    protected final TypeId returnTypeId;
    @NonNull
    protected final LibraryTernaryOperation body;
    @Nullable
    private Object accumulatorValue;
    @NonNull
    protected final CollectionValue collectionValue;
    @NonNull
    private Iterator<? extends Object> iteratorValue1;
    @NonNull
    private final Iterator<? extends Object> iteratorValue2;
    private Object currentValue1;
    private Object currentValue2;

    public ExecutorDoubleIterationManager(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @NonNull LibraryTernaryOperation body, @Nullable CollectionValue collectionValue, @Nullable Object accumulatorValue) {
        super(evaluator);
        this.returnTypeId = returnTypeId;
        this.body = body;
        this.accumulatorValue = accumulatorValue;
        this.collectionValue = ValueUtil.asCollectionValue(collectionValue);
        this.iteratorValue1 = this.collectionValue.iterator();
        this.iteratorValue2 = this.collectionValue.iterator();
        this.currentValue1 = this.iteratorValue1.hasNext() ? this.iteratorValue1.next() : null;
        this.currentValue2 = this.iteratorValue2.hasNext() ? this.iteratorValue2.next() : null;
    }

    @Override
    public boolean advanceIterators() {
        if (this.iteratorValue1.hasNext()) {
            this.currentValue1 = this.iteratorValue1.next();
        } else if (this.iteratorValue2.hasNext()) {
            this.currentValue2 = this.iteratorValue2.next();
            this.iteratorValue1 = this.collectionValue.iterator();
            this.currentValue1 = this.iteratorValue1.hasNext() ? this.iteratorValue1.next() : null;
        } else {
            this.currentValue1 = null;
            this.currentValue2 = null;
        }
        return this.currentValue1 != null;
    }

    @Override
    @Nullable
    public Object evaluateBody() {
        return this.body.evaluate(this.evaluator, this.returnTypeId, this.accumulatorValue, ClassUtil.nonNullState(this.currentValue1), ClassUtil.nonNullState(this.currentValue2));
    }

    @Override
    @Nullable
    public Object getAccumulatorValue() {
        return this.accumulatorValue;
    }

    @Override
    @NonNull
    public CollectionValue getSourceCollection() {
        return this.collectionValue;
    }

    @Override
    public boolean hasCurrent() {
        return this.currentValue1 != null;
    }

    @Override
    @Nullable
    public Object updateAccumulator(Object newValue) {
        this.accumulatorValue = newValue;
        return null;
    }
}

