/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationLogger;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.Value;

public abstract class ExecutorManager
implements Evaluator {
    private static final int DEFAULT_REGEX_CACHE_LIMIT = 16;
    private static final float DEFAULT_REGEX_CACHE_LOAD_FACTOR = 0.75f;
    @NonNull
    protected final CompleteEnvironment environment;
    @NonNull
    protected final StandardLibrary standardLibrary;
    private boolean isCanceled = false;
    private Map<String, Pattern> regexPatterns = null;

    public ExecutorManager(@NonNull CompleteEnvironment environment) {
        this.environment = environment;
        this.standardLibrary = environment.getOwnedStandardLibrary();
    }

    @NonNull
    protected Map<String, Pattern> createRegexCache() {
        return new LinkedHashMap<String, Pattern>(16, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
                return this.size() > 16;
            }
        };
    }

    @Override
    public void dispose() {
    }

    @Override
    @NonNull
    public Value evaluate(@NonNull OCLExpression body) {
        throw new UnsupportedOperationException();
    }

    public Value evaluateIteration(Type returnType, CollectionValue sourceVal, TypedElement accumulator, OCLExpression body, TypedElement[] iterators) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public CompleteEnvironment getCompleteEnvironment() {
        return this.environment;
    }

    @Override
    public int getDiagnosticSeverity(int severityPreference, @Nullable Object resultValue) {
        if (resultValue == null) {
            return 4;
        }
        if (resultValue instanceof InvalidValueException) {
            return 8;
        }
        return severityPreference;
    }

    @NonNull
    public Type getDynamicTypeOf(@Nullable Object value) {
        return this.getIdResolver().getDynamicTypeOf(value);
    }

    @Override
    @NonNull
    public EvaluationEnvironment getEvaluationEnvironment() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public EvaluationLogger getLogger() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Pattern getRegexPattern(@NonNull String regex) {
        Object object;
        if (this.regexPatterns == null) {
            object = this;
            synchronized (object) {
                if (this.regexPatterns == null) {
                    this.regexPatterns = this.createRegexCache();
                }
            }
        }
        object = this.regexPatterns;
        synchronized (object) {
            Pattern pattern = this.regexPatterns.get(regex);
            if (pattern == null) {
                pattern = Pattern.compile(regex);
                assert (pattern != null);
                this.regexPatterns.put(regex, pattern);
            }
            return pattern;
        }
    }

    @Override
    public int getSeverity(@Nullable Object validationKey) {
        return 2;
    }

    @Override
    @NonNull
    public StandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    @Override
    @NonNull
    public Class getStaticTypeOf(@Nullable Object value) {
        return this.getIdResolver().getStaticTypeOf(value);
    }

    @Override
    @NonNull
    public Class getStaticTypeOf(@Nullable Object value, Object ... values) {
        return this.getIdResolver().getStaticTypeOf(value, values);
    }

    @Override
    @NonNull
    public Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        return this.getIdResolver().getStaticTypeOf(value, values);
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    @Override
    public void setLogger(@Nullable EvaluationLogger logger) {
    }
}

