/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractIterationManager;
import org.eclipse.ocl.pivot.library.LibraryBinaryOperation;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;

public class ExecutorSingleIterationManager
extends AbstractIterationManager {
    @NonNull
    protected final CollectionValue collectionValue;
    @NonNull
    protected final TypeId returnTypeId;
    @NonNull
    protected final LibraryBinaryOperation body;
    @Nullable
    private Object accumulatorValue;
    @NonNull
    protected final Iterator<? extends Object> iteratorValue;
    private Object currentValue;

    public ExecutorSingleIterationManager(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @NonNull LibraryBinaryOperation body, @Nullable CollectionValue value, @Nullable Object accumulatorValue) {
        super(evaluator);
        this.collectionValue = ValueUtil.asCollectionValue(value);
        this.returnTypeId = returnTypeId;
        this.body = body;
        this.updateAccumulator(accumulatorValue);
        this.iteratorValue = this.collectionValue.iterator();
        this.advanceIterators();
    }

    protected ExecutorSingleIterationManager(@NonNull ExecutorSingleIterationManager iterationManager, @NonNull CollectionValue collectionValue) {
        super(iterationManager.getEvaluator());
        this.collectionValue = collectionValue;
        this.returnTypeId = iterationManager.returnTypeId;
        this.body = iterationManager.body;
        this.accumulatorValue = iterationManager.accumulatorValue;
        this.iteratorValue = collectionValue.iterator();
        this.advanceIterators();
    }

    @Override
    public boolean advanceIterators() {
        Object object = this.currentValue = this.iteratorValue.hasNext() ? this.iteratorValue.next() : this.iteratorValue;
        return this.currentValue != this.iteratorValue;
    }

    @Override
    @NonNull
    public IterationManager createNestedIterationManager(@NonNull CollectionValue value) {
        return new Nested(this, value);
    }

    @Override
    @Nullable
    public Object evaluateBody() {
        return this.body.evaluate(this.evaluator, this.returnTypeId, this.accumulatorValue, this.get());
    }

    @Override
    @Nullable
    public Object get() {
        return this.currentValue;
    }

    @Override
    @Nullable
    public Object getAccumulatorValue() {
        return this.accumulatorValue;
    }

    public int getDepth() {
        return 0;
    }

    @NonNull
    public ExecutorSingleIterationManager getRootIterationManager() {
        return this;
    }

    @Override
    @NonNull
    public CollectionValue getSourceCollection() {
        return this.collectionValue;
    }

    @Override
    public boolean hasCurrent() {
        return this.currentValue != this.iteratorValue;
    }

    @Override
    @Nullable
    public Object updateAccumulator(Object newValue) {
        this.accumulatorValue = newValue;
        return null;
    }

    class Nested
    extends ExecutorSingleIterationManager {
        @NonNull
        protected final ExecutorSingleIterationManager rootIterationManager;
        protected final int depth;

        protected Nested(@NonNull ExecutorSingleIterationManager iterationManager, CollectionValue value) {
            super(iterationManager, value);
            this.rootIterationManager = iterationManager.getRootIterationManager();
            this.depth = iterationManager.getDepth() + 1;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        @NonNull
        public ExecutorSingleIterationManager getRootIterationManager() {
            return this.rootIterationManager;
        }

        @Override
        @NonNull
        public CollectionValue getSourceCollection() {
            return this.rootIterationManager.getSourceCollection();
        }
    }
}

