/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.internal.lookup.LookupEnvironment;
import org.eclipse.ocl.pivot.internal.lookup.SingleResultEnvironment;
import org.eclipse.ocl.pivot.internal.scoping.ScopeFilter;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class SingleResultEnvironmentImpl
implements SingleResultEnvironment {
    private static final Logger logger = Logger.getLogger(SingleResultEnvironmentImpl.class);
    @NonNull
    private List<NamedElement> elements = new ArrayList<NamedElement>();
    @NonNull
    private String name;
    @NonNull
    private Evaluator evaluator;
    @NonNull
    private static LinkedHashMap<Class<?>, List<Comparator<Object>>> disambiguatorMap = new LinkedHashMap();
    @NonNull
    protected final EnvironmentFactory envFactory;
    private List<ScopeFilter> matchers = null;
    private Set<ScopeFilter> resolvers = null;

    static {
        SingleResultEnvironmentImpl.addDisambiguator(Object.class, new ImplicitDisambiguator());
        SingleResultEnvironmentImpl.addDisambiguator(Feature.class, new MetamodelMergeDisambiguator());
        SingleResultEnvironmentImpl.addDisambiguator(Operation.class, new OperationDisambiguator());
        SingleResultEnvironmentImpl.addDisambiguator(Package.class, new MergedPackageDisambiguator());
        SingleResultEnvironmentImpl.addDisambiguator(Property.class, new PropertyDisambiguator());
    }

    public SingleResultEnvironmentImpl(@NonNull EnvironmentFactory envFactory, @NonNull Evaluator evaluator, @NonNull String name) {
        this.evaluator = evaluator;
        this.name = name;
        this.envFactory = envFactory;
    }

    @Override
    @NonNull
    public LookupEnvironment addElement(@Nullable NamedElement namedElement) {
        if (namedElement != null && this.name.equals(namedElement.getName()) && !this.elements.contains(namedElement)) {
            this.elements.add(namedElement);
        }
        return this;
    }

    @Override
    @NonNull
    public LookupEnvironment addElements(@Nullable Collection<NamedElement> namedElements) {
        if (namedElements != null) {
            for (NamedElement namedElement : namedElements) {
                this.addElement(namedElement);
            }
        }
        return this;
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    @Override
    @Nullable
    public NamedElement getSingleResult() {
        int contentsSize = this.elements.size();
        if (contentsSize > 1) {
            logger.warn((Object)("Unhandled ambiguous content for '" + this.name + "'"));
        }
        return contentsSize == 0 ? null : this.elements.get(0);
    }

    @Override
    @NonNull
    public List<NamedElement> getAllResults() {
        return this.elements;
    }

    @Override
    public boolean hasFinalResult() {
        return this.elements.size() != 0;
    }

    @Override
    @NonNull
    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public static synchronized <T> void addDisambiguator(@NonNull Class<T> targetClass, @NonNull Comparator<T> disambiguator) {
        List<Comparator<Object>> disambiguators = disambiguatorMap.get(targetClass);
        if (disambiguators == null) {
            disambiguators = new ArrayList<Comparator<Object>>();
            disambiguatorMap.put(targetClass, disambiguators);
        }
        Comparator<T> castDisambiguator = disambiguator;
        disambiguators.add(castDisambiguator);
    }

    @NonNull
    public static Iterable<Class<?>> getDisambiguatorKeys() {
        return disambiguatorMap.keySet();
    }

    @Nullable
    public static List<Comparator<Object>> getDisambiguators(@NonNull Class<?> key) {
        return disambiguatorMap.get(key);
    }

    public void addFilter(@NonNull ScopeFilter filter) {
        if (this.matchers == null) {
            this.matchers = new ArrayList<ScopeFilter>();
        }
        this.matchers.add(filter);
    }

    public void removeFilter(@NonNull ScopeFilter filter) {
        if (this.matchers != null) {
            this.matchers.remove(filter);
        }
    }

    @NonNull
    public SingleResultEnvironmentImpl resolveDuplicates() {
        if (this.elements.size() > 1) {
            if (this.matchers != null) {
                if (this.resolvers == null) {
                    this.resolvers = new HashSet<ScopeFilter>();
                }
                this.resolvers.addAll(this.matchers);
            }
            int i = 0;
            while (i < this.elements.size() - 1) {
                boolean iRemoved = false;
                NamedElement iValue = this.elements.get(i);
                int j = i + 1;
                while (j < this.elements.size()) {
                    Class<?> iClass = iValue.getClass();
                    NamedElement jValue = this.elements.get(j);
                    Class<?> jClass = jValue.getClass();
                    int verdict = 0;
                    for (Class<?> key : disambiguatorMap.keySet()) {
                        if (!key.isAssignableFrom(iClass) || !key.isAssignableFrom(jClass)) continue;
                        for (Comparator<Object> comparator : disambiguatorMap.get(key)) {
                            verdict = comparator instanceof Disambiguator ? ((Disambiguator)comparator).compare(this.envFactory, iValue, jValue) : comparator.compare(iValue, jValue);
                            if (verdict != 0) break;
                        }
                        if (verdict != 0) break;
                    }
                    if (verdict == 0) {
                        ++j;
                        continue;
                    }
                    if (verdict < 0) {
                        this.elements.remove(i);
                        iRemoved = true;
                        break;
                    }
                    this.elements.remove(j);
                }
                if (iRemoved) continue;
                ++i;
            }
        }
        return this;
    }

    public static abstract class Disambiguator<T>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            throw new UnsupportedOperationException();
        }

        public abstract int compare(@NonNull EnvironmentFactory var1, @NonNull T var2, @NonNull T var3);
    }

    private static final class ImplicitDisambiguator
    extends Disambiguator<Object> {
        private ImplicitDisambiguator() {
        }

        @Override
        public int compare(@NonNull EnvironmentFactory environmentFactory, @NonNull Object match1, @NonNull Object match2) {
            boolean match2IsImplicit;
            boolean match1IsImplicit = match1 instanceof Property && ((Property)match1).isIsImplicit();
            boolean bl = match2IsImplicit = match2 instanceof Property && ((Property)match2).isIsImplicit();
            if (!match1IsImplicit) {
                return match2IsImplicit ? 1 : 0;
            }
            return match2IsImplicit ? 0 : -1;
        }
    }

    private static final class MergedPackageDisambiguator
    extends Disambiguator<Package> {
        private MergedPackageDisambiguator() {
        }

        @Override
        public int compare(@NonNull EnvironmentFactory environmentFactory, @NonNull Package match1, @NonNull Package match2) {
            CompletePackage completePackage2;
            CompleteModel completeModel = environmentFactory.getCompleteModel();
            CompletePackage completePackage1 = completeModel.getCompletePackage(match1);
            if (completePackage1 == (completePackage2 = completeModel.getCompletePackage(match2))) {
                return 1;
            }
            return 0;
        }
    }

    private static final class MetamodelMergeDisambiguator
    extends Disambiguator<Feature> {
        private MetamodelMergeDisambiguator() {
        }

        @Override
        public int compare(@NonNull EnvironmentFactory environmentFactory, @NonNull Feature match1, @NonNull Feature match2) {
            CompletePackage s2;
            Package p1 = PivotUtil.getContainingPackage(match1);
            Package p2 = PivotUtil.getContainingPackage(match2);
            if (p1 == null) {
                return 0;
            }
            if (p2 == null) {
                return 0;
            }
            CompleteModel completeModel = environmentFactory.getCompleteModel();
            CompletePackage s1 = completeModel.getCompletePackage(p1);
            if (s1 != (s2 = completeModel.getCompletePackage(p2))) {
                return 0;
            }
            int i1 = s1.getIndex(p1);
            int i2 = s2.getIndex(p2);
            return i2 - i1;
        }
    }

    private static final class OperationDisambiguator
    extends Disambiguator<Operation> {
        private OperationDisambiguator() {
        }

        @Override
        public int compare(@NonNull EnvironmentFactory environmentFactory, @NonNull Operation match1, @NonNull Operation match2) {
            if (this.isRedefinitionOf(match1, match2)) {
                return 1;
            }
            if (this.isRedefinitionOf(match2, match1)) {
                return -1;
            }
            return 0;
        }

        protected boolean isRedefinitionOf(@NonNull Operation operation1, @NonNull Operation operation2) {
            List<Operation> redefinedOperations = operation1.getRedefinedOperations();
            for (Operation redefinedOperation : redefinedOperations) {
                if (redefinedOperation == null) continue;
                if (redefinedOperation == operation2) {
                    return true;
                }
                if (!this.isRedefinitionOf(redefinedOperation, operation2)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class PropertyDisambiguator
    extends Disambiguator<Property> {
        private PropertyDisambiguator() {
        }

        @Override
        public int compare(@NonNull EnvironmentFactory environmentFactory, @NonNull Property match1, @NonNull Property match2) {
            if (this.isRedefinitionOf(match1, match2)) {
                return 1;
            }
            if (this.isRedefinitionOf(match2, match1)) {
                return -1;
            }
            return 0;
        }

        protected boolean isRedefinitionOf(@NonNull Property property1, @NonNull Property property2) {
            List<Property> redefinedProperties = property1.getRedefinedProperties();
            for (Property redefinedProperty : redefinedProperties) {
                if (redefinedProperty == null) continue;
                if (redefinedProperty == property2) {
                    return true;
                }
                if (!this.isRedefinitionOf(redefinedProperty, property2)) continue;
                return true;
            }
            return false;
        }
    }
}

