/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.internal.PackageImpl;
import org.eclipse.ocl.pivot.internal.resource.ASResourceImpl;
import org.eclipse.ocl.pivot.internal.resource.OCLASResourceFactory;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class Orphanage
extends PackageImpl {
    @NonNull
    public static final URI ORPHANAGE_URI = ClassUtil.nonNullEMF(URI.createURI((String)"http://www.eclipse.org/ocl/2015/Orphanage"));
    private static Orphanage INSTANCE = null;

    public static void disposeInstance() {
        if (INSTANCE != null) {
            INSTANCE.dispose();
            INSTANCE = null;
        }
    }

    @Nullable
    public static Orphanage getOrphanage(@NonNull EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        return Orphanage.getOrphanage(resourceSet);
    }

    @NonNull
    public static Orphanage getOrphanage(@Nullable ResourceSet resourceSet) {
        if (resourceSet == null) {
            Orphanage instance2 = INSTANCE;
            if (instance2 == null) {
                instance2 = INSTANCE = new Orphanage("$$", "http://www.eclipse.org/ocl/2015/Orphanage");
            }
            return instance2;
        }
        for (Resource aResource : resourceSet.getResources()) {
            for (EObject eContent : aResource.getContents()) {
                if (!(eContent instanceof Model)) continue;
                for (Package asPackage : ((Model)eContent).getOwnedPackages()) {
                    if (!(asPackage instanceof Orphanage)) continue;
                    return (Orphanage)asPackage;
                }
            }
        }
        Orphanage orphanage = new Orphanage("$$", "http://www.eclipse.org/ocl/2015/Orphanage");
        Model orphanModel = PivotFactory.eINSTANCE.createModel();
        orphanModel.setName("$$");
        orphanModel.setExternalURI("http://www.eclipse.org/ocl/2015/Orphanage");
        orphanModel.getOwnedPackages().add(orphanage);
        OrphanResource orphanageResource = new OrphanResource(ORPHANAGE_URI);
        orphanageResource.getContents().add((Object)orphanModel);
        resourceSet.getResources().add((Object)orphanageResource);
        return orphanage;
    }

    public static boolean isTypeOrphanage(@Nullable Package asPackage) {
        if (asPackage == null) {
            return false;
        }
        String uri = asPackage.getURI();
        return "http://www.eclipse.org/ocl/2015/Orphanage".equals(uri) || "http://www.eclipse.org/ocl/3.1.0/orphanage".equals(uri);
    }

    public Orphanage(@NonNull String name, @NonNull String nsURI) {
        this.setName(name);
        this.setURI(nsURI);
    }

    public void dispose() {
        if (this.ownedClasses != null) {
            ((WeakEList)this.ownedClasses).dispose();
        }
    }

    @NonNull
    public EList<Class> getOwnedClasses() {
        Object ownedType2 = this.ownedClasses;
        if (ownedType2 == null) {
            ownedType2 = this.ownedClasses = new WeakEList();
        }
        return ownedType2;
    }

    protected static class OrphanResource
    extends ASResourceImpl {
        protected OrphanResource(@NonNull URI uri) {
            super(uri, OCLASResourceFactory.getInstance());
        }

        protected void doUnload() {
            if (this.contents != null) {
                for (EObject aContent : this.contents) {
                    if (!(aContent instanceof Orphanage)) continue;
                    ((Orphanage)aContent).dispose();
                }
                this.contents = null;
            }
        }
    }

    private static class WeakEList<T>
    extends AbstractEList<T>
    implements InternalEList<T> {
        @NonNull
        private final WeakHashMap<T, Integer> weakMap = new WeakHashMap();
        private int counter = 0;
        @Nullable
        private List<Map.Entry<T, Integer>> weakList = null;

        private WeakEList() {
        }

        public boolean addAllUnique(Object[] objects, int start, int end) {
            throw new UnsupportedOperationException();
        }

        public boolean addAllUnique(int index, Object[] objects, int start, int end) {
            throw new UnsupportedOperationException();
        }

        public boolean addAllUnique(Collection<? extends T> collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAllUnique(int index, Collection<? extends T> collection) {
            throw new UnsupportedOperationException();
        }

        public void addUnique(T object) {
            throw new UnsupportedOperationException();
        }

        public void addUnique(int index, T object) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain basicAdd(T object, NotificationChain notifications) {
            WeakHashMap<T, Integer> weakHashMap = this.weakMap;
            synchronized (weakHashMap) {
                if (!this.weakMap.containsKey(object)) {
                    this.weakMap.put(object, this.counter++);
                    this.weakList = null;
                }
            }
            return notifications;
        }

        public boolean basicContains(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean basicContainsAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        public T basicGet(int index) {
            throw new UnsupportedOperationException();
        }

        public int basicIndexOf(Object object) {
            throw new UnsupportedOperationException();
        }

        public Iterator<T> basicIterator() {
            throw new UnsupportedOperationException();
        }

        public int basicLastIndexOf(Object object) {
            throw new UnsupportedOperationException();
        }

        public List<T> basicList() {
            throw new UnsupportedOperationException();
        }

        public ListIterator<T> basicListIterator() {
            return this.listIterator();
        }

        public ListIterator<T> basicListIterator(int index) {
            return this.listIterator(index);
        }

        public NotificationChain basicRemove(Object object, NotificationChain notifications) {
            throw new UnsupportedOperationException();
        }

        public Object[] basicToArray() {
            throw new UnsupportedOperationException();
        }

        public <T2> T2[] basicToArray(T2[] array) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            WeakHashMap<T, Integer> weakHashMap = this.weakMap;
            synchronized (weakHashMap) {
                this.weakMap.clear();
                this.weakList = null;
            }
        }

        public T get(int index) {
            List<Map.Entry<T, Integer>> weakList2 = this.getList();
            return weakList2.get(index).getKey();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        private List<Map.Entry<T, Integer>> getList() {
            List<Map.Entry<T, Integer>> weakList2;
            WeakHashMap<T, Integer> weakHashMap = this.weakMap;
            synchronized (weakHashMap) {
                weakList2 = this.weakList;
                if (weakList2 == null) {
                    weakList2 = this.weakList = new ArrayList<Map.Entry<T, Integer>>(this.weakMap.entrySet());
                    Collections.sort(weakList2, new Comparator<Map.Entry<T, Integer>>(){

                        @Override
                        public int compare(Map.Entry<T, Integer> o1, Map.Entry<T, Integer> o2) {
                            return o1.getValue() - o2.getValue();
                        }
                    });
                }
            }
            return weakList2;
        }

        public boolean isEmpty() {
            return this.weakMap.size() == 0;
        }

        public Iterator<T> iterator() {
            return this.listIterator();
        }

        @NonNull
        public ListIterator<T> listIterator() {
            return new ListIterator<T>(this.getList(), 0);
        }

        @NonNull
        public ListIterator<T> listIterator(int index) {
            return new ListIterator<T>(this.getList(), index);
        }

        public void move(int newPosition, T object) {
            throw new UnsupportedOperationException();
        }

        public T move(int newPosition, int oldPosition) {
            throw new UnsupportedOperationException();
        }

        protected T primitiveGet(int index) {
            throw new UnsupportedOperationException();
        }

        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        public T setUnique(int index, T object) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.weakMap.size();
        }

        public String toString() {
            return this.weakMap.toString();
        }

        protected static class ListIterator<T>
        implements java.util.ListIterator<T> {
            @NonNull
            protected final List<Map.Entry<T, Integer>> list;
            private final int size;
            private int cursor;

            public ListIterator(@NonNull List<Map.Entry<T, Integer>> list, int index) {
                this.list = list;
                this.size = list.size();
                this.cursor = index;
                if (this.cursor < 0 || this.size < this.cursor) {
                    throw new NoSuchElementException(String.valueOf(this.cursor) + "/" + this.size);
                }
            }

            @Override
            public void add(T o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.cursor < this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            @Override
            public T next() {
                if (this.cursor < 0 || this.size <= this.cursor) {
                    throw new NoSuchElementException(String.valueOf(this.cursor) + "/" + this.size);
                }
                return this.list.get(this.cursor++).getKey();
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public T previous() {
                int previousCursor = this.cursor - 1;
                if (previousCursor < 0 || this.size <= previousCursor) {
                    throw new NoSuchElementException(String.valueOf(previousCursor) + "/" + this.size);
                }
                this.cursor = previousCursor;
                return this.list.get(previousCursor).getKey();
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(T o) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

