/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.InvalidLiteralExp;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.Slot;
import org.eclipse.ocl.pivot.State;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.WildcardType;
import org.eclipse.ocl.pivot.internal.PackageImpl;
import org.eclipse.ocl.pivot.internal.compatibility.EMF_2_9;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteEnvironmentInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteInheritanceImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.context.ClassContext;
import org.eclipse.ocl.pivot.internal.context.OperationContext;
import org.eclipse.ocl.pivot.internal.context.PropertyContext;
import org.eclipse.ocl.pivot.internal.ecore.EcoreASResourceFactory;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.library.ConstrainedOperation;
import org.eclipse.ocl.pivot.internal.library.EInvokeOperation;
import org.eclipse.ocl.pivot.internal.library.ImplementationManager;
import org.eclipse.ocl.pivot.internal.library.StandardLibraryContribution;
import org.eclipse.ocl.pivot.internal.manager.FinalAnalysis;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.internal.manager.PrecedenceManager;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.manager.TupleTypeManager;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.AS2XMIid;
import org.eclipse.ocl.pivot.internal.utilities.CompleteElementIterable;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.internal.utilities.IllegalLibraryException;
import org.eclipse.ocl.pivot.internal.utilities.PivotConstantsInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.library.LibraryProperty;
import org.eclipse.ocl.pivot.library.UnsupportedOperation;
import org.eclipse.ocl.pivot.model.OCLmetamodel;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.pivot.utilities.TypeUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class PivotMetamodelManager
implements MetamodelManagerInternal,
Adapter.Internal {
    private static final Logger logger = Logger.getLogger(PivotMetamodelManager.class);
    @NonNull
    public static final List<Constraint> EMPTY_CONSTRAINT_LIST = Collections.emptyList();
    @NonNull
    public static final List<Element> EMPTY_ELEMENT_LIST = Collections.emptyList();
    @NonNull
    public static final List<Operation> EMPTY_OPERATION_LIST = Collections.emptyList();
    @NonNull
    public static final List<Property> EMPTY_PROPERTY_LIST = Collections.emptyList();
    @NonNull
    public static final List<State> EMPTY_STATE_LIST = Collections.emptyList();
    @NonNull
    public static final List<TemplateParameter> EMPTY_TEMPLATE_PARAMETER_LIST = Collections.emptyList();
    @NonNull
    public static final List<Type> EMPTY_TYPE_LIST = Collections.emptyList();
    public static WeakHashMap<PivotMetamodelManager, Object> liveMetamodelManagers = null;
    @NonNull
    protected final EnvironmentFactoryInternal environmentFactory;
    @NonNull
    private final StandardLibraryInternal standardLibrary;
    @NonNull
    private final CompleteEnvironmentInternal completeEnvironment;
    @NonNull
    private final CompleteModelInternal completeModel;
    private PrecedenceManager precedenceManager = null;
    private ImplementationManager implementationManager = null;
    protected Package asMetamodel = null;
    private boolean libraryLoadInProgress = false;
    @NonNull
    protected final ResourceSet asResourceSet;
    @NonNull
    protected final List<Library> asLibraries = new ArrayList<Library>();
    @Nullable
    protected Resource asLibraryResource = null;
    @NonNull
    private final Map<String, Namespace> globalNamespaces = new HashMap<String, Namespace>();
    @NonNull
    private final Set<Type> globalTypes = new HashSet<Type>();
    @NonNull
    private final Map<URI, External2AS> external2asMap = new HashMap<URI, External2AS>();
    @Nullable
    private EAnnotation lockingAnnotation = null;
    private boolean autoLoadASmetamodel = true;
    @Nullable
    private Map<String, GenPackage> genPackageMap = null;
    @Nullable
    private FinalAnalysis finalAnalysis = null;
    @Nullable
    private Map<Resource, External2AS> es2ases = null;

    @Nullable
    public static PivotMetamodelManager findAdapter(@NonNull ResourceSet asResourceSet) {
        EList eAdapters = asResourceSet.eAdapters();
        return ClassUtil.getAdapter(PivotMetamodelManager.class, (List<Adapter>)eAdapters);
    }

    @NonNull
    public static PivotMetamodelManager getAdapter(@NonNull ResourceSet asResourceSet) {
        EList eAdapters = asResourceSet.eAdapters();
        PivotMetamodelManager adapter = ClassUtil.getAdapter(PivotMetamodelManager.class, (List<Adapter>)eAdapters);
        return ClassUtil.nonNullState(adapter);
    }

    public PivotMetamodelManager(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull ResourceSet asResourceSet) {
        this.environmentFactory = environmentFactory;
        this.asResourceSet = asResourceSet;
        EList asResourceSetAdapters = asResourceSet.eAdapters();
        assert (!asResourceSetAdapters.contains(this));
        asResourceSetAdapters.add(this);
        assert (asResourceSetAdapters.contains(environmentFactory.getProjectManager()));
        this.completeEnvironment = environmentFactory.getCompleteEnvironment();
        this.standardLibrary = environmentFactory.getStandardLibrary();
        this.completeModel = environmentFactory.getCompleteModel();
        if (liveMetamodelManagers != null) {
            liveMetamodelManagers.put(this, null);
            PivotUtilInternal.debugPrintln("Create " + NameUtil.debugSimpleName(this) + " " + NameUtil.debugSimpleName(asResourceSet));
        }
    }

    @Override
    public void addClassLoader(@NonNull ClassLoader classLoader) {
        ImplementationManager implementationManager = this.getImplementationManager();
        implementationManager.addClassLoader(classLoader);
    }

    @Override
    public void addExternal2AS(@NonNull External2AS es2as) {
        Map<Resource, External2AS> es2ases2 = this.es2ases;
        if (es2ases2 == null) {
            this.es2ases = es2ases2 = new HashMap<Resource, External2AS>();
        }
        External2AS oldES2AS = es2ases2.put(es2as.getResource(), es2as);
        assert (oldES2AS == null);
        URI uri = es2as.getURI();
        this.external2asMap.put(uri, es2as);
    }

    @Override
    public void addGenModel(@NonNull GenModel genModel) {
        for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
            this.addGenPackage(genPackage);
        }
    }

    public void addGenPackage(@NonNull GenPackage genPackage) {
        Map<String, GenPackage> genPackageMap2 = this.genPackageMap;
        if (genPackageMap2 == null) {
            this.genPackageMap = genPackageMap2 = new HashMap<String, GenPackage>();
        }
        genPackageMap2.put(genPackage.getNSURI(), genPackage);
    }

    @Override
    @Nullable
    public Namespace addGlobalNamespace(@NonNull String name, @NonNull Namespace namespace) {
        return this.globalNamespaces.put(name, namespace);
    }

    public boolean addGlobalTypes(@NonNull Collection<Type> types) {
        return this.globalTypes.addAll(types);
    }

    @Override
    public void addLockedElement(@NonNull Object lockedElement) {
        if (lockedElement instanceof EObject) {
            EList lockingReferences;
            EAnnotation lockingAnnotation2 = this.lockingAnnotation;
            if (lockingAnnotation2 == null) {
                this.lockingAnnotation = lockingAnnotation2 = EcoreFactory.eINSTANCE.createEAnnotation();
            }
            if (!(lockingReferences = lockingAnnotation2.getReferences()).contains(lockedElement)) {
                lockingReferences.add((EObject)lockedElement);
            }
        }
    }

    public void assignLibraryIds(@NonNull AS2XMIid as2xmIid, @Nullable Map<?, ?> options) {
        for (Library asLibrary : this.asLibraries) {
            Resource eResource = asLibrary.eResource();
            if (!(eResource instanceof ASResource)) continue;
            as2xmIid.assignIds((ASResource)eResource, options);
        }
    }

    public int compareOperationMatches(@NonNull Operation reference, @NonNull TemplateParameterSubstitutions referenceBindings, @NonNull Operation candidate, @NonNull TemplateParameterSubstitutions candidateBindings) {
        if (reference instanceof Iteration && candidate instanceof Iteration) {
            Type specializedCandidateType;
            int iteratorCountDelta = ((Iteration)candidate).getOwnedIterators().size() - ((Iteration)reference).getOwnedIterators().size();
            if (iteratorCountDelta != 0) {
                return iteratorCountDelta;
            }
            Class referenceClass = reference.getOwningClass();
            Class candidateClass = candidate.getOwningClass();
            Type referenceType = referenceClass != null ? PivotUtilInternal.getType(referenceClass) : null;
            Type candidateType = candidateClass != null ? PivotUtilInternal.getType(candidateClass) : null;
            Type specializedReferenceType = referenceType != null ? this.completeModel.getSpecializedType(referenceType, referenceBindings) : null;
            Type type = specializedCandidateType = candidateType != null ? this.completeModel.getSpecializedType(candidateType, candidateBindings) : null;
            if (referenceType != candidateType && specializedReferenceType != null && specializedCandidateType != null) {
                if (this.conformsTo(specializedReferenceType, referenceBindings, specializedCandidateType, candidateBindings)) {
                    return 1;
                }
                if (this.conformsTo(specializedCandidateType, candidateBindings, specializedReferenceType, referenceBindings)) {
                    return -1;
                }
            }
        }
        List<Parameter> candidateParameters = candidate.getOwnedParameters();
        List<Parameter> referenceParameters = reference.getOwnedParameters();
        int parameterCountDelta = candidateParameters.size() - referenceParameters.size();
        if (parameterCountDelta != 0) {
            return parameterCountDelta;
        }
        boolean referenceConformsToCandidate = true;
        boolean candidateConformsToReference = true;
        int i = 0;
        while (i < candidateParameters.size()) {
            Parameter referenceParameter = referenceParameters.get(i);
            Parameter candidateParameter = candidateParameters.get(i);
            if (referenceParameter == null || candidateParameter == null) {
                referenceConformsToCandidate = false;
                candidateConformsToReference = false;
            } else {
                Type referenceType = PivotUtilInternal.getBehavioralType(referenceParameter);
                Type candidateType = PivotUtilInternal.getBehavioralType(candidateParameter);
                Type specializedReferenceType = this.completeModel.getSpecializedType(referenceType, referenceBindings);
                Type specializedCandidateType = this.completeModel.getSpecializedType(candidateType, candidateBindings);
                if (referenceType != candidateType) {
                    if (!this.conformsTo(specializedReferenceType, referenceBindings, specializedCandidateType, candidateBindings)) {
                        referenceConformsToCandidate = false;
                    }
                    if (!this.conformsTo(specializedCandidateType, candidateBindings, specializedReferenceType, referenceBindings)) {
                        candidateConformsToReference = false;
                    }
                }
            }
            ++i;
        }
        if (referenceConformsToCandidate != candidateConformsToReference) {
            return referenceConformsToCandidate ? 1 : -1;
        }
        Type referenceType = ClassUtil.nonNullModel(reference.getOwningClass());
        Type candidateType = ClassUtil.nonNullModel(candidate.getOwningClass());
        Type specializedReferenceType = this.completeModel.getSpecializedType(referenceType, referenceBindings);
        Type specializedCandidateType = this.completeModel.getSpecializedType(candidateType, candidateBindings);
        if (referenceType != candidateType) {
            if (this.conformsTo(specializedReferenceType, referenceBindings, specializedCandidateType, candidateBindings)) {
                return 1;
            }
            if (this.conformsTo(specializedCandidateType, candidateBindings, specializedReferenceType, referenceBindings)) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public boolean conformsTo(@NonNull Type firstType, @NonNull TemplateParameterSubstitutions firstSubstitutions, @NonNull Type secondType, @NonNull TemplateParameterSubstitutions secondSubstitutions) {
        return this.completeModel.conformsTo(firstType, firstSubstitutions, secondType, secondSubstitutions);
    }

    @NonNull
    public BooleanLiteralExp createBooleanLiteralExp(boolean booleanSymbol) {
        BooleanLiteralExp asBoolean = PivotFactory.eINSTANCE.createBooleanLiteralExp();
        asBoolean.setBooleanSymbol(booleanSymbol);
        asBoolean.setType(this.standardLibrary.getBooleanType());
        asBoolean.setIsRequired(true);
        return asBoolean;
    }

    @NonNull
    public IfExp createIfExp(@NonNull OperationCallExp asCondition, @NonNull OCLExpression asThen, @NonNull OCLExpression asElse) {
        Type commonType = this.getCommonType(ClassUtil.nonNullState(asThen.getType()), TemplateParameterSubstitutions.EMPTY, ClassUtil.nonNullState(asElse.getType()), TemplateParameterSubstitutions.EMPTY);
        IfExp asIf = PivotFactory.eINSTANCE.createIfExp();
        asIf.setOwnedCondition(asCondition);
        asIf.setOwnedThen(asThen);
        asIf.setOwnedElse(asElse);
        asIf.setType(commonType);
        asIf.setIsRequired(true);
        return asIf;
    }

    @NonNull
    public IntegerLiteralExp createIntegerLiteralExp(@NonNull Number integerSymbol) {
        IntegerLiteralExp asInteger = PivotFactory.eINSTANCE.createIntegerLiteralExp();
        asInteger.setIntegerSymbol(integerSymbol);
        asInteger.setType(this.standardLibrary.getIntegerType());
        asInteger.setIsRequired(true);
        return asInteger;
    }

    @NonNull
    public InvalidLiteralExp createInvalidExpression() {
        InvalidLiteralExp invalidLiteralExp = PivotFactory.eINSTANCE.createInvalidLiteralExp();
        invalidLiteralExp.setType(this.standardLibrary.getOclInvalidType());
        return invalidLiteralExp;
    }

    @NonNull
    public NullLiteralExp createNullLiteralExp() {
        NullLiteralExp asNull = PivotFactory.eINSTANCE.createNullLiteralExp();
        asNull.setType(this.standardLibrary.getOclVoidType());
        asNull.setIsRequired(false);
        return asNull;
    }

    @NonNull
    public Orphanage createOrphanage() {
        return Orphanage.getOrphanage(this.asResourceSet);
    }

    @Override
    @Nullable
    public ParserContext createParserContext(@NonNull Element element, Object ... todoParameters) {
        EObject pivotContainer;
        Element pivotElement = element;
        if (element instanceof ExpressionInOCL) {
            Class pivotType;
            Property asDefiningFeature;
            pivotContainer = pivotElement.eContainer();
            if (pivotContainer instanceof Operation) {
                Operation pivotOperation = (Operation)pivotContainer;
                return new OperationContext((EnvironmentFactory)this.environmentFactory, null, pivotOperation, null);
            }
            if (pivotContainer instanceof Property) {
                Property pivotProperty = (Property)pivotContainer;
                return new PropertyContext(this.environmentFactory, null, pivotProperty);
            }
            if (pivotContainer instanceof Constraint) {
                EObject pivotContainerContainer = pivotContainer.eContainer();
                if (pivotContainerContainer instanceof Operation) {
                    Type resultType;
                    Operation pivotOperation = (Operation)pivotContainerContainer;
                    String resultName = null;
                    if (pivotOperation.getOwnedPostconditions().contains(pivotContainer) && (resultType = pivotOperation.getType()) != null && !(resultType instanceof VoidType)) {
                        resultName = "result";
                    }
                    return new OperationContext((EnvironmentFactory)this.environmentFactory, null, pivotOperation, resultName);
                }
                if (pivotContainerContainer instanceof Class) {
                    Class pivotType2 = (Class)pivotContainerContainer;
                    return new ClassContext(this.environmentFactory, null, pivotType2, null);
                }
            }
            if (pivotContainer instanceof Slot && (asDefiningFeature = ((Slot)pivotContainer).getDefiningProperty()) != null && (pivotType = asDefiningFeature.getOwningClass()) != null) {
                return new ClassContext(this.environmentFactory, null, pivotType, null);
            }
        }
        if (pivotElement instanceof Constraint && (pivotContainer = pivotElement.eContainer()) instanceof Operation) {
            Type resultType;
            Operation pivotOperation = (Operation)pivotContainer;
            String resultName = null;
            if (pivotOperation.getOwnedPostconditions().contains(pivotElement) && (resultType = pivotOperation.getType()) != null && !(resultType instanceof VoidType)) {
                resultName = "result";
            }
            return new OperationContext((EnvironmentFactory)this.environmentFactory, null, pivotOperation, resultName);
        }
        if (pivotElement instanceof Property) {
            return new PropertyContext(this.environmentFactory, null, (Property)pivotElement);
        }
        if (pivotElement instanceof Operation) {
            return new OperationContext((EnvironmentFactory)this.environmentFactory, null, (Operation)pivotElement, null);
        }
        if (pivotElement instanceof OppositePropertyCallExp) {
            Property referredProperty;
            Property referredOppositeProperty = ((OppositePropertyCallExp)pivotElement).getReferredProperty();
            if (referredOppositeProperty != null && (referredProperty = referredOppositeProperty.getOpposite()) != null) {
                return new PropertyContext(this.environmentFactory, null, referredProperty);
            }
        } else if (pivotElement instanceof PropertyCallExp) {
            Property referredProperty = ((PropertyCallExp)pivotElement).getReferredProperty();
            if (referredProperty != null) {
                return new PropertyContext(this.environmentFactory, null, referredProperty);
            }
        } else if (pivotElement instanceof OperationCallExp) {
            Operation referredOperation = ((OperationCallExp)pivotElement).getReferredOperation();
            if (referredOperation != null) {
                return new OperationContext((EnvironmentFactory)this.environmentFactory, null, referredOperation, null);
            }
        } else if (pivotElement instanceof LoopExp) {
            Iteration referredIteration = ((LoopExp)pivotElement).getReferredIteration();
            if (referredIteration != null) {
                return new OperationContext((EnvironmentFactory)this.environmentFactory, null, referredIteration, null);
            }
        } else {
            Element eObject = element;
            while (eObject != null) {
                if (eObject instanceof Class && ((Class)eObject).getOwningPackage() != null) {
                    return new ClassContext(this.environmentFactory, null, (Class)eObject, null);
                }
                eObject = eObject.eContainer();
            }
        }
        return null;
    }

    @NonNull
    protected PrecedenceManager createPrecedenceManager() {
        PrecedenceManager precedenceManager = new PrecedenceManager();
        List<String> errors = precedenceManager.compilePrecedences(this.asLibraries);
        for (String error : errors) {
            logger.error((Object)error);
        }
        return precedenceManager;
    }

    @NonNull
    public RealLiteralExp createRealLiteralExp(@NonNull Number realSymbol) {
        RealLiteralExp asReal = PivotFactory.eINSTANCE.createRealLiteralExp();
        asReal.setRealSymbol(realSymbol);
        asReal.setType(this.standardLibrary.getRealType());
        asReal.setIsRequired(true);
        return asReal;
    }

    @NonNull
    public StringLiteralExp createStringLiteralExp(@NonNull String stringSymbol) {
        StringLiteralExp asString = PivotFactory.eINSTANCE.createStringLiteralExp();
        asString.setStringSymbol(stringSymbol);
        asString.setType(this.standardLibrary.getStringType());
        asString.setIsRequired(true);
        return asString;
    }

    @NonNull
    public UnlimitedNaturalLiteralExp createUnlimitedNaturalLiteralExp(@NonNull Number unlimitedNaturalSymbol) {
        UnlimitedNaturalLiteralExp asUnlimitedNatural = PivotFactory.eINSTANCE.createUnlimitedNaturalLiteralExp();
        asUnlimitedNatural.setUnlimitedNaturalSymbol(unlimitedNaturalSymbol);
        asUnlimitedNatural.setType(this.standardLibrary.getUnlimitedNaturalType());
        asUnlimitedNatural.setIsRequired(true);
        return asUnlimitedNatural;
    }

    @NonNull
    public WildcardType createWildcardType(@Nullable Class lowerBound, @Nullable Class upperBound) {
        WildcardType wildcardType = PivotFactory.eINSTANCE.createWildcardType();
        wildcardType.setName("?");
        wildcardType.setLowerBound(lowerBound != null ? lowerBound : this.standardLibrary.getOclAnyType());
        wildcardType.setUpperBound(upperBound != null ? upperBound : this.standardLibrary.getOclVoidType());
        return wildcardType;
    }

    public void dispose() {
        this.asResourceSet.eAdapters().remove((Object)this);
        EList asResources = this.asResourceSet.getResources();
        for (Resource asResource : new ArrayList(asResources)) {
            asResource.unload();
            asResource.eAdapters().clear();
        }
        asResources.clear();
        this.asResourceSet.setPackageRegistry(null);
        this.asResourceSet.setResourceFactoryRegistry(null);
        this.asResourceSet.setURIConverter(null);
        this.asLibraries.clear();
        this.asLibraryResource = null;
        StandaloneProjectMap projectMap = StandaloneProjectMap.findAdapter(this.asResourceSet);
        if (projectMap != null) {
            projectMap.unload(this.asResourceSet);
        }
        this.asResourceSet.eAdapters().clear();
        this.globalNamespaces.clear();
        this.globalTypes.clear();
        this.external2asMap.clear();
        if (this.es2ases != null) {
            for (External2AS es2as : this.es2ases.values()) {
                es2as.dispose();
            }
        }
        this.lockingAnnotation = null;
        this.completeModel.dispose();
        if (this.precedenceManager != null) {
            this.precedenceManager.dispose();
            this.precedenceManager = null;
        }
        if (this.implementationManager != null) {
            this.implementationManager.dispose();
            this.implementationManager = null;
        }
        this.asMetamodel = null;
        this.standardLibrary.dispose();
    }

    protected void finalize() throws Throwable {
        if (liveMetamodelManagers != null) {
            PivotUtilInternal.debugPrintln("Finalize " + NameUtil.debugSimpleName(this));
            ArrayList<PivotMetamodelManager> keySet = new ArrayList<PivotMetamodelManager>(liveMetamodelManagers.keySet());
            if (!keySet.isEmpty()) {
                StringBuilder s = new StringBuilder();
                s.append(" live");
                for (PivotMetamodelManager metamodelManager : keySet) {
                    s.append(" @" + Integer.toHexString(metamodelManager.hashCode()));
                }
                System.out.println(s.toString());
            }
        }
    }

    @Override
    @Nullable
    public Class getASClass(@NonNull String className) {
        if (this.asMetamodel == null) {
            this.getASmetamodel();
            if (this.asMetamodel == null) {
                return null;
            }
        }
        return NameUtil.getNameable(this.asMetamodel.getOwnedClasses(), className);
    }

    @Nullable
    public Element getASElement(@NonNull URI uri) {
        if (uri.fragment() == null) {
            ASResource resource = (ASResource)this.asResourceSet.getResource(uri, true);
            return resource.getModel();
        }
        Element element = (Element)this.asResourceSet.getEObject(uri, true);
        return element;
    }

    @Override
    @Nullable
    public <T extends Element> T getASOf(@NonNull java.lang.Class<T> pivotClass, @Nullable EObject eObject) throws ParserException {
        if (eObject != null) {
            EcoreASResourceFactory bestHelper;
            Resource eResource = eObject.eResource();
            ASResourceFactory aSResourceFactory = bestHelper = eResource != null ? ASResourceFactoryRegistry.INSTANCE.getASResourceFactory(eResource) : EcoreASResourceFactory.getInstance();
            if (bestHelper != null) {
                return bestHelper.getASElement(this.environmentFactory, pivotClass, eObject);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends Element> T getASOfEcore(@NonNull java.lang.Class<T> pivotClass, @Nullable EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource metamodel = eObject.eResource();
        if (metamodel == null) {
            return null;
        }
        External2AS es2as = Ecore2AS.findAdapter(metamodel, this.environmentFactory);
        if (es2as == null) {
            es2as = Ecore2AS.getAdapter(metamodel, this.environmentFactory);
        }
        if (es2as == null) {
            return null;
        }
        return es2as.getCreated(pivotClass, eObject);
    }

    @Override
    @Nullable
    public Package getASmetamodel() {
        if (this.asMetamodel == null && this.autoLoadASmetamodel) {
            Package stdlibPackage = null;
            this.standardLibrary.getOclAnyType();
            if (!this.asLibraries.isEmpty()) {
                stdlibPackage = this.asLibraries.get(0);
            }
            if (stdlibPackage != null) {
                this.loadASmetamodel(stdlibPackage);
            }
        }
        return this.asMetamodel;
    }

    @Override
    @NonNull
    public ResourceSet getASResourceSet() {
        return this.asResourceSet;
    }

    @NonNull
    public Iterable<CompletePackageInternal> getAllCompletePackages() {
        if (!this.libraryLoadInProgress && this.asMetamodel == null) {
            this.getASmetamodel();
        }
        return this.completeModel.getAllCompletePackages();
    }

    @Override
    @NonNull
    public Iterable<Constraint> getAllInvariants(@NonNull Type pivotType) {
        HashSet<Constraint> knownInvariants = new HashSet<Constraint>();
        for (CompleteClass superType : this.getAllSuperCompleteClasses(pivotType)) {
            if (superType == null) continue;
            for (Class partialSuperType : superType.getPartialClasses()) {
                Package partialPackage = partialSuperType.getOwningPackage();
                if (partialPackage instanceof PackageImpl && ((PackageImpl)partialPackage).isIgnoreInvariants()) continue;
                knownInvariants.addAll(partialSuperType.getOwnedInvariants());
            }
        }
        return knownInvariants;
    }

    @NonNull
    public Iterable<Operation> getAllOperations(@NonNull Type type, @Nullable FeatureFilter featureFilter) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(type);
        return completeClass.getOperations(featureFilter);
    }

    @NonNull
    public Iterable<Operation> getAllOperations(@NonNull Type type, @Nullable FeatureFilter featureFilter, @NonNull String name) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(type);
        return completeClass.getOperations(featureFilter, name);
    }

    @NonNull
    public Iterable<? extends Property> getAllProperties(@NonNull Type type, @Nullable FeatureFilter featureFilter) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(type);
        return completeClass.getProperties(featureFilter);
    }

    @NonNull
    public Iterable<? extends Property> getAllProperties(@NonNull Type type, @Nullable FeatureFilter featureFilter, @NonNull String name) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(type);
        return completeClass.getProperties(featureFilter, name);
    }

    @NonNull
    public Iterable<? extends Property> getAllProperties(@NonNull Property pivotProperty) {
        CompleteInheritance pivotClass = pivotProperty.getInheritance(this.standardLibrary);
        if (pivotClass == null) {
            throw new IllegalStateException("Missing owning type");
        }
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(pivotClass.getPivotClass());
        Iterable<Property> memberProperties = completeClass.getProperties(pivotProperty);
        if (memberProperties != null) {
            return memberProperties;
        }
        List<Property> singletonList = Collections.singletonList(pivotProperty);
        return singletonList;
    }

    @NonNull
    public Iterable<CompleteClass> getAllSuperCompleteClasses(@NonNull Type type) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(type);
        return completeClass.getSuperCompleteClasses();
    }

    @Deprecated
    @NonNull
    public Iterable<Class> getAllTypes(@NonNull Class pivotType) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(pivotType);
        Iterable filter = Iterables.filter(completeClass.getPartialClasses(), Class.class);
        return filter;
    }

    @Deprecated
    @NonNull
    public Iterable<Type> getAllTypes(@NonNull Type pivotType) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(pivotType);
        Iterable filter = Iterables.filter(completeClass.getPartialClasses(), Type.class);
        return filter;
    }

    @Nullable
    public ExpressionInOCL getBodyExpression(@NonNull Operation operation) {
        ExpressionInOCL bodyExpression = null;
        for (Operation operation2 : this.getOperationOverloads(operation)) {
            LanguageExpression anExpression = operation2.getBodyExpression();
            if (anExpression == null) continue;
            if (bodyExpression != null) {
                throw new IllegalStateException("Multiple bodies for " + operation);
            }
            try {
                bodyExpression = this.parseSpecification(anExpression);
            }
            catch (ParserException e) {
                String message = e.getMessage();
                if (message == null) {
                    message = "";
                }
                logger.error((Object)message);
                bodyExpression = PivotUtil.createExpressionInOCLError(message);
            }
        }
        return bodyExpression;
    }

    @NonNull
    public CollectionType getCollectionType(boolean isOrdered, boolean isUnique) {
        if (isOrdered) {
            if (isUnique) {
                return this.standardLibrary.getOrderedSetType();
            }
            return this.standardLibrary.getSequenceType();
        }
        if (isUnique) {
            return this.standardLibrary.getSetType();
        }
        return this.standardLibrary.getBagType();
    }

    @NonNull
    public CollectionType getCollectionType(boolean isOrdered, boolean isUnique, @NonNull Type elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.completeEnvironment.getCollectionType(this.getCollectionType(isOrdered, isUnique), elementType, isNullFree, lower, upper);
    }

    @Deprecated
    @NonNull
    public Class getCollectionType(@NonNull String collectionTypeName, @NonNull Type elementType, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.getCollectionType(collectionTypeName, elementType, false, lower, upper);
    }

    @Override
    @NonNull
    public Class getCollectionType(@NonNull String collectionTypeName, @NonNull Type elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        if (elementType.eIsProxy()) {
            return this.standardLibrary.getOclInvalidType();
        }
        return this.completeEnvironment.getCollectionType(this.standardLibrary.getRequiredLibraryType(collectionTypeName), elementType, isNullFree, lower, upper);
    }

    @NonNull
    public Type getCommonType(@NonNull Type leftType, @NonNull TemplateParameterSubstitutions leftSubstitutions, @NonNull Type rightType, @NonNull TemplateParameterSubstitutions rightSubstitutions) {
        if (leftType instanceof TupleType && rightType instanceof TupleType) {
            TupleTypeManager tupleManager = this.completeModel.getTupleManager();
            Type commonType = tupleManager.getCommonType((TupleType)leftType, leftSubstitutions, (TupleType)rightType, rightSubstitutions);
            if (commonType == null) {
                commonType = this.standardLibrary.getOclAnyType();
            }
            return commonType;
        }
        if (leftType instanceof CollectionType && rightType instanceof CollectionType) {
            CompleteInheritance leftInheritance = leftType.getInheritance(this.standardLibrary);
            CompleteInheritance rightInheritance = rightType.getInheritance(this.standardLibrary);
            CompleteInheritance commonInheritance = leftInheritance.getCommonInheritance(rightInheritance);
            Class commonCollectionType = this.getPrimaryClass(commonInheritance.getPivotClass());
            CollectionType leftCollectionType = (CollectionType)leftType;
            CollectionType rightCollectionType = (CollectionType)rightType;
            Type leftElementType = ClassUtil.nonNullModel(leftCollectionType.getElementType());
            Type rightElementType = ClassUtil.nonNullModel(rightCollectionType.getElementType());
            Type commonElementType = this.getCommonType(leftElementType, leftSubstitutions, rightElementType, rightSubstitutions);
            boolean commonIsNullFree = leftCollectionType.isIsNullFree() && rightCollectionType.isIsNullFree();
            return this.completeEnvironment.getCollectionType(commonCollectionType, commonElementType, commonIsNullFree, (IntegerValue)null, (UnlimitedNaturalValue)null);
        }
        if (this.conformsTo(leftType, leftSubstitutions, rightType, rightSubstitutions)) {
            return rightType;
        }
        if (this.conformsTo(rightType, rightSubstitutions, leftType, leftSubstitutions)) {
            return leftType;
        }
        CompleteInheritance leftInheritance = leftType.getInheritance(this.standardLibrary);
        CompleteInheritance rightInheritance = rightType.getInheritance(this.standardLibrary);
        CompleteInheritance commonInheritance = leftInheritance.getCommonInheritance(rightInheritance);
        return this.getPrimaryClass(commonInheritance.getPivotClass());
    }

    @Override
    @NonNull
    public CompleteClassInternal getCompleteClass(@NonNull Type pivotType) {
        if (!(this.libraryLoadInProgress || this.asMetamodel != null || pivotType instanceof CollectionType || pivotType instanceof VoidType || pivotType instanceof InvalidType)) {
            this.getASmetamodel();
        }
        return this.completeModel.getCompleteClass(pivotType);
    }

    @NonNull
    public CompleteEnvironmentInternal getCompleteEnvironment() {
        return this.completeEnvironment;
    }

    @Override
    @NonNull
    public CompleteModelInternal getCompleteModel() {
        return this.completeModel;
    }

    @Override
    @NonNull
    public CompletePackage getCompletePackage(@NonNull Package asPackage) {
        if (!this.libraryLoadInProgress && this.asMetamodel == null) {
            this.getASmetamodel();
        }
        return this.completeModel.getCompletePackage(asPackage);
    }

    @Nullable
    public ExpressionInOCL getDefaultExpression(@NonNull Property property) {
        ExpressionInOCL defaultExpression = null;
        for (Property property2 : this.getAllProperties(property)) {
            LanguageExpression anExpression = property2.getOwnedExpression();
            if (anExpression == null) continue;
            if (defaultExpression != null) {
                throw new IllegalStateException("Multiple derivations for " + property);
            }
            try {
                defaultExpression = this.parseSpecification(anExpression);
            }
            catch (ParserException e) {
                String message = e.getMessage();
                if (message == null) {
                    message = "";
                }
                logger.error((Object)message);
                defaultExpression = PivotUtil.createExpressionInOCLError(message);
            }
        }
        return defaultExpression;
    }

    @Override
    @Nullable
    public <T extends EObject> T getEcoreOfPivot(@NonNull java.lang.Class<T> ecoreClass, @NonNull Element element) {
        EObject eTarget = element.getESObject();
        if (eTarget != null) {
            if (!ecoreClass.isAssignableFrom(eTarget.getClass())) {
                logger.error((Object)("Ecore " + eTarget.getClass().getName() + "' element is not a '" + ecoreClass.getName() + "'"));
                return null;
            }
            EObject castTarget = eTarget;
            return (T)castTarget;
        }
        Model root = (Model)EcoreUtil.getRootContainer((EObject)element);
        Resource asResource = element.eResource();
        if (asResource == null) {
            return null;
        }
        if (asResource instanceof OCLstdlib) {
            return null;
        }
        String externalUri = root.getExternalURI();
        URI externalURI = URI.createURI((String)externalUri);
        URI ecoreURI = PivotUtilInternal.isASURI(externalUri) ? ClassUtil.nonNullEMF(externalURI.trimFileExtension()) : ClassUtil.nonNullEMF(externalURI.appendFileExtension("ecore"));
        AS2Ecore converter = new AS2Ecore(this.environmentFactory, ecoreURI, null);
        converter.convertResource(asResource, ecoreURI);
        return converter.getCreated(ecoreClass, element);
    }

    @NonNull
    public ElementExtension getElementExtension(@NonNull Element asStereotypedElement, @NonNull Stereotype asStereotype) {
        ElementExtension asElementExtension2;
        List<ElementExtension> extensions = asStereotypedElement.getOwnedExtensions();
        for (ElementExtension asElementExtension2 : extensions) {
            if (asElementExtension2.getStereotype() != asStereotype) continue;
            return asElementExtension2;
        }
        asElementExtension2 = PivotFactory.eINSTANCE.createElementExtension();
        asElementExtension2.setStereotype(asStereotype);
        String name = this.environmentFactory.getTechnology().getExtensionName(asStereotypedElement);
        asElementExtension2.setName(String.valueOf(name) + "$" + asStereotype.getName());
        extensions.add(asElementExtension2);
        return asElementExtension2;
    }

    @Override
    @NonNull
    public EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public Class getEquivalentClass(@NonNull Model thisModel, @NonNull Class thatClass) {
        String thatClassName;
        List<Class> theseOppositeClasses;
        Class thisOppositeClass;
        String thatPackageName;
        Model thatModel = PivotUtil.getContainingModel(thatClass);
        if (thisModel == thatModel) {
            return thatClass;
        }
        Package thatPackage = thatClass.getOwningPackage();
        List<Package> thesePackages = thisModel.getOwnedPackages();
        Package thisOppositePackage = NameUtil.getNameable(thesePackages, thatPackageName = ClassUtil.nonNullModel(thatPackage.getName()));
        if (thisOppositePackage == null) {
            String thatPackageURI = ClassUtil.nonNullModel(thatPackage.getURI());
            thisOppositePackage = PivotUtil.createPackage(thatPackageName, thatPackage.getNsPrefix(), thatPackageURI, thatPackage.getPackageId());
            thesePackages.add(thisOppositePackage);
        }
        if ((thisOppositeClass = NameUtil.getNameable(theseOppositeClasses = thisOppositePackage.getOwnedClasses(), thatClassName = ClassUtil.nonNullModel(thatClass.getName()))) == null) {
            thisOppositeClass = PivotUtil.createClass(thatClassName);
            theseOppositeClasses.add(thisOppositeClass);
        }
        return thisOppositeClass;
    }

    @Nullable
    public External2AS getES2AS(@NonNull Resource esResource) {
        return this.es2ases != null ? this.es2ases.get(esResource) : null;
    }

    @NonNull
    public FinalAnalysis getFinalAnalysis() {
        FinalAnalysis finalAnalysis2 = this.finalAnalysis;
        if (finalAnalysis2 == null) {
            this.finalAnalysis = finalAnalysis2 = new FinalAnalysis(this.completeModel);
        }
        return finalAnalysis2;
    }

    @Override
    @Nullable
    public GenPackage getGenPackage(@NonNull String nsURI) {
        GenPackage genPackage;
        if (this.genPackageMap != null && (genPackage = this.genPackageMap.get(nsURI)) != null) {
            return genPackage;
        }
        ResourceSet externalResourceSet = this.environmentFactory.getResourceSet();
        URI uri = EMF_2_9.EcorePlugin.getEPackageNsURIToGenModelLocationMap(false).get(nsURI);
        if (uri != null) {
            Resource resource = externalResourceSet.getResource(uri, true);
            for (EObject eObject : resource.getContents()) {
                if (!(eObject instanceof GenModel)) continue;
                GenModel genModel = (GenModel)eObject;
                genModel.reconcile();
                for (GenPackage genPackage2 : genModel.getGenPackages()) {
                    if (genPackage2 == null) continue;
                    return genPackage2;
                }
            }
        }
        return null;
    }

    @NonNull
    public Set<Map.Entry<String, Namespace>> getGlobalNamespaces() {
        Set<Map.Entry<String, Namespace>> entrySet = this.globalNamespaces.entrySet();
        return entrySet;
    }

    @NonNull
    public Iterable<Type> getGlobalTypes() {
        return this.globalTypes;
    }

    @NonNull
    public LibraryFeature getImplementation(@NonNull Feature feature) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ImplementationManager implementationManager;
        LibraryFeature implementation = feature.getImplementation();
        if (implementation == null && (implementation = (implementationManager = this.getImplementationManager()).loadImplementation(feature)) == null) {
            implementation = UnsupportedOperation.INSTANCE;
        }
        return implementation;
    }

    @NonNull
    public LibraryFeature getImplementation(@NonNull Operation operation) {
        LibraryFeature implementation = operation.getImplementation();
        if (implementation == null) {
            EObject eTarget;
            ExpressionInOCL query;
            Class owningType;
            LanguageExpression specification;
            boolean isCodeGeneration = this.getCompleteEnvironment().isCodeGeneration();
            if (isCodeGeneration && (specification = operation.getBodyExpression()) != null && (owningType = operation.getOwningClass()) != null) {
                try {
                    query = this.parseSpecification(specification);
                    implementation = new ConstrainedOperation(query);
                }
                catch (ParserException e) {
                    implementation = UnsupportedOperation.INSTANCE;
                }
            }
            if (implementation == null && (eTarget = operation.getESObject()) != null) {
                EOperation eOperation = null;
                if (eTarget instanceof EOperation) {
                    eOperation = (EOperation)eTarget;
                    while (eOperation.eContainer() instanceof EAnnotation) {
                        EObject eReference;
                        EList references;
                        EAnnotation redefines = eOperation.getEAnnotation("redefines");
                        if (redefines == null || (references = redefines.getReferences()).size() <= 0 || !((eReference = (EObject)references.get(0)) instanceof EOperation)) continue;
                        eOperation = (EOperation)eReference;
                    }
                } else {
                    Resource resource = operation.eResource();
                    if (resource instanceof ASResource) {
                        ASResource asResource = (ASResource)resource;
                        eOperation = asResource.getASResourceFactory().getEOperation(asResource, eTarget);
                    }
                }
                if (eOperation != null && eOperation.getEType() != null) {
                    implementation = new EInvokeOperation(eOperation);
                }
            }
            if (!isCodeGeneration && implementation == null && (specification = operation.getBodyExpression()) != null && (owningType = operation.getOwningClass()) != null) {
                try {
                    query = this.parseSpecification(specification);
                    implementation = new ConstrainedOperation(query);
                }
                catch (ParserException e) {
                    implementation = UnsupportedOperation.INSTANCE;
                }
            }
            if (implementation == null) {
                implementation = UnsupportedOperation.INSTANCE;
            }
            operation.setImplementation(implementation);
        }
        return implementation;
    }

    @Deprecated
    @NonNull
    public LibraryProperty getImplementation(@Nullable Object sourceValue, @NonNull Property property) {
        return this.getImplementation(null, sourceValue, property);
    }

    @NonNull
    public LibraryProperty getImplementation(@Nullable Element asNavigationExp, @Nullable Object sourceValue, @NonNull Property property) {
        LibraryProperty implementation = (LibraryProperty)property.getImplementation();
        if (implementation == null) {
            ImplementationManager implementationManager = this.getImplementationManager();
            implementation = implementationManager.getPropertyImplementation(asNavigationExp, sourceValue, property);
            property.setImplementation(implementation);
        }
        return implementation;
    }

    @NonNull
    public ImplementationManager getImplementationManager() {
        ImplementationManager implementationManager2 = this.implementationManager;
        if (implementationManager2 == null) {
            implementationManager2 = this.implementationManager = this.environmentFactory.createImplementationManager();
        }
        return implementationManager2;
    }

    @Nullable
    public Precedence getInfixPrecedence(@NonNull String operatorName) {
        this.getStandardLibrary();
        PrecedenceManager precedenceManager = this.getPrecedenceManager();
        return precedenceManager.getInfixPrecedence(operatorName);
    }

    @NonNull
    public CompleteInheritance getInheritance(@NonNull Class type) {
        Class type1 = this.getPrimaryClass(type);
        Class unspecializedType = (Class)type1.getUnspecializedElement();
        Class theType = unspecializedType != null ? unspecializedType : type1;
        CompleteInheritanceImpl completeInheritance = this.getCompleteClass(theType).getCompleteInheritance();
        return completeInheritance;
    }

    @NonNull
    public List<Library> getLibraries() {
        return this.asLibraries;
    }

    @Nullable
    public Resource getLibraryResource() {
        return this.asLibraryResource;
    }

    @Nullable
    public Class getLibraryType(@NonNull String string, @NonNull List<? extends Type> templateArguments) {
        Class libraryType = this.standardLibrary.getRequiredLibraryType(string);
        return this.getLibraryType(libraryType, templateArguments);
    }

    @NonNull
    public <T extends Class> T getLibraryType(@NonNull T libraryType, @NonNull List<? extends Type> templateArguments) {
        List<TemplateParameter> templateParameters;
        assert (libraryType == PivotUtil.getUnspecializedTemplateableElement(libraryType));
        TemplateSignature templateSignature = libraryType.getOwnedSignature();
        List<TemplateParameter> list = templateParameters = templateSignature != null ? templateSignature.getOwnedParameters() : EMPTY_TEMPLATE_PARAMETER_LIST;
        if (templateParameters.isEmpty()) {
            return libraryType;
        }
        if (templateArguments.size() != templateParameters.size()) {
            throw new IllegalArgumentException("Incorrect template bindings for template type");
        }
        boolean isUnspecialized = this.isUnspecialized(templateParameters, templateArguments);
        if (isUnspecialized) {
            return libraryType;
        }
        CompleteClassInternal libraryCompleteClass = this.getCompleteClass(libraryType);
        Class pivotClass = libraryCompleteClass.getPrimaryClass();
        if (pivotClass instanceof CollectionType) {
            assert (pivotClass instanceof CollectionType);
            assert (templateArguments.size() == 1);
            Type templateArgument = templateArguments.get(0);
            CollectionType specializedType = this.completeModel.getCollectionType(libraryCompleteClass, TypeUtil.createCollectionTypeParameters(templateArgument, false, null, null));
            return (T)specializedType;
        }
        if (pivotClass instanceof MapType) {
            assert (pivotClass instanceof MapType);
            assert (templateArguments.size() == 2);
            Type keyTemplateArgument = templateArguments.get(0);
            Type valueTemplateArgument = templateArguments.get(1);
            MapType specializedType = this.completeModel.getMapType(libraryCompleteClass, TypeUtil.createMapTypeParameters(keyTemplateArgument, valueTemplateArgument));
            return (T)specializedType;
        }
        Class specializedType = libraryCompleteClass.getPartialClasses().getSpecializedType(templateArguments);
        return (T)specializedType;
    }

    @NonNull
    public Iterable<Constraint> getLocalInvariants(@NonNull Class type) {
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteElementInvariantsIterable(this.getAllTypes(type));
    }

    @Nullable
    public EObject getLockingObject() {
        return this.lockingAnnotation;
    }

    @NonNull
    public Class getMapType(@NonNull String mapTypeName, @NonNull Type keyType, @NonNull Type valueType) {
        if (keyType.eIsProxy() || valueType.eIsProxy()) {
            return this.standardLibrary.getOclInvalidType();
        }
        return this.completeEnvironment.getMapType(this.standardLibrary.getRequiredLibraryType(mapTypeName), keyType, valueType);
    }

    @NonNull
    public Iterable<Operation> getMemberOperations(@NonNull Class type, boolean selectStatic) {
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteTypeOperationsIterable(this.getAllTypes(type), selectStatic);
    }

    @NonNull
    public Iterable<? extends CompletePackage> getMemberPackages(@NonNull Package pkg) {
        return this.getCompletePackage(pkg).getOwnedCompletePackages();
    }

    @NonNull
    public Iterable<Property> getMemberProperties(@NonNull Class type, boolean selectStatic) {
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteClassPropertiesIterable(this.getAllTypes(type), selectStatic);
    }

    @NonNull
    public Class getMetaclass(@NonNull Type domainInstanceType) {
        Class metaType = null;
        if (domainInstanceType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)domainInstanceType;
            metaType = collectionType.isOrdered() ? (collectionType.isUnique() ? this.getASClass("OrderedSetType") : this.getASClass("SequenceType")) : (collectionType.isUnique() ? this.getASClass("SetType") : this.getASClass("BagType"));
        }
        if (metaType != null) {
            return metaType;
        }
        return this.standardLibrary.getClassType();
    }

    @Nullable
    public Type getOclType(@NonNull String typeName) {
        Class pivotType = this.getASClass(typeName);
        return pivotType != null ? this.getInheritance(pivotType).getPivotClass() : null;
    }

    @NonNull
    public Iterable<? extends Operation> getOperationOverloads(@NonNull Operation pivotOperation) {
        CompleteInheritance pivotClass = pivotOperation.getInheritance(this.standardLibrary);
        if (pivotClass == null) {
            throw new IllegalStateException("Missing owning type");
        }
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(pivotClass.getPivotClass());
        Iterable<Operation> operationOverloads = completeClass.getOperationOverloads(pivotOperation);
        if (operationOverloads != null) {
            return operationOverloads;
        }
        List<Operation> singletonList = Collections.singletonList(pivotOperation);
        return singletonList;
    }

    @NonNull
    public Iterable<? extends Package> getPartialPackages(@NonNull Package pkg, boolean loadASmetamodelFirst) {
        if (!this.libraryLoadInProgress && loadASmetamodelFirst && this.asMetamodel == null) {
            this.getASmetamodel();
        }
        CompletePackageInternal completePackage = this.completeModel.getCompletePackage(pkg);
        return completePackage.getPartialPackages();
    }

    @NonNull
    public Iterable<Class> getPartialClasses(@NonNull Type pivotType) {
        CompleteClassInternal completeClass = this.completeModel.getCompleteClass(pivotType);
        return completeClass.getPartialClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected PrecedenceManager getPrecedenceManager() {
        if (this.precedenceManager == null) {
            this.standardLibrary.getOclAnyType();
            PivotMetamodelManager pivotMetamodelManager = this;
            synchronized (pivotMetamodelManager) {
                if (this.precedenceManager == null) {
                    PivotMetamodelManager pivotMetamodelManager2 = this;
                    synchronized (pivotMetamodelManager2) {
                        this.precedenceManager = this.createPrecedenceManager();
                    }
                }
            }
        }
        return this.precedenceManager;
    }

    @Nullable
    public Precedence getPrefixPrecedence(@NonNull String operatorName) {
        PrecedenceManager precedenceManager = this.getPrecedenceManager();
        return precedenceManager.getPrefixPrecedence(operatorName);
    }

    @NonNull
    public <T extends EObject> T getPrimaryElement(@NonNull T element) {
        if (element instanceof Operation) {
            return (T)this.getPrimaryOperation((Operation)element);
        }
        if (element instanceof Package) {
            return (T)this.getPrimaryPackage((Package)element);
        }
        if (element instanceof Property) {
            return (T)this.getPrimaryProperty((Property)element);
        }
        if (element instanceof Type) {
            return (T)this.getPrimaryType((Type)element);
        }
        return element;
    }

    @Override
    @NonNull
    public Operation getPrimaryOperation(@NonNull Operation pivotOperation) {
        CompleteClassInternal completeClass;
        Operation operation;
        CompleteInheritance pivotClass = pivotOperation.getInheritance(this.standardLibrary);
        if (pivotClass != null && (operation = (completeClass = this.completeModel.getCompleteClass(pivotClass.getPivotClass())).getOperation(pivotOperation)) != null) {
            return operation;
        }
        return pivotOperation;
    }

    @Nullable
    public Package getPrimaryPackage(@NonNull String nsURI, String ... subPackagePath) {
        CompletePackage completePackage = this.completeModel.getCompletePackageByURI(nsURI);
        if (completePackage == null) {
            return null;
        }
        if (subPackagePath != null) {
            String[] stringArray = subPackagePath;
            int n = subPackagePath.length;
            int n2 = 0;
            while (n2 < n) {
                String subPackageName = stringArray[n2];
                if (subPackageName == null) {
                    return null;
                }
                if ((completePackage = completePackage.getOwnedCompletePackage(subPackageName)) == null) {
                    return null;
                }
                ++n2;
            }
        }
        return completePackage.getPrimaryPackage();
    }

    @Override
    @NonNull
    public Package getPrimaryPackage(@NonNull Package aPackage) {
        return ClassUtil.nonNullState(this.getCompletePackage(aPackage).getPrimaryPackage());
    }

    @Override
    @NonNull
    public Property getPrimaryProperty(@NonNull Property pivotProperty) {
        if (pivotProperty.eContainer() instanceof TupleType) {
            return pivotProperty;
        }
        CompleteInheritance owningInheritance = pivotProperty.getInheritance(this.standardLibrary);
        if (owningInheritance != null) {
            String name = ClassUtil.nonNullModel(pivotProperty.getName());
            Property opposite = pivotProperty.getOpposite();
            String oppositeName = opposite != null ? opposite.getName() : null;
            CompleteClassInternal completeClass = this.completeModel.getCompleteClass(owningInheritance.getPivotClass());
            Iterable<Property> memberProperties = completeClass.getProperties(pivotProperty.isIsStatic() ? FeatureFilter.SELECT_STATIC : FeatureFilter.SELECT_NON_STATIC, name);
            Property bestProperty = null;
            for (Property memberProperty : memberProperties) {
                String memberOppositeName;
                if (memberProperty == null) continue;
                Property memberOpposite = memberProperty.getOpposite();
                String string = memberOppositeName = memberOpposite != null ? memberOpposite.getName() : null;
                if (oppositeName != null && oppositeName.equals(memberOppositeName)) {
                    return memberProperty;
                }
                if (bestProperty != null && oppositeName != null && !oppositeName.equals(memberOppositeName)) continue;
                bestProperty = memberProperty;
            }
            if (bestProperty != null) {
                return bestProperty;
            }
        }
        return pivotProperty;
    }

    @Override
    @NonNull
    public Class getPrimaryClass(@NonNull Class type) {
        if (!this.isTypeServeable(type)) {
            return type;
        }
        return this.getCompleteClass(type).getPrimaryClass();
    }

    @NonNull
    public Type getPrimaryType(@NonNull Type type) {
        if (!this.isTypeServeable(type)) {
            return type;
        }
        return this.getCompleteClass(type).getPrimaryClass();
    }

    @Override
    @Nullable
    public Class getPrimaryType(@NonNull String nsURI, @NonNull String path, String ... extraPath) {
        CompletePackage completePackage = this.completeModel.getCompletePackageByURI(nsURI);
        if (completePackage == null) {
            return null;
        }
        if (extraPath == null || extraPath.length == 0) {
            return completePackage.getMemberType(path);
        }
        if ((completePackage = completePackage.getOwnedCompletePackage(path)) == null) {
            return null;
        }
        int iMax = extraPath.length - 1;
        int i = 0;
        while (i < iMax) {
            String subPackageName = extraPath[i];
            if (subPackageName == null) {
                return null;
            }
            if ((completePackage = completePackage.getOwnedCompletePackage(subPackageName)) == null) {
                return null;
            }
            ++i;
        }
        String subPackageName = extraPath[iMax];
        if (subPackageName == null) {
            return null;
        }
        return completePackage.getMemberType(subPackageName);
    }

    @NonNull
    public ASResource getResource(@NonNull URI uri, @Nullable String contentType) {
        Object asResourceFactory = this.asResourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().get(contentType);
        if (asResourceFactory == null) {
            throw new IllegalStateException("No registration for content type '" + contentType + "'");
        }
        if (!(asResourceFactory instanceof ASResourceFactory)) {
            throw new IllegalStateException("Non ASResourceFactory registration for content type '" + contentType + "'");
        }
        Resource asResource = this.asResourceSet.getResource(uri, false);
        if (asResource == null) {
            asResource = this.asResourceSet.createResource(uri, contentType);
        }
        if (asResource == null) {
            throw new IllegalStateException("Failed to create '" + uri + "'");
        }
        if (!(asResource instanceof ASResource)) {
            throw new IllegalStateException("Non ASResource created for content type '" + contentType + "'");
        }
        return (ASResource)asResource;
    }

    @Override
    @NonNull
    public StandardLibraryInternal getStandardLibrary() {
        return this.standardLibrary;
    }

    public Iterable<CompleteClass> getSuperCompleteClasses(@NonNull Class pivotType) {
        if (!this.libraryLoadInProgress && this.asMetamodel == null && pivotType == this.standardLibrary.getClassType()) {
            this.getASmetamodel();
        }
        CompleteClassInternal completeClass = this.getCompleteClass(pivotType);
        return this.getSuperCompleteClasses(completeClass);
    }

    public Iterable<CompleteClass> getSuperCompleteClasses(@NonNull CompleteClass completeClass) {
        return completeClass.getProperSuperCompleteClasses();
    }

    public ResourceSet getTarget() {
        return this.asResourceSet;
    }

    protected void installLibraryContents(@NonNull Library asLibrary) {
        for (Class type : asLibrary.getOwnedClasses()) {
            Class primaryType;
            if (type == null || type != (primaryType = this.getPrimaryClass(type)) || !PivotUtilInternal.isLibraryType(type)) continue;
            this.standardLibrary.defineLibraryType(primaryType);
        }
    }

    public void installPropertyDeclaration(@NonNull Property thisProperty) {
        if ((thisProperty.isIsTransient() || thisProperty.isIsVolatile()) && !thisProperty.isIsDerived()) {
            return;
        }
        Property opposite = thisProperty.getOpposite();
        if (opposite != null) {
            return;
        }
        Type thatType = thisProperty.getType();
        if (thatType instanceof CollectionType) {
            thatType = ((CollectionType)thatType).getElementType();
        }
        if (thatType == null) {
            return;
        }
        Class thatClass = thatType.isClass();
        if (thatClass == null || thatClass instanceof DataType) {
            return;
        }
        Class thisClass = thisProperty.getOwningClass();
        if (thisClass == null) {
            return;
        }
        String name = thisClass.getName();
        if (name == null) {
            return;
        }
        Property newOpposite = PivotFactory.eINSTANCE.createProperty();
        newOpposite.setIsImplicit(true);
        newOpposite.setName(name);
        if (thisProperty.isIsComposite()) {
            newOpposite.setType(thisClass);
            newOpposite.setIsRequired(false);
        } else {
            newOpposite.setType(this.getCollectionType(false, false, thisClass, false, PivotConstantsInternal.DEFAULT_IMPLICIT_OPPOSITE_LOWER_VALUE, PivotConstantsInternal.DEFAULT_IMPLICIT_OPPOSITE_UPPER_VALUE));
            newOpposite.setIsRequired(true);
        }
        Model thisModel = PivotUtil.getContainingModel(thisClass);
        assert (thisModel != null);
        Class thisOppositeClass = this.getEquivalentClass(thisModel, thatClass);
        thisOppositeClass.getOwnedProperties().add(newOpposite);
        newOpposite.setOpposite(thisProperty);
        thisProperty.setOpposite(newOpposite);
    }

    public void installResource(@NonNull Resource asResource) {
        for (EObject eObject : asResource.getContents()) {
            if (!(eObject instanceof Model)) continue;
            this.installRoot((Model)eObject);
        }
        if (!this.libraryLoadInProgress && this.asLibraryResource == null && asResource instanceof OCLstdlib && this.asLibraries.size() > 0) {
            this.standardLibrary.getOclAnyType();
        }
    }

    @Override
    public void installRoot(@NonNull Model pivotModel) {
        if (this.completeModel.getPartialModels().contains(pivotModel)) {
            return;
        }
        List<Package> ownedPackages = pivotModel.getOwnedPackages();
        List<Import> ownedImports = pivotModel.getOwnedImports();
        if (ownedPackages.isEmpty() && ownedImports.isEmpty()) {
            return;
        }
        this.completeModel.getPartialModels().add(pivotModel);
        for (Package asPackage : ownedPackages) {
            if (!(asPackage instanceof Library) || this.asLibraries.contains(asPackage)) continue;
            Library asLibrary = (Library)asPackage;
            String uri = asLibrary.getURI();
            if (this.asLibraries.isEmpty()) {
                if (uri == null) {
                    throw new IllegalLibraryException(PivotMessagesInternal.MissingLibraryURI_ERROR_);
                }
                if (!this.standardLibrary.isExplicitDefaultStandardLibraryURI()) {
                    for (Class asClass : asLibrary.getOwnedClasses()) {
                        if (!"OclAny".equals(asClass.getName())) continue;
                        this.standardLibrary.setDefaultStandardLibraryURI(uri);
                        break;
                    }
                }
            }
            this.asLibraries.add(asLibrary);
            if (this.asLibraryResource == null) continue;
            this.installLibraryContents(asLibrary);
        }
        for (Import asImport : ownedImports) {
            Model asModel;
            Namespace asNamespace = asImport.getImportedNamespace();
            if (asNamespace == null || (asModel = PivotUtil.getContainingModel(asNamespace)) == null || this.completeModel.getPartialModels().contains(asModel)) continue;
            this.installRoot(asModel);
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == PivotMetamodelManager.class;
    }

    public boolean isLibraryLoadInProgress() {
        return this.libraryLoadInProgress;
    }

    public boolean isSuperClassOf(@NonNull Class unspecializedFirstType, @NonNull Class secondType) {
        CompleteClassInternal firstCompleteClass = this.getCompleteClass(unspecializedFirstType);
        CompleteClassInternal secondCompleteClass = this.getCompleteClass(secondType);
        return this.isSuperCompleteClassOf(firstCompleteClass, secondCompleteClass);
    }

    public boolean isSuperCompleteClassOf(@NonNull CompleteClass unspecializedFirstType, @NonNull CompleteClass secondType) {
        CompleteClassInternal unspecializedSecondType = this.getCompleteClass(PivotUtil.getUnspecializedTemplateableElement(secondType.getPrimaryClass()));
        if (unspecializedFirstType == unspecializedSecondType) {
            return true;
        }
        for (CompleteClass superCompleteClass : this.getSuperCompleteClasses(unspecializedSecondType)) {
            if (superCompleteClass == null || !this.isSuperCompleteClassOf(unspecializedFirstType, superCompleteClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeServeable(@NonNull Type type) {
        if (type.isTemplateParameter() != null) {
            return false;
        }
        if (type instanceof LambdaType) {
            return false;
        }
        return !(type.eContainer() instanceof TemplateParameterSubstitution);
    }

    protected boolean isUnspecialized(@NonNull List<TemplateParameter> templateParameters, @NonNull List<? extends Type> templateArguments) {
        int iMax = templateParameters.size();
        assert (templateArguments.size() == iMax);
        int i = 0;
        while (i < iMax) {
            if (templateArguments.get(i) != templateParameters.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void loadASmetamodel(@NonNull Package asLibrary) {
        for (Package package_ : this.getPartialPackages(asLibrary, false)) {
            if (NameUtil.getNameable(package_.getOwnedClasses(), PivotPackage.Literals.ELEMENT.getName()) == null) continue;
            this.setASmetamodel(package_);
            return;
        }
        String string = ClassUtil.nonNullState(asLibrary.getName());
        Package oclMetamodel = OCLmetamodel.create(this.standardLibrary, string, asLibrary.getNsPrefix(), "http://www.eclipse.org/ocl/2015/Pivot");
        this.asResourceSet.getResources().add((Object)oclMetamodel.eResource());
        this.setASmetamodel(oclMetamodel);
        Resource asResource = oclMetamodel.eResource();
        this.installResource(asResource);
    }

    @Nullable
    public Resource loadDefaultLibrary(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        Resource asLibraryResource2 = this.asLibraryResource;
        if (asLibraryResource2 != null) {
            return asLibraryResource2;
        }
        boolean savedLibraryLoadInProgress = this.libraryLoadInProgress;
        this.libraryLoadInProgress = true;
        try {
            StandardLibraryContribution contribution = StandardLibraryContribution.REGISTRY.get(uri);
            if (contribution != null) {
                this.asLibraryResource = asLibraryResource2 = contribution.getResource();
            } else {
                for (Library asLibrary : this.asLibraries) {
                    if (asLibrary == null || !uri.equals(asLibrary.getURI())) continue;
                    this.asLibraryResource = asLibraryResource2 = asLibrary.eResource();
                    break;
                }
                if (asLibraryResource2 == null) {
                    return null;
                }
            }
            this.installResource(asLibraryResource2);
            if (!this.asLibraries.isEmpty()) {
                for (Library asLibrary : this.asLibraries) {
                    if (asLibrary == null) continue;
                    this.installLibraryContents(asLibrary);
                }
            }
            Resource resource = asLibraryResource2;
            return resource;
        }
        finally {
            this.libraryLoadInProgress = savedLibraryLoadInProgress;
        }
    }

    @Override
    @Nullable
    public Element loadResource(@NonNull URI uri, String zzalias, @Nullable ResourceSet resourceSet) throws ParserException {
        EPackage ePackage;
        URI resourceURI = uri.trimFragment();
        if (PivotUtilInternal.isASURI(resourceURI)) {
            return this.getASElement(uri);
        }
        ResourceSet externalResourceSet = resourceSet != null ? resourceSet : this.environmentFactory.getResourceSet();
        EPackage.Registry packageRegistry = externalResourceSet.getPackageRegistry();
        String uriString = resourceURI.toString();
        Resource resource = null;
        String fragment = uri.fragment();
        if (fragment == null) {
            ePackage = packageRegistry.getEPackage(uriString);
            if (ePackage != null) {
                return this.getASOf(Element.class, (EObject)ePackage);
            }
            if (uriString.equals(this.standardLibrary.getDefaultStandardLibraryURI())) {
                resource = this.asLibraryResource != null ? this.asLibraryResource : this.standardLibrary.loadDefaultLibrary(uriString);
            } else {
                StandardLibraryContribution contribution = StandardLibraryContribution.REGISTRY.get(uriString);
                if (contribution != null) {
                    resource = contribution.getResource();
                }
            }
        } else {
            Element asElement;
            Object eObject;
            Resource eResource;
            ePackage = packageRegistry.getEPackage(uriString);
            if (ePackage != null && (eResource = ePackage.eResource()) instanceof XMLResource && (eObject = ((XMLResource)eResource).getEObject(fragment)) != null && (asElement = this.getASOf(Element.class, (EObject)eObject)) != null) {
                return asElement;
            }
        }
        if (resource == null) {
            External2AS external2as = this.external2asMap.get(resourceURI);
            if (external2as != null) {
                resource = external2as.getResource();
            } else {
                resource = externalResourceSet.getResource(resourceURI, true);
                if (resource != null) {
                    for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                        if (!(diagnostic instanceof WrappedException)) continue;
                        throw (WrappedException)diagnostic;
                    }
                }
                if (resource != null) {
                    EObject firstContent;
                    EList contents;
                    if (resource instanceof StandaloneProjectMap.DelegatedSinglePackageResource) {
                        resource = ((StandaloneProjectMap.DelegatedSinglePackageResource)resource).getResource();
                    }
                    if ((contents = resource.getContents()).size() > 0 && (firstContent = (EObject)contents.get(0)) != null) {
                        for (ASResourceFactory resourceFactory : ASResourceFactoryRegistry.INSTANCE.getLoadedResourceFactories()) {
                            Resource knownResource;
                            URI packageURI = resourceFactory.getPackageURI(firstContent);
                            if (packageURI == null) continue;
                            External2AS external2as2 = this.external2asMap.get(packageURI);
                            if (external2as2 == null || (knownResource = external2as2.getResource()) == null || knownResource == resource) break;
                            for (EObject eContent : resource.getContents()) {
                                Element pivot;
                                if (!(eContent instanceof Pivotable) || !((pivot = ((Pivotable)firstContent).getPivot()) instanceof Model)) continue;
                                Model root = (Model)pivot;
                                this.completeModel.getPartialModels().remove(root);
                                Resource asResource = root.eResource();
                                if (asResource == null) continue;
                                this.asResourceSet.getResources().remove((Object)asResource);
                                asResource.unload();
                            }
                            if (!resourceFactory.getASResourceFactory().isCompatibleResource(resource, knownResource)) {
                                logger.error((Object)("Resource '" + resource.getURI() + "' already loaded as '" + knownResource.getURI() + "'"));
                            }
                            resource.getResourceSet().getResources().remove((Object)resource);
                            resource = knownResource;
                            break;
                        }
                    }
                }
            }
        }
        if (resource != null) {
            return this.environmentFactory.loadResource(resource, uri);
        }
        logger.warn((Object)("Cannot load package with URI '" + uri + "'"));
        return null;
    }

    @NonNull
    public LibraryFeature lookupImplementation(@NonNull Operation dynamicOperation) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return this.getImplementation(dynamicOperation);
    }

    public void notifyChanged(Notification notification) {
    }

    @Override
    @NonNull
    public ExpressionInOCL parseSpecification(@NonNull LanguageExpression specification) throws ParserException {
        EObject contextElement = ClassUtil.nonNullState(specification.eContainer());
        if (specification instanceof ExpressionInOCL && ((ExpressionInOCL)specification).getOwnedBody() != null) {
            return (ExpressionInOCL)specification;
        }
        String expression = specification.getBody();
        if (expression == null) {
            throw new ParserException(PivotMessagesInternal.MissingSpecificationBody_ERROR_, NameUtil.qualifiedNameFor(contextElement), PivotUtilInternal.getSpecificationRole(specification));
        }
        ParserContext parserContext = this.createParserContext(specification, new Object[0]);
        if (parserContext == null) {
            throw new ParserException(PivotMessagesInternal.UnknownContextType_ERROR_, NameUtil.qualifiedNameFor(contextElement), PivotUtilInternal.getSpecificationRole(specification));
        }
        parserContext.setRootElement(specification);
        return parserContext.parse(contextElement, expression);
    }

    public void removeExternalResource(@NonNull External2AS external2as) {
        this.external2asMap.remove(external2as.getURI());
    }

    public void removeExternalResource(@NonNull Resource esResource) {
        External2AS es2as;
        if (this.es2ases != null && (es2as = this.es2ases.remove(esResource)) != null) {
            es2as.dispose();
        }
    }

    public void setASmetamodel(Package asPackage) {
        this.asMetamodel = asPackage;
        String uri = this.asMetamodel.getURI();
        if (uri != null) {
            this.completeModel.addPackageURI2completeURI(uri, "$metamodel$");
        }
    }

    public void setAutoLoadASmetamodel(boolean autoLoadASmetamodel) {
        this.autoLoadASmetamodel = autoLoadASmetamodel;
    }

    public void setLibraryLoadInProgress(boolean libraryLoadInProgress) {
        this.libraryLoadInProgress = libraryLoadInProgress;
    }

    public void setMetamodelNsURI(@NonNull String metaNsURI) {
        if (this.asMetamodel == null) {
            this.getASmetamodel();
        } else if (!metaNsURI.equals(this.asMetamodel.getURI())) {
            this.completeModel.addPackageURI2completeURI(metaNsURI, "$metamodel$");
        }
    }

    public void setTarget(Notifier newTarget) {
    }

    @NonNull
    public Type specializeType(@NonNull Type type, @NonNull CallExp callExp, @NonNull Type selfType, @Nullable Type selfTypeValue) {
        return TemplateParameterSubstitutionVisitor.specializeType(type, callExp, this.environmentFactory, selfType, selfTypeValue);
    }

    public void unsetTarget(Notifier oldTarget) {
    }

    public class CompleteClassPropertiesIterable
    extends CompleteElementIterable<Class, Property> {
        protected final Boolean selectStatic;

        public CompleteClassPropertiesIterable(Iterable<Class> types, boolean selectStatic) {
            super(types);
            this.selectStatic = selectStatic;
        }

        @Override
        @NonNull
        protected Iterable<Property> getInnerIterable(@NonNull Class model) {
            return ClassUtil.nonNullEMF(model.getOwnedProperties());
        }

        @Override
        @Nullable
        protected Property getInnerValue(@NonNull Property element) {
            if (this.selectStatic != null && element.isIsStatic() != this.selectStatic.booleanValue()) {
                return null;
            }
            return element;
        }
    }

    public class CompleteElementInvariantsIterable
    extends CompleteElementIterable<Class, Constraint> {
        public CompleteElementInvariantsIterable(Iterable<? extends Class> models) {
            super(models);
        }

        @Override
        @NonNull
        protected Iterable<Constraint> getInnerIterable(@NonNull Class model) {
            return ClassUtil.nonNullEMF(model.getOwnedInvariants());
        }
    }

    public class CompleteTypeOperationsIterable
    extends CompleteElementIterable<Class, Operation> {
        protected final Boolean selectStatic;

        public CompleteTypeOperationsIterable(Iterable<Class> types, boolean selectStatic) {
            super(types);
            this.selectStatic = selectStatic;
        }

        @Override
        @NonNull
        protected Iterable<Operation> getInnerIterable(@NonNull Class model) {
            return ClassUtil.nonNullEMF(model.getOwnedOperations());
        }

        @Override
        @Nullable
        protected Operation getInnerValue(@NonNull Operation element) {
            if (this.selectStatic != null && element.isIsStatic() != this.selectStatic.booleanValue()) {
                return null;
            }
            return element;
        }
    }
}

