/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.compatibility.EMF_2_9;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class StandaloneProjectMap
implements ProjectManager {
    private static final String PLUGIN_ID = "org.eclipse.ocl.pivot";
    private static final Logger logger = Logger.getLogger(StandaloneProjectMap.class);
    @Nullable
    private static Set<String> alreadyLogged = null;
    @NonNull
    public static final TracingOption PROJECT_MAP_ADD_EPACKAGE = new TracingOption("org.eclipse.ocl.pivot", "projectMap/addEPackage");
    @NonNull
    public static final TracingOption PROJECT_MAP_ADD_GEN_MODEL = new TracingOption("org.eclipse.ocl.pivot", "projectMap/addGenModel");
    @NonNull
    public static final TracingOption PROJECT_MAP_ADD_GENERATED_PACKAGE = new TracingOption("org.eclipse.ocl.pivot", "projectMap/addGeneratedPackage");
    @NonNull
    public static final TracingOption PROJECT_MAP_ADD_URI_MAP = new TracingOption("org.eclipse.ocl.pivot", "projectMap/addURIMap");
    @NonNull
    public static final TracingOption PROJECT_MAP_CONFIGURE = new TracingOption("org.eclipse.ocl.pivot", "projectMap/configure");
    @NonNull
    public static final TracingOption PROJECT_MAP_GET = new TracingOption("org.eclipse.ocl.pivot", "projectMap/get");
    @NonNull
    public static final TracingOption PROJECT_MAP_INSTALL = new TracingOption("org.eclipse.ocl.pivot", "projectMap/install");
    @NonNull
    public static final TracingOption PROJECT_MAP_RESOLVE = new TracingOption("org.eclipse.ocl.pivot", "projectMap/resolve");
    public static WeakHashMap<StandaloneProjectMap, Object> liveStandaloneProjectMaps = null;
    protected final boolean isGlobal;
    @Nullable
    private Map<String, Exception> exceptionMap = null;
    private Map<String, ProjectManager.IProjectDescriptor> project2descriptor = null;
    protected boolean initializedPlatformResourceMap = false;
    @Nullable
    protected Map<URI, ProjectManager.IPackageDescriptor> nsURI2package = null;
    @Nullable
    protected Map<URI, ProjectManager.IResourceDescriptor> uri2resource = null;

    @Nullable
    public static StandaloneProjectMap findAdapter(@NonNull ResourceSet resourceSet) {
        return (StandaloneProjectMap)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), StandaloneProjectMap.class);
    }

    @NonNull
    public static StandaloneProjectMap getAdapter(@NonNull ResourceSet resourceSet) {
        StandaloneProjectMap adapter = StandaloneProjectMap.findAdapter(resourceSet);
        if (adapter == null) {
            adapter = new StandaloneProjectMap(false);
            adapter.initializeResourceSet(resourceSet);
        }
        return adapter;
    }

    @NonNull
    public static EPackage.Registry getPackageRegistry(@Nullable ResourceSet resourceSet) {
        if (resourceSet == null) {
            EPackage.Registry globalRegistry = EPackage.Registry.INSTANCE;
            return globalRegistry;
        }
        EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
        return packageRegistry;
    }

    public static Resource.Factory.Registry getResourceFactoryRegistry(@Nullable ResourceSet resourceSet) {
        return resourceSet != null ? resourceSet.getResourceFactoryRegistry() : Resource.Factory.Registry.INSTANCE;
    }

    @NonNull
    public static URIConverter getURIConverter(@Nullable ResourceSet resourceSet) {
        return resourceSet != null ? resourceSet.getURIConverter() : URIConverter.INSTANCE;
    }

    @NonNull
    public static Map<URI, URI> getURIMap(@Nullable ResourceSet resourceSet) {
        return resourceSet != null ? resourceSet.getURIConverter().getURIMap() : URIConverter.URI_MAP;
    }

    public static void initStatics() {
        GenModelReader.initStatics();
        new PluginReader(null);
    }

    public static void initializeURIResourceMap(@Nullable ResourceSet resourceSet) {
        ResourceSetImpl resourceSetImpl;
        Map uriResourceMap;
        if (resourceSet instanceof ResourceSetImpl && (uriResourceMap = (resourceSetImpl = (ResourceSetImpl)resourceSet).getURIResourceMap()) == null) {
            resourceSetImpl.setURIResourceMap(new HashMap());
        }
    }

    public StandaloneProjectMap(boolean isGlobal) {
        this.isGlobal = isGlobal;
        if (liveStandaloneProjectMaps != null) {
            liveStandaloneProjectMaps.put(this, null);
            PivotUtilInternal.debugPrintln("Create " + this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        }
    }

    @Override
    public void addResourceDescriptor(@NonNull ProjectManager.IResourceDescriptor resourceDescriptor) {
        Map<URI, ProjectManager.IResourceDescriptor> uri2resource2 = this.uri2resource;
        if (uri2resource2 == null) {
            this.uri2resource = uri2resource2 = new HashMap<URI, ProjectManager.IResourceDescriptor>();
        }
        uri2resource2.put(resourceDescriptor.getPlatformPluginURI(), resourceDescriptor);
        uri2resource2.put(resourceDescriptor.getPlatformResourceURI(), resourceDescriptor);
    }

    @Override
    public void configure(@Nullable ResourceSet resourceSet, @NonNull ProjectManager.IResourceLoadStrategy resourceLoadStrategy, @Nullable ProjectManager.IConflictHandler conflictHandler) {
        Map<String, ProjectManager.IProjectDescriptor> projectDescriptors = this.getProjectDescriptors();
        if (projectDescriptors != null) {
            for (ProjectManager.IProjectDescriptor projectDescriptor : projectDescriptors.values()) {
                projectDescriptor.configure(resourceSet, resourceLoadStrategy, conflictHandler);
            }
        }
    }

    @NonNull
    protected ProjectManager.IProjectDescriptor createProjectDescriptor(@NonNull String projectName, @NonNull URI locationURI) {
        return new ProjectDescriptor(this, projectName, locationURI);
    }

    protected void finalize() throws Throwable {
        if (liveStandaloneProjectMaps != null) {
            PivotUtilInternal.debugPrintln("Finalize " + this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)));
            ArrayList<StandaloneProjectMap> keySet = new ArrayList<StandaloneProjectMap>(liveStandaloneProjectMaps.keySet());
            if (!keySet.isEmpty()) {
                StringBuilder s = new StringBuilder();
                s.append(" live");
                for (StandaloneProjectMap projectMap : keySet) {
                    s.append(" @" + Integer.toHexString(System.identityHashCode(projectMap)));
                }
                System.out.println(s);
            }
        }
    }

    @Override
    @Nullable
    public ProjectManager.IPackageDescriptor getPackageDescriptor(@NonNull URI nsURI) {
        return this.nsURI2package != null ? this.nsURI2package.get(nsURI) : null;
    }

    @Nullable
    public ProjectManager.IProjectDescriptor getProjectDescriptor(@NonNull String projectName) {
        Map<String, ProjectManager.IProjectDescriptor> projectDescriptors = this.getProjectDescriptors();
        if (projectDescriptors == null) {
            return null;
        }
        return projectDescriptors.get(projectName);
    }

    @NonNull
    protected ProjectManager.IProjectDescriptor getProjectDescriptorInternal(@NonNull URI platformURI) {
        String projectName = platformURI.segment(1);
        this.getProjectDescriptors();
        ProjectManager.IProjectDescriptor projectDescriptor = this.project2descriptor.get(projectName);
        if (projectDescriptor == null) {
            URI locationURI = platformURI.trimSegments(platformURI.segmentCount() - 2).appendSegment("");
            projectDescriptor = this.createProjectDescriptor(projectName, locationURI);
            this.project2descriptor.put(projectName, projectDescriptor);
        }
        return projectDescriptor;
    }

    @Nullable
    public Map<String, Exception> getExceptionMap() {
        return this.exceptionMap;
    }

    @Nullable
    public URI getLocation(@NonNull String projectName) {
        Map<String, ProjectManager.IProjectDescriptor> projectDescriptors = this.getProjectDescriptors();
        if (projectDescriptors == null) {
            return null;
        }
        ProjectManager.IProjectDescriptor projectDescriptor = projectDescriptors.get(projectName);
        if (projectDescriptor == null) {
            return null;
        }
        return projectDescriptor.getLocationURI();
    }

    @Nullable
    protected synchronized Map<String, ProjectManager.IProjectDescriptor> getProjectDescriptors() {
        Map<String, ProjectManager.IProjectDescriptor> project2descriptor2 = this.project2descriptor;
        if (project2descriptor2 == null) {
            this.project2descriptor = project2descriptor2 = new HashMap<String, ProjectManager.IProjectDescriptor>();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                SAXParser saxParser = factory.newSAXParser();
                if (saxParser != null) {
                    this.scanClassPath(project2descriptor2, saxParser);
                }
            }
            catch (Exception e) {
                this.logException("Failed to  create SAXParser", e);
                return null;
            }
        }
        return project2descriptor2;
    }

    @Nullable
    public Set<String> getProjectNames() {
        Map<String, ProjectManager.IProjectDescriptor> project2descriptor2 = this.getProjectDescriptors();
        if (project2descriptor2 == null) {
            return null;
        }
        return project2descriptor2.keySet();
    }

    public Notifier getTarget() {
        return null;
    }

    public synchronized void initializeGenModelLocationMap(boolean force) {
        if (force || this.nsURI2package == null) {
            HashMap<URI, ProjectManager.IPackageDescriptor> nsURI2package2 = new HashMap<URI, ProjectManager.IPackageDescriptor>();
            this.nsURI2package = nsURI2package2;
            Map<String, ProjectManager.IProjectDescriptor> projectDescriptors = this.getProjectDescriptors();
            if (projectDescriptors != null) {
                for (ProjectManager.IProjectDescriptor projectDescriptor : projectDescriptors.values()) {
                    projectDescriptor.initializeGenModelLocationMap(nsURI2package2);
                }
            }
        }
    }

    public synchronized void initializePackageRegistry(@Nullable ResourceSet resourceSet) {
        this.getProjectDescriptors();
        for (ProjectManager.IProjectDescriptor projectDescriptor : this.project2descriptor.values()) {
            Collection<ProjectManager.IResourceDescriptor> resourceDescriptors = projectDescriptor.getResourceDescriptors();
            if (resourceDescriptors == null) continue;
            for (ProjectManager.IResourceDescriptor resourceDescriptor : resourceDescriptors) {
                assert (resourceDescriptor != null);
                if (!resourceDescriptor.hasEcoreModel()) continue;
                ProjectManager.IResourceLoadStatus resourceLoadStatus = resourceDescriptor.getResourceLoadStatus(resourceSet);
                resourceLoadStatus.setConflictHandler(MapToFirstConflictHandlerWithLog.INSTANCE);
            }
        }
    }

    public synchronized void initializePlatformResourceMap(boolean force) {
        if (force || !this.initializedPlatformResourceMap) {
            this.initializedPlatformResourceMap = true;
            this.getProjectDescriptors();
            for (ProjectManager.IProjectDescriptor projectDescriptor : this.project2descriptor.values()) {
                projectDescriptor.initializePlatformResourceMap();
            }
        }
    }

    @Override
    public void initializeResourceSet(@Nullable ResourceSet resourceSet) {
        EList eAdapters;
        StandaloneProjectMap.initializeURIResourceMap(resourceSet);
        this.initializePlatformResourceMap(false);
        this.initializeURIMap(resourceSet);
        this.initializeGenModelLocationMap(false);
        this.initializePackageRegistry(resourceSet);
        if (resourceSet != null && !(eAdapters = resourceSet.eAdapters()).contains(this)) {
            eAdapters.add(this);
        }
    }

    public synchronized void initializeURIMap(@Nullable ResourceSet resourceSet) {
        this.getProjectDescriptors();
        Map<URI, URI> uriMap = StandaloneProjectMap.getURIMap(resourceSet);
        for (String project : this.project2descriptor.keySet()) {
            ProjectManager.IProjectDescriptor projectDescriptor = this.project2descriptor.get(project);
            projectDescriptor.initializeURIMap(uriMap);
        }
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(StandaloneProjectMap.class);
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    protected void logException(@NonNull String message, @NonNull Exception e) {
        Map<String, Exception> exceptionMap2;
        Set<String> alreadyLogged2 = alreadyLogged;
        if (alreadyLogged2 == null) {
            alreadyLogged = alreadyLogged2 = new HashSet<String>();
        }
        if (alreadyLogged2.add(message)) {
            logger.info((Object)message, (Throwable)e);
        }
        if ((exceptionMap2 = this.exceptionMap) == null) {
            this.exceptionMap = exceptionMap2 = new HashMap<String, Exception>();
        }
        exceptionMap2.put(message, e);
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof ResourceSet) {
            int eventType = notification.getEventType();
            int featureID = notification.getFeatureID(ResourceSet.class);
            if (featureID == 0) {
                Object newValues;
                if (eventType == 3) {
                    Object newValue = notification.getNewValue();
                    if (newValue instanceof Resource) {
                        this.notifyAddedDynamicResource((ResourceSet)notifier, (Resource)newValue);
                    }
                } else if (eventType == 5 && (newValues = notification.getNewValue()) instanceof Iterable) {
                    for (Object newValue : (Iterable)newValues) {
                        if (!(newValue instanceof Resource)) continue;
                        this.notifyAddedDynamicResource((ResourceSet)notifier, (Resource)newValue);
                    }
                }
            }
        }
    }

    protected void notifyAddedDynamicResource(@NonNull ResourceSet resourceSet, @NonNull Resource resource) {
        URI uri;
        ProjectManager.IResourceDescriptor resourceDescriptor;
        Map<URI, ProjectManager.IResourceDescriptor> uri2resource2;
        if (resourceSet instanceof ResourceSetImpl && (uri2resource2 = this.uri2resource) != null && (resourceDescriptor = uri2resource2.get(uri = resource.getURI())) != null) {
            resourceDescriptor.addedDynamicResource(resourceSet, resource);
        }
    }

    @Nullable
    protected ProjectManager.IProjectDescriptor registerBundle(@NonNull File file, @NonNull SAXParser saxParser) {
        block32: {
            ProjectManager.IProjectDescriptor iProjectDescriptor;
            JarFile jarFile = null;
            try {
                ProjectManager.IProjectDescriptor projectDescriptor;
                jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    return null;
                }
                String project = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (project == null) break block32;
                int indexOf = project.indexOf(59);
                if (indexOf > 0) {
                    project = project.substring(0, indexOf);
                }
                if ((projectDescriptor = this.project2descriptor.get(project)) != null) {
                    ProjectManager.IProjectDescriptor iProjectDescriptor2 = projectDescriptor;
                    return iProjectDescriptor2;
                }
                String path = "archive:" + file.toURI() + "!/";
                URI locationURI = URI.createURI((String)path);
                assert (project != null);
                projectDescriptor = this.createProjectDescriptor(project, locationURI);
                this.project2descriptor.put(project, projectDescriptor);
                ZipEntry entry = jarFile.getEntry("plugin.xml");
                if (entry != null) {
                    try (InputStream inputStream = jarFile.getInputStream(entry);){
                        PluginReader pluginReader = new PluginReader(jarFile, projectDescriptor);
                        saxParser.parse(inputStream, (DefaultHandler)pluginReader);
                        pluginReader.scanContents(saxParser);
                    }
                }
                iProjectDescriptor = projectDescriptor;
            }
            catch (ZipException e) {
                this.logException("Could not open Jar file '" + file.getAbsolutePath() + "'", e);
                break block32;
            }
            catch (Exception e) {
                this.logException("Failed to read '" + file.getAbsolutePath() + "'", e);
                break block32;
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return iProjectDescriptor;
        }
        return null;
    }

    @Nullable
    protected ProjectManager.IProjectDescriptor registerProject(@NonNull File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            String project = document.getDocumentElement().getElementsByTagName("name").item(0).getTextContent();
            if (project != null) {
                URI locationURI = URI.createFileURI((String)(String.valueOf(file.getParentFile().getCanonicalPath()) + File.separator));
                ProjectManager.IProjectDescriptor projectDescriptor = this.createProjectDescriptor(project, locationURI);
                this.project2descriptor.put(project, projectDescriptor);
                ProjectManager.IProjectDescriptor iProjectDescriptor = projectDescriptor;
                return iProjectDescriptor;
            }
        }
        catch (Exception e) {
            this.logException("Couldn't read '" + file + "'", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected void scanClassPath(@NonNull Map<String, ProjectManager.IProjectDescriptor> projectDescriptors, @NonNull SAXParser saxParser) {
        String property = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        if (property != null) {
            String[] entries;
            String[] stringArray = entries = property.split(separator);
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                File fileEntry = new File(entry);
                try {
                    File plugIn;
                    ProjectManager.IProjectDescriptor projectDescriptor;
                    File parentFile;
                    File dotProject;
                    File f = fileEntry.getCanonicalFile();
                    if (f.getPath().endsWith(".jar")) {
                        this.registerBundle(f, saxParser);
                    } else if (!this.scanFolder(f, saxParser, new HashSet<String>(), 0) && (dotProject = new File(parentFile = f.getParentFile(), ".project")).exists() && (projectDescriptor = this.registerProject(dotProject)) != null && (plugIn = new File(parentFile, "plugin.xml")).exists()) {
                        PluginReader pluginReader = new PluginReader(projectDescriptor);
                        saxParser.parse(plugIn, (DefaultHandler)pluginReader);
                        pluginReader.scanContents(saxParser);
                    }
                }
                catch (Exception e) {
                    this.logException("Failed to read '" + fileEntry + "'", e);
                }
                ++n2;
            }
        }
    }

    protected boolean scanFolder(@NonNull File f, @NonNull SAXParser saxParser, @NonNull Set<String> alreadyVisited, int depth) {
        try {
            if (!alreadyVisited.add(f.getCanonicalPath())) {
                return true;
            }
        }
        catch (Exception e) {
            this.logException("Failed to scan '" + f + "'", e);
            return true;
        }
        File[] files = f.listFiles();
        boolean containsProject = false;
        File dotProject = null;
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.exists() && file.isDirectory() && depth < 2 && !file.getName().startsWith(".")) {
                    containsProject |= this.scanFolder(file, saxParser, alreadyVisited, depth + 1);
                } else if (".project".equals(file.getName())) {
                    dotProject = file;
                } else if (file.getName().endsWith(".jar")) {
                    this.registerBundle(file, saxParser);
                }
                ++n2;
            }
        }
        if (!containsProject && dotProject != null) {
            this.registerProject(dotProject);
        }
        return containsProject || dotProject != null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.project2descriptor != null) {
            ArrayList<String> projectNames = new ArrayList<String>(this.project2descriptor.keySet());
            Collections.sort(projectNames);
            for (String projectName : projectNames) {
                if (s.length() > 0) {
                    s.append("\n");
                }
                s.append(projectName);
                s.append(" => ");
                s.append(this.project2descriptor.get(projectName).getLocationURI());
            }
        }
        return s.toString();
    }

    @Override
    public void unload(@NonNull ResourceSet resourceSet) {
        resourceSet.eAdapters().remove((Object)this);
        if (this.project2descriptor != null) {
            for (ProjectManager.IProjectDescriptor projectDescriptor : this.project2descriptor.values()) {
                projectDescriptor.unload(resourceSet);
            }
        }
    }

    @Override
    public void useGeneratedResource(@NonNull Resource resource, @NonNull ResourceSet resourceSet) {
        ProjectManager.IPackageDescriptor packageDescriptor;
        URI uri = resource.getURI();
        if (uri != null && (packageDescriptor = this.getPackageDescriptor(uri)) != null) {
            ProjectManager.IResourceDescriptor resourceDescriptor = packageDescriptor.getResourceDescriptor();
            ProjectManager.IResourceLoadStatus resourceLoadStatus = resourceDescriptor.getResourceLoadStatus(resourceSet);
            ProjectManager.IResourceLoadStrategy resourceLoadStrategy = resourceLoadStatus.getResourceLoadStrategy();
            if (PROJECT_MAP_GET.isActive()) {
                PROJECT_MAP_GET.println("Use " + uri + " with " + resourceLoadStrategy + " in " + NameUtil.debugSimpleName(resourceLoadStatus.getPackageRegistry()));
            }
            resourceLoadStrategy.useGeneratedResource(resourceLoadStatus, resource);
        }
    }

    public static abstract class AbstractResourceDescriptor
    implements ProjectManager.IResourceDescriptor {
        @NonNull
        protected final ProjectManager.IProjectDescriptor projectDescriptor;
        @NonNull
        protected final URI genModelURI;
        @Nullable
        private URI locationURI = null;
        @Nullable
        private URI platformResourceURI = null;
        @Nullable
        private URI platformPluginURI = null;
        @NonNull
        protected final List<ProjectManager.IPackageDescriptor> packageDescriptors = new ArrayList<ProjectManager.IPackageDescriptor>();
        private boolean hasEcoreModel = false;
        @NonNull
        private final WeakHashMap<ResourceSet, ProjectManager.IResourceLoadStatus> resourceSet2resourceLoadStatus = new WeakHashMap();

        protected AbstractResourceDescriptor(@NonNull ProjectManager.IProjectDescriptor projectDescriptor, @NonNull URI genModelURI, @NonNull Map<URI, String> nsURI2className) {
            this.projectDescriptor = projectDescriptor;
            this.genModelURI = genModelURI;
            for (URI nsURI : nsURI2className.keySet()) {
                String className = nsURI2className.get(nsURI);
                ProjectManager.IPackageDescriptor packageDescriptor = projectDescriptor.getPackageDescriptor(nsURI);
                if (packageDescriptor != null) continue;
                if (PROJECT_MAP_ADD_GENERATED_PACKAGE.isActive()) {
                    PROJECT_MAP_ADD_GENERATED_PACKAGE.println(nsURI + " : " + genModelURI + " : " + className);
                }
                packageDescriptor = new PackageDescriptor(this, nsURI, className);
                projectDescriptor.addPackageDescriptor(packageDescriptor);
                this.packageDescriptors.add(packageDescriptor);
            }
            projectDescriptor.addResourceDescriptor(this);
        }

        @Override
        public void addedDynamicResource(@NonNull ResourceSet resourceSet, @NonNull Resource resource) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = this.resourceSet2resourceLoadStatus.get(resourceSet);
            if (resourceLoadStatus != null) {
                ProjectManager.IResourceLoadStrategy resourceLoadStrategy = resourceLoadStatus.getResourceLoadStrategy();
                if (PROJECT_MAP_GET.isActive()) {
                    PROJECT_MAP_GET.println("Add " + resource.getURI() + " with " + resourceLoadStrategy + " in " + NameUtil.debugSimpleName(resourceSet.getPackageRegistry()));
                }
                resourceLoadStrategy.addedDynamicResource(resourceLoadStatus, resource);
            }
        }

        @Override
        public void addedGeneratedPackage(@NonNull ResourceSet resourceSet, @NonNull EPackage ePackage) {
            ProjectManager.IPackageLoadStatus packageLoadStatus;
            ProjectManager.IResourceLoadStatus resourceLoadStatus = this.resourceSet2resourceLoadStatus.get(resourceSet);
            URI uri = URI.createURI((String)ePackage.getNsURI());
            ProjectManager.IPackageDescriptor packageDescriptor = this.getProjectDescriptor().getPackageDescriptor(uri);
            if (packageDescriptor != null && (packageLoadStatus = resourceLoadStatus.getPackageLoadStatus(packageDescriptor)) != null) {
                resourceLoadStatus.getResourceLoadStrategy().addedGeneratedPackage(packageLoadStatus, ePackage);
            }
        }

        @Override
        public void configure(@Nullable ResourceSet resourceSet, @NonNull ProjectManager.IResourceLoadStrategy resourceLoadStrategy, @Nullable ProjectManager.IConflictHandler conflictHandler) {
            if (this.hasEcoreModel) {
                ProjectManager.IResourceLoadStatus resourceLoadStatus = this.getResourceLoadStatus(resourceSet);
                resourceLoadStrategy.configure(resourceLoadStatus, conflictHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void configureResourceSetURIResourceMap(@NonNull ResourceSet resourceSet, @NonNull Resource resource) {
            HashMap<URI, Resource> uriResourceMap;
            ResourceSet resourceSet2 = resourceSet;
            synchronized (resourceSet2) {
                uriResourceMap = ((ResourceSetImpl)resourceSet).getURIResourceMap();
                if (uriResourceMap == null) {
                    uriResourceMap = new HashMap<URI, Resource>();
                    ((ResourceSetImpl)resourceSet).setURIResourceMap(uriResourceMap);
                }
            }
            URI platformPluginURI = this.getPlatformPluginURI();
            URI platformResourceURI = this.getPlatformResourceURI();
            HashMap<URI, Resource> hashMap = uriResourceMap;
            synchronized (hashMap) {
                uriResourceMap.put(platformPluginURI, resource);
                uriResourceMap.put(platformResourceURI, resource);
            }
            if (PROJECT_MAP_RESOLVE.isActive()) {
                URI uri = resource.getURI();
                PROJECT_MAP_RESOLVE.println("ResourceSet.uriResourceMap[" + platformPluginURI + "] => " + uri);
                PROJECT_MAP_RESOLVE.println("ResourceSet.uriResourceMap[" + platformResourceURI + "] => " + uri);
            }
        }

        @NonNull
        protected abstract ProjectManager.IResourceLoadStatus createResourceLoadStatus(@Nullable ResourceSet var1);

        @Override
        @NonNull
        public URI getGenModelURI() {
            return this.genModelURI;
        }

        @Override
        @NonNull
        public URI getLocationURI() {
            return ClassUtil.nonNullState(this.locationURI);
        }

        @NonNull
        public List<? extends ProjectManager.IPackageDescriptor> getPackageDescriptors() {
            return this.packageDescriptors;
        }

        @Override
        @NonNull
        public URI getPlatformPluginURI() {
            return ClassUtil.nonNullState(this.platformPluginURI);
        }

        @Override
        @NonNull
        public URI getPlatformResourceURI() {
            return ClassUtil.nonNullState(this.platformResourceURI);
        }

        @Override
        @NonNull
        public ProjectManager.IProjectDescriptor getProjectDescriptor() {
            return this.projectDescriptor;
        }

        @Override
        @NonNull
        public URI getProjectRelativeEcorePackageURI(@NonNull URI genModelRelativeEcorePackageURI) {
            URI projectLocationURI = this.projectDescriptor.getLocationURI();
            URI absoluteGenModelURI = this.genModelURI.resolve(projectLocationURI);
            URI absolutePackageURI = genModelRelativeEcorePackageURI.resolve(absoluteGenModelURI);
            URI projectRelativeEcorePackageURI = absolutePackageURI.deresolve(projectLocationURI, true, true, true);
            return projectRelativeEcorePackageURI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NonNull
        public ProjectManager.IResourceLoadStatus getResourceLoadStatus(@Nullable ResourceSet resourceSet) {
            assert (this.hasEcoreModel);
            ProjectManager.IResourceLoadStatus resourceLoadStatus = this.resourceSet2resourceLoadStatus.get(resourceSet);
            if (resourceLoadStatus == null) {
                WeakHashMap<ResourceSet, ProjectManager.IResourceLoadStatus> weakHashMap = this.resourceSet2resourceLoadStatus;
                synchronized (weakHashMap) {
                    resourceLoadStatus = this.resourceSet2resourceLoadStatus.get(resourceSet);
                    if (resourceLoadStatus == null) {
                        resourceLoadStatus = this.createResourceLoadStatus(resourceSet);
                        this.resourceSet2resourceLoadStatus.put(resourceSet, resourceLoadStatus);
                    }
                }
            }
            return resourceLoadStatus;
        }

        @Override
        public boolean hasEcoreModel() {
            return this.hasEcoreModel;
        }

        @Override
        public void setEcoreModel(@NonNull List<String> genModelRelativeEcorePackageUris, @NonNull Map<String, ProjectManager.IPackageDescriptor> nsURI2packageDescriptor) {
            int size = genModelRelativeEcorePackageUris.size();
            if (size > 0) {
                String firstGenModelRelativeEcorePackageUri = genModelRelativeEcorePackageUris.get(0);
                URI firstGenModelRelativeEcorePackageURI = URI.createURI((String)firstGenModelRelativeEcorePackageUri);
                URI genModelRelativeEcoreModelURI = firstGenModelRelativeEcorePackageURI.trimFragment();
                URI projectLocationURI = this.projectDescriptor.getLocationURI();
                URI absoluteGenModelURI = this.genModelURI.resolve(projectLocationURI);
                URI absolutePackageURI = genModelRelativeEcoreModelURI.resolve(absoluteGenModelURI);
                URI relativePackageURI = absolutePackageURI.deresolve(projectLocationURI, true, true, true);
                URI relativeEcoreModelURI = relativePackageURI.trimFragment();
                URI resourceURI = this.projectDescriptor.getPlatformResourceURI();
                URI pluginURI = this.projectDescriptor.getPlatformPluginURI();
                this.platformResourceURI = relativeEcoreModelURI.resolve(resourceURI);
                this.platformPluginURI = relativeEcoreModelURI.resolve(pluginURI);
                this.locationURI = relativeEcoreModelURI.resolve(projectLocationURI);
                this.projectDescriptor.getProjectManager().addResourceDescriptor(this);
            }
            this.hasEcoreModel = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unload(@NonNull ResourceSet resourceSet) {
            if (this.hasEcoreModel()) {
                WeakHashMap<ResourceSet, ProjectManager.IResourceLoadStatus> weakHashMap = this.resourceSet2resourceLoadStatus;
                synchronized (weakHashMap) {
                    ProjectManager.IResourceLoadStatus resourceLoadStatus = this.resourceSet2resourceLoadStatus.remove(resourceSet);
                    if (resourceLoadStatus != null) {
                        resourceLoadStatus.dispose();
                    }
                }
            }
        }
    }

    public static abstract class AbstractResourceLoadStatus
    implements ProjectManager.IResourceLoadStatus,
    Adapter {
        @NonNull
        protected final ProjectManager.IResourceDescriptor resourceDescriptor;
        @Nullable
        protected ResourceSet resourceSet;
        @NonNull
        private final Map<URI, PackageLoadStatus> nsURI2packageLoadStatus = new HashMap<URI, PackageLoadStatus>();
        @NonNull
        protected final EPackage.Registry packageRegistry;
        @Nullable
        protected ProjectManager.IConflictHandler conflictHandler = MapToFirstConflictHandlerWithLog.INSTANCE;
        @NonNull
        protected ProjectManager.IResourceLoadStrategy resourceLoadStrategy = LoadFirstStrategy.INSTANCE;
        @Nullable
        private Notifier target = null;
        @Nullable
        protected Resource eModel = null;
        protected boolean generativeLoadInProgress = false;
        protected boolean recursiveLoadInProgress = false;

        protected AbstractResourceLoadStatus(@NonNull ProjectManager.IResourceDescriptor resourceDescriptor, @Nullable ResourceSet resourceSet) {
            this.resourceDescriptor = resourceDescriptor;
            this.resourceSet = resourceSet;
            this.packageRegistry = StandaloneProjectMap.getPackageRegistry(resourceSet);
            for (ProjectManager.IPackageDescriptor iPackageDescriptor : resourceDescriptor.getPackageDescriptors()) {
                this.nsURI2packageLoadStatus.put(iPackageDescriptor.getNsURI(), new PackageLoadStatus(this, iPackageDescriptor));
            }
        }

        @Override
        public void configureEPackageRegistry(@NonNull Resource resource) {
            ResourceSet resourceSet2 = this.resourceSet;
            if (resourceSet2 != null) {
                for (ProjectManager.IPackageLoadStatus iPackageLoadStatus : this.nsURI2packageLoadStatus.values()) {
                    EPackage ePackage = iPackageLoadStatus.getEPackage();
                    if (ePackage == null) continue;
                    iPackageLoadStatus.configureEPackageRegistry(resourceSet2);
                }
            }
        }

        @Override
        public void configureDelegatingResource() {
            ResourceSet resourceSet2 = this.resourceSet;
            if (resourceSet2 != null) {
                ResourceImpl resource;
                Collection<PackageLoadStatus> packageLoadStatuses = this.nsURI2packageLoadStatus.values();
                URI uri = this.resourceDescriptor.getGenModelURI().appendFileExtension("ecore");
                if (packageLoadStatuses.size() == 1) {
                    PackageLoadStatus packageLoadStatus = packageLoadStatuses.iterator().next();
                    resource = new DelegatedSinglePackageResource(uri, packageLoadStatus);
                } else {
                    resource = new DelegatedMultiplePackageResource(uri, this, packageLoadStatuses);
                }
                this.resourceDescriptor.configureResourceSetURIResourceMap(resourceSet2, (Resource)resource);
            }
        }

        @Override
        public void configureResourceSetURIResourceMap(@NonNull Resource resource) {
            ResourceSet resourceSet2 = this.resourceSet;
            if (resourceSet2 != null) {
                this.resourceDescriptor.configureResourceSetURIResourceMap(resourceSet2, resource);
            }
        }

        @Override
        public void dispose() {
            this.resourceSet = null;
            if (this.target != null) {
                this.target.eAdapters().remove((Object)this);
                this.target = null;
            }
        }

        @Override
        @Nullable
        public EPackage getConflictingDynamicResource(@NonNull EPackage ePackage) {
            if (this.conflictHandler != null) {
                return this.conflictHandler.handleConflictingDynamicResource(this, ePackage);
            }
            return null;
        }

        @Override
        @Nullable
        public EPackage getFirstEPackage() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public ProjectManager.IPackageLoadStatus getPackageLoadStatus(@NonNull ProjectManager.IPackageDescriptor packageDescriptor) {
            return this.nsURI2packageLoadStatus.get(packageDescriptor.getNsURI());
        }

        @Override
        @NonNull
        public ProjectManager.IResourceLoadStrategy getResourceLoadStrategy() {
            return this.resourceLoadStrategy;
        }

        @Override
        @NonNull
        public EPackage.Registry getPackageRegistry() {
            return this.packageRegistry;
        }

        @Override
        @NonNull
        public ProjectManager.IResourceDescriptor getResourceDescriptor() {
            return this.resourceDescriptor;
        }

        @Nullable
        public Resource getResource() {
            Resource eModel2 = this.eModel;
            if (eModel2 == null) {
                try {
                    this.recursiveLoadInProgress = true;
                    ProjectManager.IResourceDescriptor resourceDescriptor2 = this.getResourceDescriptor();
                    if (resourceDescriptor2.hasEcoreModel()) {
                        URI platformResourceURI = resourceDescriptor2.getPlatformResourceURI();
                        ResourceSet resourceSet = this.resourceSet != null ? this.resourceSet : new ResourceSetImpl();
                        resourceSet.createResource(platformResourceURI);
                    }
                }
                finally {
                    this.recursiveLoadInProgress = false;
                }
            }
            return this.eModel;
        }

        @Override
        @Nullable
        public ResourceSet getResourceSet() {
            return this.resourceSet;
        }

        @Nullable
        public Notifier getTarget() {
            return this.target;
        }

        @Nullable
        public EPackage handleConflictingGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            if (this.conflictHandler != null && this.eModel != null) {
                return this.conflictHandler.handleConflictingGeneratedPackage(packageLoadStatus, this.eModel);
            }
            EPackage ePackage = packageLoadStatus.getEPackage();
            if (ePackage == null) {
                ePackage = packageLoadStatus.getEPackageInstance();
            }
            return ePackage;
        }

        protected void handleLoadException(Resource resource, @NonNull String location, Exception exception) throws RuntimeException {
            Exception cause = exception instanceof Resource.IOWrappedException ? (Exception)exception.getCause() : exception;
            class DiagnosticWrappedException
            extends WrappedException
            implements Resource.Diagnostic {
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ String val$location;

                public DiagnosticWrappedException(Exception exception, String string) {
                    this.val$location = string;
                    super(exception);
                }

                public String getLocation() {
                    return this.val$location;
                }

                public int getColumn() {
                    return 0;
                }

                public int getLine() {
                    return 0;
                }
            }
            DiagnosticWrappedException wrappedException = new DiagnosticWrappedException(cause, location);
            if (resource != null && resource.getErrors().isEmpty()) {
                resource.getErrors().add(exception instanceof Resource.Diagnostic ? (Resource.Diagnostic)exception : wrappedException);
            }
            throw wrappedException;
        }

        protected void install() {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        @Override
        public void loadGeneratedPackages() {
            for (ProjectManager.IPackageLoadStatus iPackageLoadStatus : this.nsURI2packageLoadStatus.values()) {
                iPackageLoadStatus.loadEPackage();
            }
        }

        @Override
        @Nullable
        public synchronized Resource loadDynamicResource(@NonNull URI nsURI) {
            if (this.recursiveLoadInProgress) {
                logger.error((Object)("Attempt to load self-referential '" + nsURI + "' as model replaced by registered EPackage"));
                return this.eModel;
            }
            return this.getResource();
        }

        private void loadedDynamicResource(@NonNull ResourceSet resourceSet, @NonNull EPackage ePackage) {
            ProjectManager.IPackageLoadStatus packageLoadStatus;
            URI uri;
            ProjectManager projectMap;
            ProjectManager.IPackageDescriptor packageDescriptor;
            String nsURI = ePackage.getNsURI();
            if (nsURI != null && (packageDescriptor = (projectMap = this.resourceDescriptor.getProjectDescriptor().getProjectManager()).getPackageDescriptor(uri = URI.createURI((String)nsURI))) != null && (packageLoadStatus = this.getPackageLoadStatus(packageDescriptor)) != null) {
                packageLoadStatus.setModel(ePackage);
                if (PROJECT_MAP_RESOLVE.isActive()) {
                    PROJECT_MAP_RESOLVE.println(String.valueOf(ePackage.getNsURI()) + " => " + ePackage.eResource().getURI() + " : " + NameUtil.debugSimpleName(ePackage));
                }
            }
            for (EPackage eSubPackage : ePackage.getESubpackages()) {
                if (eSubPackage == null) continue;
                this.loadedDynamicResource(resourceSet, eSubPackage);
            }
        }

        private void loadedDynamicResource(@NonNull Resource newResource) {
            ResourceSet resourceSet = newResource.getResourceSet();
            if (resourceSet != null) {
                for (EObject eObject : newResource.getContents()) {
                    if (!(eObject instanceof EPackage)) continue;
                    EPackage ePackage = (EPackage)eObject;
                    this.loadedDynamicResource(resourceSet, ePackage);
                }
            }
            this.resourceLoadStrategy.loadedDynamicResource(this, newResource);
        }

        public void notifyChanged(Notification notification) {
            int eventType;
            int id;
            if (notification.getNotifier() == this.target && (id = notification.getFeatureID(Resource.class)) == 4 && (eventType = notification.getEventType()) == 1) {
                boolean wasLoaded = notification.getOldBooleanValue();
                boolean isLoaded = notification.getNewBooleanValue();
                if (isLoaded && !wasLoaded) {
                    if (this.target instanceof Resource) {
                        this.loadedDynamicResource((Resource)this.target);
                    }
                } else if (!isLoaded && wasLoaded) {
                    this.resourceLoadStrategy.unloadedResource(this);
                }
            }
        }

        @Override
        public void setConflictHandler(@Nullable ProjectManager.IConflictHandler conflictHandler) {
            this.conflictHandler = conflictHandler;
        }

        @Override
        public void setGenerationInProgress(boolean isGenerating) {
            assert (!this.recursiveLoadInProgress);
            this.generativeLoadInProgress = isGenerating;
        }

        @Override
        public void setResource(@NonNull Resource resource) {
            assert (this.eModel == null);
            this.eModel = resource;
            if (!resource.isLoaded() && !this.generativeLoadInProgress) {
                try {
                    InputStream inputStream = resource.getResourceSet().getURIConverter().createInputStream(resource.getURI());
                    EList eAdapters = resource.eAdapters();
                    if (!eAdapters.contains(this)) {
                        eAdapters.add(this);
                    }
                    resource.load(inputStream, null);
                }
                catch (Exception exception) {
                    this.handleLoadException(resource, ClassUtil.nonNullEMF(resource.getURI().toString()), exception);
                }
            }
        }

        @Override
        public void setResourceLoadStrategy(@NonNull ProjectManager.IResourceLoadStrategy resourceLoadStrategy) {
            this.resourceLoadStrategy = resourceLoadStrategy;
            if (PROJECT_MAP_CONFIGURE.isActive()) {
                PROJECT_MAP_CONFIGURE.println(this.toString());
            }
        }

        public void setTarget(Notifier newTarget) {
            this.target = newTarget;
        }

        @NonNull
        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.resourceLoadStrategy + " for " + this.resourceDescriptor.getGenModelURI());
            if (this.packageRegistry == EPackage.Registry.INSTANCE) {
                s.append(" in global ");
            } else {
                s.append(" in ");
            }
            s.append(NameUtil.debugSimpleName(this.packageRegistry));
            String string = s.toString();
            return string;
        }

        @Override
        public void unloadedResource() {
            for (ProjectManager.IPackageLoadStatus iPackageLoadStatus : this.nsURI2packageLoadStatus.values()) {
                iPackageLoadStatus.unloadedResource();
            }
        }
    }

    protected static abstract class AbstractResourceLoadStrategy
    implements ProjectManager.IResourceLoadStrategy {
        protected AbstractResourceLoadStrategy() {
        }

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addedGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public EPackage basicGetEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return null;
        }

        @Override
        public void configure(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @Nullable ProjectManager.IConflictHandler conflictHandler) {
            resourceLoadStatus.setConflictHandler(conflictHandler);
            resourceLoadStatus.setResourceLoadStrategy(this);
        }

        @Override
        public void handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull EPackage ePackage) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        protected EPackage loadEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, boolean configureURImap) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = packageLoadStatus.getResourceLoadStatus();
            resourceLoadStatus.loadGeneratedPackages();
            EPackage ePackage = packageLoadStatus.getEPackage();
            if (ePackage == null) {
                ePackage = packageLoadStatus.getEPackageInstance();
            }
            if (configureURImap) {
                resourceLoadStatus.configureDelegatingResource();
            }
            return this.returnEPackage(packageLoadStatus, ePackage);
        }

        @Nullable
        protected EPackage loadModel(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            packageLoadStatus.getResourceLoadStatus().loadDynamicResource(packageLoadStatus.getPackageDescriptor().getNsURI());
            EPackage ePackage = packageLoadStatus.getModel();
            if (ePackage == null) {
                ePackage = packageLoadStatus.getEPackageInstance();
            }
            return this.returnEPackage(packageLoadStatus, ePackage);
        }

        @Override
        public void loadedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus, @NonNull Resource resource) {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Nullable
        protected EPackage returnEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @Nullable EPackage ePackage) {
            if (ePackage != null && PROJECT_MAP_RESOLVE.isActive()) {
                URI uri = EcoreUtil.getURI((EObject)ePackage);
                PROJECT_MAP_RESOLVE.println("EPackage.Registry[" + packageLoadStatus.getPackageDescriptor().getNsURI() + "] => " + uri);
            }
            return ePackage;
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            throw new UnsupportedOperationException();
        }
    }

    public static class DelegatedMultiplePackageResource
    extends ResourceImpl {
        @NonNull
        protected final ProjectManager.IResourceLoadStatus resourceLoadStatus;
        @NonNull
        protected final Iterable<PackageLoadStatus> packageLoadStatuses;
        @NonNull
        private final Map<String, EPackage> fragment2ePackage = new HashMap<String, EPackage>();

        public DelegatedMultiplePackageResource(@NonNull URI uri, @NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Iterable<PackageLoadStatus> packageLoadStatuses) {
            super(uri);
            this.resourceLoadStatus = resourceLoadStatus;
            this.packageLoadStatuses = packageLoadStatuses;
            for (ProjectManager.IPackageLoadStatus iPackageLoadStatus : packageLoadStatuses) {
                EPackage ePackage = iPackageLoadStatus.loadEPackage();
                if (ePackage == null) continue;
                StringBuilder s = new StringBuilder();
                this.computeFragment(s, ePackage);
                this.fragment2ePackage.put(s.toString(), ePackage);
            }
            this.setLoaded(true);
        }

        public EObject getEObject(String uriFragment) {
            if (uriFragment == null) {
                return null;
            }
            EPackage ePackage = this.fragment2ePackage.get(uriFragment);
            EPackage eObject = ePackage;
            if (eObject == null) {
                for (String uri : this.fragment2ePackage.keySet()) {
                    Resource resource;
                    if (uriFragment.startsWith(uri) && (eObject = (resource = (ePackage = this.fragment2ePackage.get(uri)).eResource()).getEObject(uriFragment)) != null) break;
                }
            }
            if (ePackage != null) {
                ProjectManager.IResourceLoadStrategy resourceLoadStrategy = this.resourceLoadStatus.getResourceLoadStrategy();
                resourceLoadStrategy.handleConflictingDynamicResource(this.resourceLoadStatus, ePackage);
                return eObject;
            }
            return null;
        }

        private void computeFragment(@NonNull StringBuilder s, @NonNull EPackage ePackage) {
            EPackage eSuperPackage = ePackage.getESuperPackage();
            if (eSuperPackage == null) {
                s.append("/");
            } else {
                this.computeFragment(s, eSuperPackage);
                s.append("/");
                s.append(ePackage.getName());
            }
        }
    }

    public static class DelegatedSinglePackageResource
    extends ResourceImpl {
        @NonNull
        private static EList<EObject> EMPTY_LIST = new BasicEList.UnmodifiableEList(0, new Object[0]);
        @NonNull
        protected final ProjectManager.IPackageLoadStatus packageLoadStatus;
        @Nullable
        private final EPackage ePackage;
        @Nullable
        private final Resource eResource;

        public DelegatedSinglePackageResource(@NonNull URI uri, @NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            super(uri);
            this.packageLoadStatus = packageLoadStatus;
            this.ePackage = packageLoadStatus.loadEPackage();
            this.eResource = this.ePackage != null ? this.ePackage.eResource() : null;
            this.setLoaded(true);
        }

        public EList<EObject> getContents() {
            return this.eResource != null ? this.eResource.getContents() : EMPTY_LIST;
        }

        public EObject getEObject(String uriFragment) {
            if (uriFragment == null) {
                return null;
            }
            EPackage ePackage2 = this.ePackage;
            if (ePackage2 == null) {
                return null;
            }
            Resource resource = ePackage2.eResource();
            EObject eObject = resource.getEObject(uriFragment);
            if (eObject != null) {
                ProjectManager.IResourceLoadStatus resourceLoadStatus = this.packageLoadStatus.getResourceLoadStatus();
                ProjectManager.IResourceLoadStrategy resourceLoadStrategy = resourceLoadStatus.getResourceLoadStrategy();
                resourceLoadStrategy.handleConflictingDynamicResource(resourceLoadStatus, ePackage2);
            }
            return eObject;
        }

        @NonNull
        public Resource getResource() {
            return this.eResource != null ? this.eResource : this;
        }
    }

    protected static class EPackageDescriptor
    implements EPackage.Descriptor {
        @NonNull
        protected final ProjectManager.IPackageLoadStatus packageLoadStatus;

        protected EPackageDescriptor(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull EPackage.Registry packageRegistry) {
            this.packageLoadStatus = packageLoadStatus;
            packageRegistry.put((Object)this.getURI().toString(), (Object)this);
            if (PROJECT_MAP_INSTALL.isActive()) {
                PROJECT_MAP_INSTALL.println(this.toString());
            }
        }

        @Nullable
        public EPackage basicGetEPackage() {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = this.packageLoadStatus.getResourceLoadStatus();
            ProjectManager.IResourceLoadStrategy resourceLoadStrategy = resourceLoadStatus.getResourceLoadStrategy();
            if (PROJECT_MAP_GET.isActive()) {
                PROJECT_MAP_GET.println("BasicGet " + this.getURI() + " with " + resourceLoadStrategy + " in " + NameUtil.debugSimpleName(resourceLoadStatus.getPackageRegistry()));
            }
            return resourceLoadStrategy.basicGetEPackage(this.packageLoadStatus);
        }

        public EFactory getEFactory() {
            EPackage ePackage = this.basicGetEPackage();
            if (ePackage != null) {
                return ePackage.getEFactoryInstance();
            }
            return null;
        }

        @Nullable
        public EPackage getEPackage() {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = this.packageLoadStatus.getResourceLoadStatus();
            ProjectManager.IResourceLoadStrategy resourceLoadStrategy = resourceLoadStatus.getResourceLoadStrategy();
            if (PROJECT_MAP_GET.isActive()) {
                PROJECT_MAP_GET.println("Get " + this.getURI() + " with " + resourceLoadStrategy + " in " + NameUtil.debugSimpleName(resourceLoadStatus.getPackageRegistry()));
            }
            return resourceLoadStrategy.getEPackage(this.packageLoadStatus);
        }

        @NonNull
        public URI getURI() {
            return this.packageLoadStatus.getPackageDescriptor().getNsURI();
        }

        @NonNull
        public String toString() {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = this.packageLoadStatus.getResourceLoadStatus();
            ProjectManager.IResourceLoadStrategy resourceLoadStrategy = resourceLoadStatus.getResourceLoadStrategy();
            return this.getURI() + " with " + resourceLoadStrategy;
        }

        public void uninstall(@NonNull EPackage.Registry packageRegistry) {
            if (PROJECT_MAP_INSTALL.isActive()) {
                PROJECT_MAP_INSTALL.println(this.toString());
            }
            packageRegistry.put((Object)this.getURI().toString(), null);
        }
    }

    protected static class GenModelReader
    extends DefaultHandler {
        @NonNull
        public static final String genmodelTag = "genmodel:GenModel";
        @NonNull
        public static final String genPackagesTag = "genPackages";
        @NonNull
        public static final String nestedGenPackagesTag = "nestedGenPackages";
        @NonNull
        public static final String ecorePackageTag = "ecorePackage";
        @NonNull
        public static final String ecorePackageAttribute = "ecorePackage";
        @NonNull
        public static final String hrefAttribute = "href";
        @NonNull
        protected final ProjectManager.IResourceDescriptor resourceDescriptor;
        @NonNull
        protected final ProjectManager.IProjectDescriptor projectDescriptor;
        @NonNull
        protected final Map<String, ProjectManager.IPackageDescriptor> nsURI2packageDescriptor = new HashMap<String, ProjectManager.IPackageDescriptor>();
        @NonNull
        protected final URI genModelURI;
        @NonNull
        protected final List<String> ecorePackages = new ArrayList<String>();
        @NonNull
        private Stack<String> elements = new Stack();

        public static void initStatics() {
        }

        public GenModelReader(@NonNull ProjectManager.IResourceDescriptor resourceDescriptor) {
            this.resourceDescriptor = resourceDescriptor;
            this.projectDescriptor = resourceDescriptor.getProjectDescriptor();
            this.genModelURI = resourceDescriptor.getGenModelURI();
            for (ProjectManager.IPackageDescriptor iPackageDescriptor : resourceDescriptor.getPackageDescriptors()) {
                this.add(iPackageDescriptor);
            }
        }

        private void add(@NonNull ProjectManager.IPackageDescriptor packageDescriptor) {
            this.nsURI2packageDescriptor.put(packageDescriptor.getNsURI().toString(), packageDescriptor);
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            try {
                this.resourceDescriptor.setEcoreModel(this.ecorePackages, this.nsURI2packageDescriptor);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed lo read " + this.genModelURI), (Throwable)e);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.elements.pop();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String ecorePackage;
            String topElement;
            int size = this.elements.size();
            if (genPackagesTag.equals(qName)) {
                String ecorePackage2;
                if (size == 1 && genmodelTag.equals(this.elements.elementAt(0)) && (ecorePackage2 = attributes.getValue("ecorePackage")) != null) {
                    this.ecorePackages.add(ecorePackage2);
                }
            } else if (nestedGenPackagesTag.equals(qName)) {
                String ecorePackage3;
                if (size > 1 && genPackagesTag.equals(this.elements.elementAt(1)) && genmodelTag.equals(this.elements.elementAt(0)) && (ecorePackage3 = attributes.getValue("ecorePackage")) != null) {
                    this.ecorePackages.add(ecorePackage3);
                }
            } else if ("ecorePackage".equals(qName) && size >= 2 && genPackagesTag.equals(this.elements.elementAt(1)) && genmodelTag.equals(this.elements.elementAt(0)) && (genPackagesTag.equals(topElement = (String)this.elements.elementAt(size - 1)) || nestedGenPackagesTag.equals(topElement)) && (ecorePackage = attributes.getValue(hrefAttribute)) != null) {
                this.ecorePackages.add(ecorePackage);
            }
            this.elements.push(qName);
        }
    }

    public static final class LoadBothStrategy
    extends AbstractResourceLoadStrategy {
        @NonNull
        public static final ProjectManager.IResourceLoadStrategy INSTANCE = new LoadBothStrategy();

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            resourceLoadStatus.setResource(resource);
            resourceLoadStatus.configureResourceSetURIResourceMap(resource);
            resourceLoadStatus.setResourceLoadStrategy(LoadingBothLoadedDynamicResourceStrategy.INSTANCE);
        }

        @Override
        public void addedGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = packageLoadStatus.getResourceLoadStatus();
            Resource eResource = ePackage.eResource();
            if (eResource != null) {
                resourceLoadStatus.configureResourceSetURIResourceMap(eResource);
            }
            resourceLoadStatus.setResourceLoadStrategy(LoadedStrategy.INSTANCE);
        }

        @Override
        @Nullable
        public EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.loadEPackage(packageLoadStatus, false);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
            packageLoadStatus.unloadedResource();
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }
    }

    public static final class LoadDynamicResourceStrategy
    extends AbstractResourceLoadStrategy {
        @NonNull
        public static final ProjectManager.IResourceLoadStrategy INSTANCE = new LoadDynamicResourceStrategy();

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            resourceLoadStatus.setResource(resource);
            resourceLoadStatus.configureResourceSetURIResourceMap(resource);
            resourceLoadStatus.configureEPackageRegistry(resource);
            resourceLoadStatus.setResourceLoadStrategy(LoadedStrategy.INSTANCE);
        }

        @Override
        @Nullable
        public EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.loadModel(packageLoadStatus);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
        }
    }

    public static final class LoadFirstStrategy
    extends AbstractResourceLoadStrategy {
        @NonNull
        public static final ProjectManager.IResourceLoadStrategy INSTANCE = new LoadFirstStrategy();

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            resourceLoadStatus.configureResourceSetURIResourceMap(resource);
            resourceLoadStatus.setResourceLoadStrategy(LoadedFirstAsDynamicResourceStrategy.INSTANCE);
            resourceLoadStatus.setResource(resource);
        }

        @Override
        public void addedGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = packageLoadStatus.getResourceLoadStatus();
            Resource eResource = ePackage.eResource();
            if (eResource != null) {
                resourceLoadStatus.configureResourceSetURIResourceMap(eResource);
            }
            resourceLoadStatus.setResourceLoadStrategy(LoadedAsGeneratedPackageStrategy.INSTANCE);
        }

        @Override
        @Nullable
        public EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            EPackage loadEPackage = this.loadEPackage(packageLoadStatus, true);
            packageLoadStatus.getResourceLoadStatus().setResourceLoadStrategy(LoadedAsGeneratedPackageStrategy.INSTANCE);
            return loadEPackage;
        }

        @Override
        public void handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull EPackage ePackage) {
            resourceLoadStatus.getConflictingDynamicResource(ePackage);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            resourceLoadStatus.configureResourceSetURIResourceMap(resource);
            resourceLoadStatus.setResourceLoadStrategy(LoadedAsGeneratedPackageStrategy.INSTANCE);
        }
    }

    public static final class LoadGeneratedPackageStrategy
    extends AbstractResourceLoadStrategy {
        @NonNull
        public static final ProjectManager.IResourceLoadStrategy INSTANCE = new LoadGeneratedPackageStrategy();

        @Override
        public void addedGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = packageLoadStatus.getResourceLoadStatus();
            Resource eResource = ePackage.eResource();
            if (eResource != null) {
                resourceLoadStatus.configureResourceSetURIResourceMap(eResource);
            }
            resourceLoadStatus.setResourceLoadStrategy(LoadedStrategy.INSTANCE);
        }

        @Override
        public void configure(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @Nullable ProjectManager.IConflictHandler conflictHandler) {
            super.configure(resourceLoadStatus, conflictHandler);
            resourceLoadStatus.configureDelegatingResource();
        }

        @Override
        public void handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull EPackage ePackage) {
            resourceLoadStatus.getConflictingDynamicResource(ePackage);
        }

        @Override
        @Nullable
        public EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.loadEPackage(packageLoadStatus, false);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }
    }

    private static final class LoadedAsGeneratedPackageStrategy
    extends AbstractResourceLoadStrategy {
        @NonNull
        public static final ProjectManager.IResourceLoadStrategy INSTANCE = new LoadedAsGeneratedPackageStrategy();

        private LoadedAsGeneratedPackageStrategy() {
        }

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }

        @Override
        @Nullable
        public EPackage basicGetEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.getEPackage(packageLoadStatus);
        }

        @Override
        @Nullable
        public EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            EPackage ePackage = packageLoadStatus.getFirstEPackage();
            return this.returnEPackage(packageLoadStatus, ePackage);
        }

        @Override
        public void handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull EPackage ePackage) {
            resourceLoadStatus.getConflictingDynamicResource(ePackage);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }
    }

    private static final class LoadedFirstAsDynamicResourceStrategy
    extends AbstractResourceLoadStrategy {
        @NonNull
        public static final ProjectManager.IResourceLoadStrategy INSTANCE = new LoadedFirstAsDynamicResourceStrategy();

        private LoadedFirstAsDynamicResourceStrategy() {
        }

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }

        @Override
        @Nullable
        public EPackage basicGetEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.getEPackage(packageLoadStatus);
        }

        @Override
        @Nullable
        public EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            EPackage ePackage = packageLoadStatus.getConflictingGeneratedPackage();
            return this.returnEPackage(packageLoadStatus, ePackage);
        }

        @Override
        public void loadedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
            packageLoadStatus.unloadedResource();
            packageLoadStatus.setResourceLoadStrategy(LoadFirstStrategy.INSTANCE);
        }

        @Override
        public void useGeneratedResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
        }
    }

    private static final class LoadedStrategy
    extends AbstractResourceLoadStrategy {
        @NonNull
        public static final ProjectManager.IResourceLoadStrategy INSTANCE = new LoadedStrategy();

        private LoadedStrategy() {
        }

        @Override
        public void addedDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull Resource resource) {
            resourceLoadStatus.setResource(resource);
            resourceLoadStatus.setResourceLoadStrategy(INSTANCE);
        }

        @Override
        @Nullable
        public EPackage basicGetEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.getEPackage(packageLoadStatus);
        }

        @Override
        @Nullable
        public EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return packageLoadStatus.getFirstEPackage();
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
        }
    }

    public static final class LoadingBothLoadedDynamicResourceStrategy
    extends AbstractResourceLoadStrategy {
        @NonNull
        public static final ProjectManager.IResourceLoadStrategy INSTANCE = new LoadingBothLoadedDynamicResourceStrategy();

        @Override
        public void addedGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            ProjectManager.IResourceLoadStatus resourceLoadStatus = packageLoadStatus.getResourceLoadStatus();
            Resource eResource = ePackage.eResource();
            if (eResource != null) {
                resourceLoadStatus.configureResourceSetURIResourceMap(eResource);
            }
            resourceLoadStatus.setResourceLoadStrategy(LoadedStrategy.INSTANCE);
        }

        @Override
        @Nullable
        public EPackage getEPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus) {
            return this.loadEPackage(packageLoadStatus, false);
        }

        @Override
        public void unloadedResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus) {
            packageLoadStatus.unloadedResource();
        }
    }

    public static class MapToFirstConflictHandler
    implements ProjectManager.IConflictHandler {
        @NonNull
        public static final ProjectManager.IConflictHandler INSTANCE = new MapToFirstConflictHandler();

        @Override
        @Nullable
        public EPackage handleConflictingGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull Resource resource) {
            return packageLoadStatus.getFirstEPackage();
        }

        @Override
        @Nullable
        public EPackage handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus packageLoadStatus, @NonNull EPackage ePackage) {
            return ePackage;
        }
    }

    public static class MapToFirstConflictHandlerWithLog
    implements ProjectManager.IConflictHandler {
        @NonNull
        public static final ProjectManager.IConflictHandler INSTANCE = new MapToFirstConflictHandlerWithLog();

        @Override
        @Nullable
        public EPackage handleConflictingGeneratedPackage(@NonNull ProjectManager.IPackageLoadStatus packageLoadStatus, @NonNull Resource resource) {
            EPackage firstEPackage = packageLoadStatus.getFirstEPackage();
            ProjectManager.IPackageDescriptor packageDescriptor = packageLoadStatus.getPackageDescriptor();
            logger.error((Object)("Conflicting access to '" + packageDescriptor.getNsURI() + "' already accessed as '" + resource.getURI() + "'"));
            packageLoadStatus.getResourceLoadStatus().setConflictHandler(MapToFirstConflictHandler.INSTANCE);
            return firstEPackage;
        }

        @Override
        @Nullable
        public EPackage handleConflictingDynamicResource(@NonNull ProjectManager.IResourceLoadStatus resourceLoadStatus, @NonNull EPackage ePackage) {
            ProjectManager.IResourceDescriptor resourceDescriptor = resourceLoadStatus.getResourceDescriptor();
            logger.error((Object)("Conflicting access to '" + resourceDescriptor.getPlatformResourceURI() + "' or '" + resourceDescriptor.getPlatformPluginURI() + "' already accessed as '" + ePackage.getNsURI() + "'"));
            resourceLoadStatus.setConflictHandler(MapToFirstConflictHandler.INSTANCE);
            return ePackage;
        }
    }

    public static final class MultiplePackageResourceDescriptor
    extends AbstractResourceDescriptor {
        public MultiplePackageResourceDescriptor(@NonNull ProjectDescriptor projectDescriptor, @NonNull URI genModelURI, @NonNull Map<URI, String> nsURI2className) {
            super(projectDescriptor, genModelURI, nsURI2className);
        }

        @Override
        @NonNull
        protected ProjectManager.IResourceLoadStatus createResourceLoadStatus(@Nullable ResourceSet resourceSet) {
            return new MultiplePackageResourceLoadStatus(this, resourceSet);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("{");
            boolean isFirst = true;
            for (ProjectManager.IPackageDescriptor packageDescriptor : this.packageDescriptors) {
                if (!isFirst) {
                    s.append(",");
                }
                s.append(packageDescriptor.getNsURI());
                isFirst = false;
            }
            s.append("} => ");
            s.append(this.genModelURI);
            return s.toString();
        }
    }

    public static class MultiplePackageResourceLoadStatus
    extends AbstractResourceLoadStatus {
        public MultiplePackageResourceLoadStatus(@NonNull MultiplePackageResourceDescriptor resourceDescriptor, @Nullable ResourceSet resourceSet) {
            super(resourceDescriptor, resourceSet);
            this.install();
        }
    }

    public static final class PackageDescriptor
    implements ProjectManager.IPackageDescriptor {
        @NonNull
        protected final ProjectManager.IResourceDescriptor resourceDescriptor;
        @NonNull
        protected final URI namespaceURI;
        @Nullable
        protected final String className;

        public PackageDescriptor(@NonNull ProjectManager.IResourceDescriptor resourceDescriptor, @NonNull URI nsURI, @Nullable String className) {
            this.resourceDescriptor = resourceDescriptor;
            this.namespaceURI = nsURI;
            this.className = className;
        }

        @Override
        public void configure(@Nullable ResourceSet resourceSet, @NonNull ProjectManager.IResourceLoadStrategy resourceLoadStrategy, @Nullable ProjectManager.IConflictHandler conflictHandler) {
            this.resourceDescriptor.configure(resourceSet, resourceLoadStrategy, conflictHandler);
        }

        @Override
        @Nullable
        public String getClassName() {
            return this.className;
        }

        @Nullable
        public EFactory getEFactory() {
            return null;
        }

        @Override
        @NonNull
        public URI getNsURI() {
            return this.namespaceURI;
        }

        @NonNull
        public List<? extends ProjectManager.IPackageDescriptor> getPackageDescriptors() {
            return Collections.singletonList(this);
        }

        @Override
        @NonNull
        public ProjectManager.IResourceDescriptor getResourceDescriptor() {
            return this.resourceDescriptor;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.namespaceURI);
            s.append(" => ");
            s.append(this.className);
            return s.toString();
        }
    }

    public static final class PackageLoadStatus
    implements ProjectManager.IPackageLoadStatus {
        @NonNull
        protected final AbstractResourceLoadStatus resourceLoadStatus;
        @NonNull
        protected final ProjectManager.IPackageDescriptor packageDescriptor;
        @NonNull
        protected final EPackageDescriptor namespaceURIDescriptor;
        @Nullable
        private EPackage firstEPackage;
        @Nullable
        private EPackage ePackage = null;
        @Nullable
        private EPackage eModel = null;

        public PackageLoadStatus(@NonNull AbstractResourceLoadStatus resourceLoadStatus, @NonNull ProjectManager.IPackageDescriptor packageDescriptor) {
            this.resourceLoadStatus = resourceLoadStatus;
            this.packageDescriptor = packageDescriptor;
            this.namespaceURIDescriptor = new EPackageDescriptor(this, resourceLoadStatus.getPackageRegistry());
        }

        @Override
        public void configureEPackageRegistry(@NonNull ResourceSet resourceSet) {
            URI nsURI = this.packageDescriptor.getNsURI();
            ProjectManager.IPackageLoadStatus packageLoadStatus = this.resourceLoadStatus.getPackageLoadStatus(this.packageDescriptor);
            if (packageLoadStatus != null) {
                EPackage modelEPackage = packageLoadStatus.getModel();
                resourceSet.getPackageRegistry().put((Object)nsURI.toString(), (Object)modelEPackage);
                if (PROJECT_MAP_RESOLVE.isActive()) {
                    PROJECT_MAP_RESOLVE.println("EPackage.Registry[" + nsURI + "] => " + EcoreUtil.getURI((EObject)modelEPackage));
                }
            }
        }

        @Override
        public void dispose() {
            this.namespaceURIDescriptor.uninstall(this.resourceLoadStatus.getPackageRegistry());
            this.firstEPackage = null;
            this.ePackage = null;
            this.eModel = null;
        }

        @Override
        @Nullable
        public EPackage getConflictingGeneratedPackage() {
            return this.resourceLoadStatus.handleConflictingGeneratedPackage(this);
        }

        @Override
        @Nullable
        public EPackage getEPackage() {
            if (this.ePackage == null) {
                this.ePackage = this.getEPackageInstance();
            }
            return this.ePackage;
        }

        @Override
        @Nullable
        public EPackage getEPackageInstance() {
            String className = this.packageDescriptor.getClassName();
            if (className != null) {
                try {
                    Class<?> javaClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                    Field field = javaClass.getField("eINSTANCE");
                    return (EPackage)field.get(null);
                }
                catch (ClassNotFoundException e) {
                    throw new WrappedException((Exception)e);
                }
                catch (IllegalAccessException e) {
                    throw new WrappedException((Exception)e);
                }
                catch (NoSuchFieldException e) {
                    throw new WrappedException((Exception)e);
                }
            }
            Object object = EPackage.Registry.INSTANCE.get((Object)this.packageDescriptor.getNsURI().toString());
            if (object instanceof EPackage) {
                return (EPackage)object;
            }
            if (object instanceof EPackage.Descriptor) {
                return ((EPackage.Descriptor)object).getEPackage();
            }
            return null;
        }

        @Override
        @Nullable
        public EPackage getFirstEPackage() {
            if (this.firstEPackage != null) {
                return this.firstEPackage;
            }
            return this.getEPackageInstance();
        }

        @Override
        @Nullable
        public EPackage getModel() {
            return this.eModel;
        }

        @Override
        @NonNull
        public ProjectManager.IPackageDescriptor getPackageDescriptor() {
            return this.packageDescriptor;
        }

        @NonNull
        public ProjectManager.IResourceLoadStrategy getResourceLoadStrategy() {
            return this.resourceLoadStatus.getResourceLoadStrategy();
        }

        @Override
        @NonNull
        public ProjectManager.IResourceLoadStatus getResourceLoadStatus() {
            return this.resourceLoadStatus;
        }

        @Override
        @Nullable
        public EPackage loadEPackage() {
            if (this.ePackage == null) {
                this.ePackage = this.getEPackageInstance();
            }
            if (this.firstEPackage == null) {
                this.firstEPackage = this.ePackage;
            }
            return this.ePackage;
        }

        @Override
        public void setEPackage(@NonNull EPackage ePackage) {
            assert (this.ePackage == null);
            if (this.firstEPackage == null) {
                this.firstEPackage = ePackage;
            }
            this.ePackage = ePackage;
        }

        @Override
        public void setModel(@NonNull EPackage ePackage) {
            assert (this.eModel == null);
            if (this.firstEPackage == null) {
                this.firstEPackage = ePackage;
            }
            this.eModel = ePackage;
        }

        public String toString() {
            return this.packageDescriptor.toString();
        }

        @Override
        public void unloadedResource() {
            this.eModel = null;
        }
    }

    protected static class PluginReader
    extends DefaultHandler {
        @NonNull
        public static final String pluginTag = "plugin";
        @NonNull
        public static final String extensionTag = "extension";
        @NonNull
        public static final String pointTag = "point";
        @NonNull
        public static final String packageTag = "package";
        @NonNull
        public static final String extensionPointAttribute = "org.eclipse.emf.ecore.generated_package";
        @NonNull
        public static final String uriAttribute = "uri";
        @NonNull
        public static final String classAttribute = "class";
        @NonNull
        public static final String genModelAttribute = "genModel";
        protected final JarFile jarFile;
        protected final ProjectManager.IProjectDescriptor projectDescriptor;
        private int pluginCount = 0;
        private int extensionCount = 0;
        private boolean inPoint = false;
        private int packageCount = 0;
        @NonNull
        private Map<String, GenModelReader> genModelReaders = new HashMap<String, GenModelReader>();
        @Nullable
        private Map<String, Map<URI, String>> genModelURI2nsURI2className = null;

        private PluginReader(@Nullable ProjectManager.IProjectDescriptor projectDescriptor) {
            this.jarFile = null;
            this.projectDescriptor = projectDescriptor;
        }

        public PluginReader(@NonNull JarFile jarFile, @NonNull ProjectManager.IProjectDescriptor projectDescriptor) {
            this.jarFile = jarFile;
            this.projectDescriptor = projectDescriptor;
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            Map<String, Map<URI, String>> genModelURI2nsURI2className2 = this.genModelURI2nsURI2className;
            if (genModelURI2nsURI2className2 != null) {
                for (String genModel : genModelURI2nsURI2className2.keySet()) {
                    Map<URI, String> nsURI2className = genModelURI2nsURI2className2.get(genModel);
                    ProjectManager.IResourceDescriptor resourceDescriptor = this.projectDescriptor.createResourceDescriptor(genModel, nsURI2className);
                    GenModelReader genModelReader = new GenModelReader(resourceDescriptor);
                    this.genModelReaders.put(genModel, genModelReader);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.pluginCount == 1) {
                if (pluginTag.equals(qName)) {
                    --this.pluginCount;
                }
                if (this.extensionCount == 1) {
                    if (extensionTag.equals(qName)) {
                        --this.extensionCount;
                    }
                    if (this.packageCount == 1 && packageTag.equals(qName)) {
                        --this.packageCount;
                    }
                }
            }
        }

        public void scanContents(SAXParser saxParser) throws SAXParseException {
            for (String genModel : this.genModelReaders.keySet()) {
                GenModelReader genModelReader = this.genModelReaders.get(genModel);
                URI locationURI = this.projectDescriptor.getLocationURI();
                URI genModelURI = URI.createURI((String)genModel).resolve(locationURI);
                InputStream inputStream = null;
                try {
                    try {
                        if (this.jarFile != null) {
                            ZipEntry entry = this.jarFile.getEntry(genModel);
                            if (entry != null) {
                                inputStream = this.jarFile.getInputStream(entry);
                            }
                        } else {
                            inputStream = new FileInputStream(genModelURI.isFile() ? genModelURI.toFileString() : genModelURI.toString());
                        }
                        if (inputStream == null) continue;
                        saxParser.parse(inputStream, (DefaultHandler)genModelReader);
                    }
                    catch (Exception e) {
                        throw new SAXParseException("Failed to parse " + locationURI, null, e);
                    }
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.pluginCount == 0) {
                if (pluginTag.equals(qName)) {
                    ++this.pluginCount;
                }
            } else if (this.pluginCount == 1) {
                if (this.extensionCount == 0 && extensionTag.equals(qName)) {
                    ++this.extensionCount;
                    this.inPoint = extensionPointAttribute.equals(attributes.getValue(pointTag));
                } else if (this.extensionCount == 1 && this.inPoint && this.packageCount == 0 && packageTag.equals(qName)) {
                    ++this.packageCount;
                    String className = attributes.getValue(classAttribute);
                    URI nsURI = URI.createURI((String)attributes.getValue(uriAttribute));
                    String genModel = attributes.getValue(genModelAttribute);
                    if (genModel != null && className != null) {
                        Map<URI, String> nsURI2className;
                        Map<String, Map<URI, String>> genModelURI2nsURI2className2 = this.genModelURI2nsURI2className;
                        if (genModelURI2nsURI2className2 == null) {
                            this.genModelURI2nsURI2className = genModelURI2nsURI2className2 = new HashMap<String, Map<URI, String>>();
                        }
                        if ((nsURI2className = genModelURI2nsURI2className2.get(genModel)) == null) {
                            nsURI2className = new HashMap<URI, String>();
                            genModelURI2nsURI2className2.put(genModel, nsURI2className);
                        }
                        nsURI2className.put(nsURI, className);
                    }
                }
            }
        }
    }

    public static class ProjectDescriptor
    implements ProjectManager.IProjectDescriptor {
        @NonNull
        protected final StandaloneProjectMap projectMap;
        @NonNull
        protected final String name;
        @NonNull
        protected final URI locationURI;
        @Nullable
        private Map<URI, ProjectManager.IPackageDescriptor> nsURI2packageDescriptor = null;
        @Nullable
        private Map<URI, ProjectManager.IResourceDescriptor> genModelURI2packageDescriptor = null;

        public ProjectDescriptor(@NonNull StandaloneProjectMap projectMap, @NonNull String name, @NonNull URI locationURI) {
            this.projectMap = projectMap;
            this.name = name;
            this.locationURI = locationURI;
        }

        @Override
        public void addPackageDescriptor(@NonNull ProjectManager.IPackageDescriptor packageDescriptor) {
            Map<URI, ProjectManager.IPackageDescriptor> nsURI2packageDescriptor2 = this.nsURI2packageDescriptor;
            if (nsURI2packageDescriptor2 == null) {
                this.nsURI2packageDescriptor = nsURI2packageDescriptor2 = new HashMap<URI, ProjectManager.IPackageDescriptor>();
            }
            nsURI2packageDescriptor2.put(packageDescriptor.getNsURI(), packageDescriptor);
        }

        @Override
        public void addResourceDescriptor(@NonNull ProjectManager.IResourceDescriptor resourceDescriptor) {
            Map<URI, ProjectManager.IResourceDescriptor> genModelURI2packageDescriptor2 = this.genModelURI2packageDescriptor;
            if (genModelURI2packageDescriptor2 == null) {
                this.genModelURI2packageDescriptor = genModelURI2packageDescriptor2 = new HashMap<URI, ProjectManager.IResourceDescriptor>();
            }
            genModelURI2packageDescriptor2.put(resourceDescriptor.getGenModelURI(), resourceDescriptor);
        }

        @Override
        public void configure(@Nullable ResourceSet resourceSet, @NonNull ProjectManager.IResourceLoadStrategy resourceLoadStrategy, @Nullable ProjectManager.IConflictHandler conflictHandler) {
            if (this.genModelURI2packageDescriptor != null) {
                for (ProjectManager.IResourceDescriptor resourceDescriptor : this.genModelURI2packageDescriptor.values()) {
                    try {
                        resourceDescriptor.configure(resourceSet, resourceLoadStrategy, conflictHandler);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
        }

        @Override
        @NonNull
        public ProjectManager.IResourceDescriptor createResourceDescriptor(@NonNull String genModel, @NonNull Map<URI, String> nsURI2className) {
            URI absoluteGenModelURI = URI.createURI((String)genModel).resolve(this.locationURI);
            URI projectGenModelURI = absoluteGenModelURI.deresolve(this.locationURI, true, true, true);
            if (nsURI2className.size() <= 1) {
                return new SinglePackageResourceDescriptor(this, projectGenModelURI, nsURI2className);
            }
            return new MultiplePackageResourceDescriptor(this, projectGenModelURI, nsURI2className);
        }

        @Override
        @NonNull
        public URI getLocationURI() {
            return this.locationURI;
        }

        @Override
        @NonNull
        public URI getLocationURI(@NonNull String projectRelativeFileName) {
            return URI.createURI((String)projectRelativeFileName).resolve(this.locationURI);
        }

        @Override
        @NonNull
        public File getLocationFile(@NonNull String projectRelativeFileName) {
            return new File(this.getLocationURI(projectRelativeFileName).toFileString());
        }

        @Override
        @NonNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public ProjectManager.IPackageDescriptor getPackageDescriptor(@NonNull URI nsURI) {
            return this.nsURI2packageDescriptor != null ? this.nsURI2packageDescriptor.get(nsURI) : null;
        }

        @Override
        @Nullable
        public Collection<ProjectManager.IResourceDescriptor> getResourceDescriptors() {
            return this.genModelURI2packageDescriptor != null ? this.genModelURI2packageDescriptor.values() : null;
        }

        @Override
        @NonNull
        public URI getPlatformPluginURI() {
            return URI.createPlatformPluginURI((String)("/" + this.name + "/"), (boolean)true);
        }

        @Override
        @NonNull
        public URI getPlatformPluginURI(@NonNull String projectRelativeFileName) {
            return URI.createURI((String)projectRelativeFileName).resolve(this.getPlatformPluginURI());
        }

        @Override
        @NonNull
        public URI getPlatformResourceURI() {
            return URI.createPlatformResourceURI((String)("/" + this.name + "/"), (boolean)true);
        }

        @Override
        @NonNull
        public URI getPlatformResourceURI(@NonNull String projectRelativeFileName) {
            return URI.createURI((String)projectRelativeFileName).resolve(this.getPlatformResourceURI());
        }

        @Override
        @NonNull
        public StandaloneProjectMap getProjectManager() {
            return this.projectMap;
        }

        @Override
        public void initializeGenModelLocationMap(@NonNull Map<URI, ProjectManager.IPackageDescriptor> nsURI2package) {
            Collection<ProjectManager.IResourceDescriptor> resourceDescriptors = this.getResourceDescriptors();
            if (resourceDescriptors != null) {
                Map<String, URI> ePackageNsURIToGenModelLocationMap = EMF_2_9.EcorePlugin.getEPackageNsURIToGenModelLocationMap(false);
                for (ProjectManager.IResourceDescriptor resourceDescriptor : resourceDescriptors) {
                    URI genModelURI = resourceDescriptor.getGenModelURI();
                    URI resolvedURI = genModelURI.resolve(this.locationURI);
                    for (ProjectManager.IPackageDescriptor iPackageDescriptor : resourceDescriptor.getPackageDescriptors()) {
                        URI nsURI = iPackageDescriptor.getNsURI();
                        String nsURIstring = nsURI.toString();
                        ePackageNsURIToGenModelLocationMap.put(nsURIstring, resolvedURI);
                        nsURI2package.put(nsURI, iPackageDescriptor);
                        if (!PROJECT_MAP_ADD_GEN_MODEL.isActive()) continue;
                        PROJECT_MAP_ADD_GEN_MODEL.println(nsURI + " => " + resolvedURI);
                    }
                }
            }
        }

        @Override
        public void initializePlatformResourceMap() {
            Map platformResourceMap = EcorePlugin.getPlatformResourceMap();
            platformResourceMap.put(this.name, this.locationURI);
        }

        @Override
        public void initializeURIMap(@NonNull Map<URI, URI> uriMap) {
            URI resourceURI = this.getPlatformResourceURI();
            URI pluginURI = this.getPlatformPluginURI();
            uriMap.put(resourceURI, this.locationURI);
            uriMap.put(pluginURI, this.locationURI);
            if (PROJECT_MAP_ADD_URI_MAP.isActive()) {
                PROJECT_MAP_ADD_URI_MAP.println(resourceURI + " => " + this.locationURI);
                PROJECT_MAP_ADD_URI_MAP.println(pluginURI + " => " + this.locationURI);
            }
        }

        @Override
        public void unload(@NonNull ResourceSet resourceSet) {
            Collection<ProjectManager.IResourceDescriptor> resourceDescriptors = this.getResourceDescriptors();
            if (resourceDescriptors != null) {
                for (ProjectManager.IResourceDescriptor resourceDescriptor : resourceDescriptors) {
                    assert (resourceDescriptor != null);
                    resourceDescriptor.unload(resourceSet);
                }
                Map<URI, ProjectManager.IPackageDescriptor> nsURI2packageDescriptor2 = this.nsURI2packageDescriptor;
                EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                if (nsURI2packageDescriptor2 != null && packageRegistry != null) {
                    for (URI nsURI : nsURI2packageDescriptor2.keySet()) {
                        packageRegistry.remove((Object)nsURI.toString());
                    }
                }
            }
        }

        public String toString() {
            return String.valueOf(this.name) + " => " + this.locationURI.toString();
        }
    }

    public static final class SinglePackageResourceDescriptor
    extends AbstractResourceDescriptor {
        public SinglePackageResourceDescriptor(@NonNull ProjectManager.IProjectDescriptor projectDescriptor, @NonNull URI genModelURI, @NonNull Map<URI, String> nsURI2className) {
            super(projectDescriptor, genModelURI, nsURI2className);
        }

        @Override
        @NonNull
        protected ProjectManager.IResourceLoadStatus createResourceLoadStatus(@Nullable ResourceSet resourceSet) {
            return new SinglePackageResourceLoadStatus(this, resourceSet);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.genModelURI);
            return s.toString();
        }
    }

    public static final class SinglePackageResourceLoadStatus
    extends AbstractResourceLoadStatus {
        public SinglePackageResourceLoadStatus(@NonNull SinglePackageResourceDescriptor packageDescriptor, @Nullable ResourceSet resourceSet) {
            super(packageDescriptor, resourceSet);
            this.install();
        }
    }
}

