/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.AS2MonikerVisitor;
import org.eclipse.ocl.pivot.utilities.AS2XMIidVisitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;

public class AS2XMIid {
    @NonNull
    protected final Map<String, String> moniker2id;

    @NonNull
    public static AS2XMIid load(@NonNull URI uri) {
        HashMap<String, String> moniker2id = new HashMap<String, String>();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        ASResourceFactoryRegistry.INSTANCE.configureResourceSet((ResourceSet)resourceSet);
        try {
            EList eAdapters;
            AS2MonikerVisitor monikerVisitor;
            Resource resource = resourceSet.getResource(uri, true);
            if (resource instanceof XMLResource && (monikerVisitor = ClassUtil.getAdapter(AS2MonikerVisitor.class, (List<Adapter>)(eAdapters = resource.eAdapters()))) != null) {
                XMLResource xmlResource = (XMLResource)resource;
                TreeIterator tit = xmlResource.getAllContents();
                while (tit.hasNext()) {
                    Object moniker;
                    Element element;
                    String oldID;
                    EObject eObject = (EObject)tit.next();
                    if (!(eObject instanceof Element) || (oldID = xmlResource.getID((EObject)(element = (Element)eObject))) == null || !((moniker = element.accept(monikerVisitor)) instanceof String)) continue;
                    moniker2id.put((String)moniker, oldID);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new AS2XMIid(moniker2id);
    }

    public AS2XMIid() {
        this.moniker2id = new HashMap<String, String>();
    }

    protected AS2XMIid(@NonNull Map<String, String> moniker2id) {
        this.moniker2id = moniker2id;
    }

    public void assignIds(@NonNull ASResource asResource, @Nullable Map<?, ?> options) {
        StringBuilder s = null;
        HashMap<String, Element> allIds = new HashMap<String, Element>();
        ASResourceFactory resourceFactory = asResource.getASResourceFactory();
        Object optionInternalUUIDs = options != null ? (Object)options.get("INTERNAL_UUIDS") : null;
        boolean internalUUIDs = optionInternalUUIDs != null && Boolean.valueOf(optionInternalUUIDs.toString()) != false;
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            boolean changedId;
            String idNew;
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof Element)) continue;
            Element element = (Element)eObject;
            AS2XMIidVisitor idVisitor = resourceFactory.createAS2XMIidVisitor(this);
            String idOld = asResource.getID(element);
            String idAuto = idVisitor.getID(element, internalUUIDs);
            String string = idNew = idOld != null ? idOld : idAuto;
            if (idNew == null) continue;
            boolean badId = idNew.length() <= 0 || allIds.containsKey(idNew);
            boolean bl = changedId = idAuto != null && !idNew.equals(idAuto);
            if (badId) {
                idNew = EcoreUtil.generateUUID();
            } else if (changedId) {
                idNew = idAuto;
            }
            if (badId || changedId) {
                if (s == null) {
                    s = new StringBuilder();
                }
                s.append("\n " + element.eClass().getName() + " '" + idAuto + "'");
            }
            allIds.put(idNew, element);
            if (idNew == idOld) continue;
            asResource.setID(element, idNew);
        }
        if (s != null) {
            String message = StringUtil.bind(PivotMessagesInternal.UnstableXMIid_ERROR_, s.toString());
            asResource.getErrors().add((Object)new UnstableXMIidDiagnostics(message));
        }
    }

    public void assignIds(@NonNull ResourceSet asResourceSet, @Nullable Map<?, ?> options) {
        EcoreUtil.resolveAll((ResourceSet)asResourceSet);
        for (Resource resource : asResourceSet.getResources()) {
            if (!(resource instanceof ASResource)) continue;
            this.assignIds((ASResource)resource, options);
        }
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.findEnvironmentFactory(asResourceSet);
        if (environmentFactory != null) {
            environmentFactory.getMetamodelManager().assignLibraryIds(this, options);
        }
    }

    public String getID(@NonNull Element element, boolean internalUUIDs) {
        String moniker = AS2Moniker.toString(element);
        String id = this.moniker2id.get(moniker);
        if (id == null && internalUUIDs) {
            id = EcoreUtil.generateUUID();
        }
        return id;
    }

    public static final class UnstableXMIidDiagnostics
    implements Resource.Diagnostic {
        @NonNull
        protected final String message;

        public UnstableXMIidDiagnostics(@NonNull String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message.replace("\n", "\\n");
        }

        public String getLocation() {
            return null;
        }

        public int getLine() {
            return 0;
        }

        public int getColumn() {
            return 0;
        }

        public String toString() {
            return this.message;
        }
    }
}

