/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.BagType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OrderedSetType;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.SequenceType;
import org.eclipse.ocl.pivot.SetType;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.internal.LibraryImpl;
import org.eclipse.ocl.pivot.internal.library.StandardLibraryContribution;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.Unlimited;

public abstract class AbstractContents
extends PivotUtil {
    @NonNull
    protected BagType createBagType(@NonNull String name, @Nullable String lower, @Nullable String upper, @NonNull TemplateParameter templateParameter) {
        return this.createCollectionType(PivotFactory.eINSTANCE.createBagType(), name, lower, upper, templateParameter);
    }

    @NonNull
    protected <T extends CollectionType> T createCollectionType(T pivotType, @NonNull String name, @Nullable String lower, @Nullable String upper, @NonNull TemplateParameter templateParameter) {
        pivotType.setName(name);
        pivotType.setLower(lower != null ? (Number)StringUtil.createNumberFromString(lower) : (Number)0);
        pivotType.setUpper(upper != null ? StringUtil.createNumberFromString(upper) : Unlimited.INSTANCE);
        this.initTemplateParameter(pivotType, templateParameter);
        pivotType.setElementType(templateParameter);
        return pivotType;
    }

    @NonNull
    protected CollectionType createCollectionType(@NonNull String name, @Nullable String lower, @Nullable String upper, @NonNull TemplateParameter templateParameter) {
        return this.createCollectionType(PivotFactory.eINSTANCE.createCollectionType(), name, lower, upper, templateParameter);
    }

    @NonNull
    protected ExpressionInOCL createExpressionInOCL(@NonNull Type type, @NonNull String exprString) {
        ExpressionInOCL pivotExpression = PivotFactory.eINSTANCE.createExpressionInOCL();
        pivotExpression.setType(type);
        pivotExpression.setBody(exprString);
        return pivotExpression;
    }

    @NonNull
    protected Import createImport(@Nullable String name, @NonNull Namespace namespace) {
        Import asImport = PivotFactory.eINSTANCE.createImport();
        asImport.setName(name);
        asImport.setImportedNamespace(namespace);
        return asImport;
    }

    @NonNull
    protected Iteration createIteration(@NonNull String name, @NonNull Type type, @Nullable String implementationClass, @NonNull LibraryFeature implementation, TemplateParameter ... templateParameters) {
        Iteration pivotIteration = AbstractContents.createIteration(name, type, implementationClass, implementation);
        this.initTemplateParameters(pivotIteration, templateParameters);
        return pivotIteration;
    }

    @NonNull
    protected Library createLibrary(@NonNull String name, @NonNull String nsPrefix, @NonNull String nsURI, @Nullable PackageId packageId) {
        Library pivotLibrary = PivotFactory.eINSTANCE.createLibrary();
        pivotLibrary.setName(name);
        pivotLibrary.setNsPrefix(nsPrefix);
        if (packageId != null) {
            ((LibraryImpl)pivotLibrary).setPackageId(packageId);
        }
        pivotLibrary.setURI(nsURI);
        return pivotLibrary;
    }

    @NonNull
    protected MapType createMapType(MapType pivotType, @NonNull String name, @NonNull TemplateParameter keyParameter, @NonNull TemplateParameter valueParameter) {
        pivotType.setName(name);
        this.initTemplateParameters(pivotType, keyParameter, valueParameter);
        pivotType.setKeyType(keyParameter);
        pivotType.setValueType(valueParameter);
        return pivotType;
    }

    @NonNull
    protected MapType createMapType(@NonNull String name, @NonNull TemplateParameter keyParameter, @NonNull TemplateParameter valueParameter) {
        return this.createMapType(PivotFactory.eINSTANCE.createMapType(), name, keyParameter, valueParameter);
    }

    @NonNull
    protected Operation createOperation(@NonNull String name, @NonNull Type type, @Nullable String implementationClass, @Nullable LibraryFeature implementation, TemplateParameter ... templateParameters) {
        Operation pivotOperation = AbstractContents.createOperation(name, type, implementationClass, implementation);
        this.initTemplateParameters(pivotOperation, templateParameters);
        return pivotOperation;
    }

    @NonNull
    protected OrderedSetType createOrderedSetType(@NonNull String name, @Nullable String lower, @Nullable String upper, @NonNull TemplateParameter templateParameter) {
        return this.createCollectionType(PivotFactory.eINSTANCE.createOrderedSetType(), name, lower, upper, templateParameter);
    }

    @NonNull
    protected SequenceType createSequenceType(@NonNull String name, @Nullable String lower, @Nullable String upper, @NonNull TemplateParameter templateParameter) {
        return this.createCollectionType(PivotFactory.eINSTANCE.createSequenceType(), name, lower, upper, templateParameter);
    }

    @NonNull
    protected SetType createSetType(@NonNull String name, @Nullable String lower, @Nullable String upper, @NonNull TemplateParameter templateParameter) {
        return this.createCollectionType(PivotFactory.eINSTANCE.createSetType(), name, lower, upper, templateParameter);
    }

    @NonNull
    protected AnyType getAnyType(@NonNull Package asPackage, @NonNull String name) {
        return (AnyType)ClassUtil.nonNullState(asPackage.getOwnedClass(name));
    }

    @NonNull
    protected BagType getBagType(@NonNull Package asPackage, @NonNull String name) {
        return (BagType)ClassUtil.nonNullState(asPackage.getOwnedClass(name));
    }

    @NonNull
    protected Class getClass(@NonNull Package asPackage, @NonNull String name) {
        return ClassUtil.nonNullState(asPackage.getOwnedClass(name));
    }

    @NonNull
    protected CollectionType getCollectionType(@NonNull Package asPackage, @NonNull String name) {
        return (CollectionType)ClassUtil.nonNullState(asPackage.getOwnedClass(name));
    }

    @NonNull
    protected InvalidType getInvalidType(@NonNull Package asPackage, @NonNull String name) {
        return (InvalidType)ClassUtil.nonNullState(asPackage.getOwnedClass(name));
    }

    @NonNull
    protected Library getLibrary(@NonNull Model asModel, @NonNull String name) {
        return (Library)ClassUtil.nonNullState(NameUtil.getNameable(asModel.getOwnedPackages(), name));
    }

    @NonNull
    protected Model getModel(@NonNull String modelURI) {
        StandardLibraryContribution standardLibraryContribution = ClassUtil.nonNullState(StandardLibraryContribution.REGISTRY.get(modelURI));
        Resource resource = standardLibraryContribution.getResource();
        return ClassUtil.nonNullState((Model)resource.getContents().get(0));
    }

    @NonNull
    protected OrderedSetType getOrderedSetType(@NonNull Package asPackage, @NonNull String name) {
        return (OrderedSetType)ClassUtil.nonNullState(asPackage.getOwnedClass(name));
    }

    @NonNull
    protected Package getPackage(@NonNull Model asModel, @NonNull String name) {
        return ClassUtil.nonNullState(NameUtil.getNameable(asModel.getOwnedPackages(), name));
    }

    @NonNull
    protected PrimitiveType getPrimitiveType(@NonNull Package asPackage, @NonNull String name) {
        return (PrimitiveType)ClassUtil.nonNullState(asPackage.getOwnedClass(name));
    }

    @NonNull
    protected Property getProperty(@NonNull Class asClass, @NonNull String name) {
        return ClassUtil.nonNullState(NameUtil.getNameable(asClass.getOwnedProperties(), name));
    }

    @NonNull
    protected SequenceType getSequenceType(@NonNull Package asPackage, @NonNull String name) {
        return (SequenceType)ClassUtil.nonNullState(asPackage.getOwnedClass(name));
    }

    @NonNull
    protected SetType getSetType(@NonNull Package asPackage, @NonNull String name) {
        return (SetType)ClassUtil.nonNullState(asPackage.getOwnedClass(name));
    }

    @NonNull
    protected TemplateParameter getTemplateParameter(@NonNull TemplateableElement templateableElement, int index) {
        return ClassUtil.nonNullState(templateableElement.getOwnedSignature().getOwnedParameters().get(index));
    }

    @NonNull
    protected VoidType getVoidType(@NonNull Package asPackage, @NonNull String name) {
        return (VoidType)ClassUtil.nonNullState(asPackage.getOwnedClass(name));
    }

    protected <T extends CollectionType> void initTemplateParameter(@NonNull TemplateableElement pivotType, @NonNull TemplateParameter templateParameter) {
        TemplateSignature templateSignature = PivotFactory.eINSTANCE.createTemplateSignature();
        templateSignature.getOwnedParameters().add(templateParameter);
        pivotType.setOwnedSignature(templateSignature);
    }

    protected <T extends CollectionType> void initTemplateParameters(@NonNull TemplateableElement pivotType, TemplateParameter ... templateParameters) {
        if (templateParameters != null && templateParameters.length > 0) {
            TemplateSignature templateSignature = PivotFactory.eINSTANCE.createTemplateSignature();
            TemplateParameter[] templateParameterArray = templateParameters;
            int n = templateParameters.length;
            int n2 = 0;
            while (n2 < n) {
                TemplateParameter templateParameter = templateParameterArray[n2];
                templateSignature.getOwnedParameters().add(templateParameter);
                ++n2;
            }
            pivotType.setOwnedSignature(templateSignature);
        }
    }

    protected void installComment(Element element, @NonNull String body) {
        Comment pivotComment = PivotFactory.eINSTANCE.createComment();
        pivotComment.setBody(body);
        element.getOwnedComments().add(pivotComment);
    }
}

