/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.values.IntIntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.IntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.RealValueImpl;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.RealValue;

public class LongIntegerValueImpl
extends IntegerValueImpl {
    private static final long serialVersionUID = -5237294941641660020L;
    private final long value;
    private BigInteger bigValue = null;

    public LongIntegerValueImpl(long value) {
        this.value = value;
    }

    @Override
    @NonNull
    public IntegerValue abs() {
        if (this.value >= 0L) {
            return this;
        }
        if (this.value > Long.MIN_VALUE) {
            return ValueUtil.integerValueOf(-this.value);
        }
        BigInteger result = BigInteger.ONE.shiftLeft(63);
        return ValueUtil.integerValueOf(result);
    }

    @Override
    @NonNull
    public IntegerValue addInteger(@NonNull IntegerValue right) {
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            long sum = this.value + thatValue;
            if (this.value >= 0L ? thatValue >= 0L && sum >= 0L : thatValue <= 0L && sum <= 0L) {
                return ValueUtil.integerValueOf(sum);
            }
        }
        BigInteger result = this.bigIntegerValue().add(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    @Override
    @NonNull
    public Double asDouble() {
        Double result = this.value;
        return result;
    }

    @Override
    @NonNull
    public Integer asInteger() {
        Integer result = this.intValue();
        return result;
    }

    @Override
    @NonNull
    public Number asNumber() {
        return this.value;
    }

    @Override
    @NonNull
    public Object asObject() {
        Long result = this.value;
        return result;
    }

    @Override
    @NonNull
    public Object asUnboxedObject(@NonNull IdResolver idResolver) {
        Long result = this.value;
        return result;
    }

    @Override
    @NonNull
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    @Override
    @NonNull
    public BigInteger bigIntegerValue() {
        BigInteger bigValue2 = this.bigValue;
        if (bigValue2 != null) {
            return bigValue2;
        }
        BigInteger bigValue3 = this.bigValue = BigInteger.valueOf(this.value);
        return bigValue3;
    }

    @Override
    public int commutatedCompareToInteger(@NonNull IntegerValue o) {
        try {
            if (o instanceof IntIntegerValueImpl) {
                int thatValue = ((IntIntegerValueImpl)o).intValue();
                return this.value < (long)thatValue ? -1 : (this.value == (long)thatValue ? 0 : 1);
            }
            if (o instanceof LongIntegerValueImpl) {
                long thatValue = ((LongIntegerValueImpl)o).longValue();
                return this.value < thatValue ? -1 : (this.value == thatValue ? 0 : 1);
            }
            return this.bigIntegerValue().compareTo(o.bigIntegerValue());
        }
        catch (InvalidValueException e) {
            return this.hashCode() - o.hashCode();
        }
    }

    @Override
    @NonNull
    public IntegerValue divInteger(@NonNull IntegerValue right) {
        if (right.bigIntegerValue().signum() == 0) {
            throw new InvalidValueException("div zero", new Object[0]);
        }
        BigInteger result = this.bigIntegerValue().divide(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    @Override
    @NonNull
    public RealValue divideInteger(@NonNull IntegerValue right) {
        BigDecimal bigLeft = this.bigDecimalValue();
        BigDecimal bigRight = right.bigDecimalValue();
        return RealValueImpl.divideBigDecimal(bigLeft, bigRight);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof IntIntegerValueImpl) {
                int thatValue = ((IntIntegerValueImpl)obj).intValue();
                return this.value == (long)thatValue;
            }
            if (obj instanceof LongIntegerValueImpl) {
                long thatValue = ((LongIntegerValueImpl)obj).longValue();
                return this.value == thatValue;
            }
            if (obj instanceof IntegerValue) {
                BigInteger bigIntegerValue = ((IntegerValue)obj).bigIntegerValue();
                return this.bigIntegerValue().compareTo(bigIntegerValue) == 0;
            }
            if (obj instanceof RealValue) {
                BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
                return this.bigDecimalValue().compareTo(bigDecimalValue) == 0;
            }
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
        return this == obj;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public int intValue() {
        int intValue = (int)this.value;
        return intValue;
    }

    @Override
    public boolean isUnlimitedNatural() {
        return this.value >= 0L;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    @NonNull
    public IntegerValue maxInteger(@NonNull IntegerValue right) {
        if (right instanceof IntIntegerValueImpl) {
            int thatValue = ((IntIntegerValueImpl)right).intValue();
            return this.value >= (long)thatValue ? this : right;
        }
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            return this.value >= thatValue ? this : right;
        }
        return this.bigIntegerValue().compareTo(right.bigIntegerValue()) >= 0 ? this : right;
    }

    @Override
    @NonNull
    public IntegerValue minInteger(@NonNull IntegerValue right) {
        if (right instanceof IntIntegerValueImpl) {
            int thatValue = ((IntIntegerValueImpl)right).intValue();
            return this.value <= (long)thatValue ? this : right;
        }
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            return this.value <= thatValue ? this : right;
        }
        return this.bigIntegerValue().compareTo(right.bigIntegerValue()) <= 0 ? this : right;
    }

    @Override
    @NonNull
    public IntegerValue modInteger(@NonNull IntegerValue right) {
        if (right.bigIntegerValue().signum() == 0) {
            throw new InvalidValueException("mod zero", new Object[0]);
        }
        BigInteger result = this.bigIntegerValue().remainder(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    @Override
    @NonNull
    public IntegerValue multiplyInteger(@NonNull IntegerValue right) {
        BigInteger result = this.bigIntegerValue().multiply(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    @Override
    @NonNull
    public IntegerValue negate() {
        if (this.value > Long.MIN_VALUE) {
            return ValueUtil.integerValueOf(-this.value);
        }
        BigInteger result = BigInteger.ONE.shiftLeft(63);
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public int signum() {
        return Long.signum(this.value);
    }

    @Override
    @NonNull
    public IntegerValue subtractInteger(@NonNull IntegerValue right) {
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            long diff = this.value - thatValue;
            if (this.value >= 0L ? thatValue <= 0L && diff >= 0L : thatValue >= 0L && diff <= 0L) {
                return ValueUtil.integerValueOf(diff);
            }
        }
        BigInteger result = this.bigIntegerValue().subtract(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    public String toString() {
        return Long.toString(this.value);
    }
}

