/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.BagValue;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.MapValue;
import org.eclipse.ocl.pivot.values.NumberValue;
import org.eclipse.ocl.pivot.values.OCLValue;
import org.eclipse.ocl.pivot.values.ObjectValue;
import org.eclipse.ocl.pivot.values.OrderedCollectionValue;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.RealValue;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.ocl.pivot.values.TupleValue;
import org.eclipse.ocl.pivot.values.UniqueCollectionValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.ocl.pivot.values.Value;
import org.eclipse.ocl.pivot.values.ValuesPackage;

public abstract class NumberValueImpl
extends Number
implements NumberValue {
    private static final long serialVersionUID = 1L;

    protected EClass eStaticClass() {
        return ValuesPackage.Literals.VALUE;
    }

    protected NumberValueImpl() {
    }

    @Override
    @NonNull
    public BagValue asBagValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Bag", this.getTypeName());
    }

    @Override
    @NonNull
    public CollectionValue asCollectionValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Collection", this.getTypeName());
    }

    @Override
    @NonNull
    public Double asDouble() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Double", this.getTypeName());
    }

    @Override
    public Object asEcoreObject(@NonNull IdResolver idResolver, @Nullable Class<?> instanceClass) {
        if (instanceClass == Double.class || instanceClass == Double.TYPE) {
            return this.doubleValue();
        }
        if (instanceClass == Float.class || instanceClass == Float.TYPE) {
            return Float.valueOf(this.floatValue());
        }
        if (instanceClass == Short.class || instanceClass == Short.TYPE) {
            return this.shortValue();
        }
        if (instanceClass == Integer.class || instanceClass == Integer.TYPE) {
            return this.intValue();
        }
        if (instanceClass == Long.class || instanceClass == Long.TYPE) {
            return this.longValue();
        }
        if (instanceClass == BigDecimal.class) {
            return BigDecimal.valueOf(this.doubleValue());
        }
        if (instanceClass == BigInteger.class) {
            return BigInteger.valueOf(this.longValue());
        }
        return null;
    }

    @Override
    public Element asElement() {
        return null;
    }

    @Override
    @NonNull
    public Integer asInteger() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Integer", this.getTypeName());
    }

    @Override
    @NonNull
    public IntegerValue asIntegerValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Integer", this.getTypeName());
    }

    @Override
    @NonNull
    public MapValue asMapValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Map", this.getTypeName());
    }

    @Override
    @NonNull
    public EObject asNavigableObject() {
        Object object = this.asObject();
        if (object instanceof EObject) {
            return (EObject)object;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Object", this.getTypeName());
    }

    @Override
    @NonNull
    public ObjectValue asObjectValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Object", this.getTypeName());
    }

    @Override
    @NonNull
    public OrderedCollectionValue asOrderedCollectionValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "OrderedCollection", this.getTypeName());
    }

    @Override
    @NonNull
    public OrderedSetValue asOrderedSetValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "OrderedSet", this.getTypeName());
    }

    @Override
    @NonNull
    public RealValue asRealValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Real", this.getTypeName());
    }

    @Override
    @NonNull
    public SequenceValue asSequenceValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Sequence", this.getTypeName());
    }

    @Override
    @NonNull
    public SetValue asSetValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Set", this.getTypeName());
    }

    @Override
    @NonNull
    public TupleValue asTupleValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Tuple", this.getTypeName());
    }

    @Override
    @NonNull
    public UniqueCollectionValue asUniqueCollectionValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Unique Collection", this.getTypeName());
    }

    @Override
    @NonNull
    public UnlimitedNaturalValue asUnlimitedNaturalValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "UnlimitedNatural", this.getTypeName());
    }

    @NonNull
    public String getTypeName() {
        return this.getTypeId().getDisplayName();
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public boolean isUndefined() {
        return false;
    }

    @Override
    public boolean oclEquals(@NonNull OCLValue thatValue) {
        return this.equals(thatValue);
    }

    @Override
    public int oclHashCode() {
        return this.hashCode();
    }

    @Override
    public void toString(@NonNull StringBuilder s, int sizeLimit) {
        s.append(this.toString());
    }

    static class EmptyIterator
    implements Iterator<Value> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Value next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

