/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.values.NumberValueImpl;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.ComparableValue;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.NumberValue;
import org.eclipse.ocl.pivot.values.RealValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.ocl.pivot.values.ValuesPackage;

public class RealValueImpl
extends NumberValueImpl
implements RealValue {
    private static final long serialVersionUID = -6016171050097266652L;
    private static final int MINIMUM_SCALE = 32;
    @NonNull
    private final BigDecimal value;
    private Object integerValue = null;

    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.REAL_VALUE;
    }

    @NonNull
    protected static RealValue divideBigDecimal(@NonNull BigDecimal left, @NonNull BigDecimal right) {
        try {
            if (right.signum() == 0) {
                throw new InvalidValueException("divide by zero", new Object[0]);
            }
            int scale = Math.max(left.scale() - right.scale(), 32);
            BigDecimal result = left.divide(right, scale, RoundingMode.HALF_EVEN);
            return ValueUtil.realValueOf(result);
        }
        catch (ArithmeticException e) {
            throw new InvalidValueException(e, "divideBigDecimal");
        }
    }

    public static void initStatics() {
    }

    public RealValueImpl(double value) {
        this(BigDecimal.valueOf(value));
    }

    public RealValueImpl(@NonNull BigDecimal value) {
        this.value = value;
        assert (value != null);
    }

    @Override
    @NonNull
    public RealValue abs() {
        BigDecimal result = this.value.abs();
        return ValueUtil.realValueOf(result);
    }

    @Override
    @NonNull
    public RealValue addInteger(@NonNull IntegerValue rightValue) {
        try {
            BigDecimal result = this.value.add(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    @NonNull
    public RealValue addReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.value.add(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    @NonNull
    public Double asDouble() {
        Double result = this.value.doubleValue();
        return result;
    }

    @Override
    public Object asEcoreObject(@NonNull IdResolver idResolver, @Nullable Class<?> instanceClass) {
        if (instanceClass == BigDecimal.class) {
            return this.value;
        }
        Object ecoreValue = super.asEcoreObject(idResolver, instanceClass);
        return ecoreValue != null ? ecoreValue : Double.valueOf(this.doubleValue());
    }

    @Override
    @NonNull
    public Number asNumber() {
        return this.value;
    }

    @Override
    @NonNull
    public Object asObject() {
        return this.value;
    }

    @Override
    @NonNull
    public RealValue asRealValue() {
        return this;
    }

    @Override
    @NonNull
    public Object asUnboxedObject(@NonNull IdResolver idResolver) {
        return this.value;
    }

    @Override
    @NonNull
    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    @Override
    @NonNull
    public BigInteger bigIntegerValue() {
        Object intValue = this.getIntegerValue();
        if (intValue instanceof Exception) {
            throw new InvalidValueException((Exception)intValue, "bigIntegerValue");
        }
        return ((IntegerValue)intValue).bigIntegerValue();
    }

    @Override
    @NonNull
    public RealValue commutatedAdd(@NonNull RealValue left) {
        return left.addReal(this);
    }

    @Override
    public int commutatedCompareTo(@NonNull ComparableValue<?> left) {
        if (left instanceof NumberValue) {
            return ((NumberValue)left).commutatedCompareToReal(this);
        }
        return ValueUtil.throwUnsupportedCompareTo(left, this);
    }

    @Override
    public int commutatedCompareToInteger(@NonNull IntegerValue left) {
        return this.value.compareTo(left.bigDecimalValue());
    }

    @Override
    public int commutatedCompareToReal(@NonNull RealValue left) {
        return this.value.compareTo(left.bigDecimalValue());
    }

    @Override
    @NonNull
    public RealValue commutatedDivide(@NonNull RealValue left) {
        return left.divideReal(this);
    }

    @Override
    @NonNull
    public RealValue commutatedMultiply(@NonNull RealValue left) {
        return left.multiplyReal(this);
    }

    @Override
    @NonNull
    public RealValue commutatedSubtract(@NonNull RealValue left) {
        return left.subtractReal(this);
    }

    @Override
    public int compareTo(@Nullable NumberValue right) {
        if (right != null) {
            return -right.commutatedCompareToReal(this);
        }
        return ValueUtil.throwUnsupportedCompareTo(this, right);
    }

    @Override
    @NonNull
    public RealValue divideInteger(@NonNull IntegerValue right) {
        return RealValueImpl.divideBigDecimal(this.value, right.bigDecimalValue());
    }

    @Override
    @NonNull
    public RealValue divideReal(@NonNull RealValue right) {
        return RealValueImpl.divideBigDecimal(this.value, right.bigDecimalValue());
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof RealValue) {
                BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
                return this.value.compareTo(bigDecimalValue) == 0;
            }
            if (obj instanceof IntegerValue) {
                BigDecimal bigDecimalValue = ((IntegerValue)obj).bigDecimalValue();
                return this.value.compareTo(bigDecimalValue) == 0;
            }
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
        return this == obj;
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    @NonNull
    public IntegerValue floor() {
        BigInteger result = this.value.setScale(0, RoundingMode.FLOOR).toBigInteger();
        return ValueUtil.integerValueOf(result);
    }

    protected Object getIntegerValue() {
        if (this.integerValue == null) {
            try {
                BigInteger intValue = this.value.toBigIntegerExact();
                this.integerValue = ValueUtil.integerValueOf(intValue);
            }
            catch (ArithmeticException e) {
                this.integerValue = e;
            }
        }
        return this.integerValue;
    }

    @NonNull
    public Type getType(@NonNull StandardLibrary standardLibrary) {
        return standardLibrary.getRealType();
    }

    @Override
    @NonNull
    public TypeId getTypeId() {
        return TypeId.REAL;
    }

    public int hashCode() {
        Object intValue = this.getIntegerValue();
        if (intValue instanceof IntegerValue) {
            return intValue.hashCode();
        }
        return this.value.hashCode();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    @Nullable
    public IntegerValue isIntegerValue() {
        return null;
    }

    @Override
    @Nullable
    public UnlimitedNaturalValue isUnlimitedNaturalValue() {
        return null;
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    @NonNull
    public RealValue max(@NonNull RealValue rightValue) {
        return rightValue.maxReal(this);
    }

    @Override
    @NonNull
    public RealValue maxInteger(@NonNull IntegerValue rightValue) {
        try {
            BigDecimal result = this.value.max(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    @NonNull
    public RealValue maxReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.value.max(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    @NonNull
    public RealValue min(@NonNull RealValue rightValue) {
        return rightValue.minReal(this);
    }

    @Override
    @NonNull
    public RealValue minInteger(@NonNull IntegerValue rightValue) {
        try {
            BigDecimal result = this.value.min(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    @NonNull
    public RealValue minReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.value.min(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    @NonNull
    public RealValue multiplyInteger(@NonNull IntegerValue rightValue) {
        try {
            BigDecimal result = this.value.multiply(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    @NonNull
    public RealValue multiplyReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.value.multiply(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    @NonNull
    public RealValue negate() {
        BigDecimal result = this.value.negate();
        return ValueUtil.realValueOf(result);
    }

    @Override
    @NonNull
    public IntegerValue round() {
        BigDecimal rounded = this.value.signum() >= 0 ? this.value.setScale(0, RoundingMode.HALF_UP) : this.value.negate().setScale(0, RoundingMode.HALF_DOWN).negate();
        BigInteger result = rounded.toBigInteger();
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public int signum() {
        return this.value.signum();
    }

    @Override
    @NonNull
    public RealValue subtractInteger(@NonNull IntegerValue rightValue) {
        try {
            BigDecimal result = this.value.subtract(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    @NonNull
    public RealValue subtractReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.value.subtract(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    public String toString() {
        return this.value.toString();
    }
}

