/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.internal.values.OrderedSetImpl;
import org.eclipse.ocl.pivot.internal.values.OrderedSetValueImpl;
import org.eclipse.ocl.pivot.internal.values.SparseSequenceValueImpl;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.OrderedSet;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.SequenceValue;

public class SparseOrderedSetValueImpl
extends OrderedSetValueImpl {
    @NonNull
    public static OrderedSet<Object> createOrderedSetOfEach(@NonNull Object[] boxedValues) {
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>();
        Object[] objectArray = boxedValues;
        int n = boxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object boxedValue = objectArray[n2];
            result.add(boxedValue);
            ++n2;
        }
        return result;
    }

    public SparseOrderedSetValueImpl(@NonNull CollectionTypeId typeId, @NonNull Collection<? extends Object> boxedValues) {
        super(typeId, boxedValues);
    }

    @Override
    @NonNull
    public OrderedSetValue append(@Nullable Object object) {
        if (object instanceof InvalidValueException) {
            throw new InvalidValueException(PivotMessages.InvalidSource, "append");
        }
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>(this.elements);
        result.remove(object);
        result.add(object);
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    @Nullable
    public Object first() {
        if (this.elements.size() <= 0) {
            throw new InvalidValueException(PivotMessages.EmptyCollection, "OrderedSet", "first");
        }
        return this.elements.iterator().next();
    }

    @Override
    @NonNull
    public OrderedSetValue flatten() {
        OrderedSetImpl<Object> flattened = new OrderedSetImpl<Object>();
        if (this.flatten(flattened)) {
            return new SparseOrderedSetValueImpl(this.getTypeId(), flattened);
        }
        return this;
    }

    @Override
    @NonNull
    public OrderedSetValue including(@Nullable Object value) {
        if (value instanceof InvalidValueException) {
            throw new InvalidValueException(PivotMessages.InvalidSource, "including");
        }
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>(this.elements);
        result.add(value);
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    @Nullable
    public Object last() {
        if (this.elements.size() <= 0) {
            throw new InvalidValueException(PivotMessages.EmptyCollection, "OrderedSet", "last");
        }
        Object result = null;
        for (Object next : this.elements) {
            result = next;
        }
        return result;
    }

    @Override
    @NonNull
    public OrderedSetValue prepend(@Nullable Object object) {
        if (object instanceof InvalidValueException) {
            throw new InvalidValueException(PivotMessages.InvalidSource, "prepend");
        }
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>();
        result.add(object);
        result.addAll(this.elements);
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    public SequenceValue toSequenceValue() {
        return new SparseSequenceValueImpl(this.getSequenceTypeId(), SparseSequenceValueImpl.createSequenceOfEach(this.elements));
    }

    @Override
    public void toString(@NonNull StringBuilder s, int lengthLimit) {
        s.append("OrderedSet");
        super.toString(s, lengthLimit);
    }

    public static class Accumulator
    extends SparseOrderedSetValueImpl
    implements OrderedSetValue.Accumulator {
        public Accumulator(@NonNull CollectionTypeId typeId) {
            super(typeId, new OrderedSetImpl());
        }

        @Override
        public boolean add(@Nullable Object value) {
            return this.elements.add(value);
        }
    }
}

