/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.library.AbstractEvaluatorIterationManager;
import org.eclipse.ocl.pivot.values.CollectionValue;

public class EvaluatorSingleIterationManager
extends AbstractEvaluatorIterationManager {
    @NonNull
    protected final TypedElement referredIterator;
    @NonNull
    protected final AbstractEvaluatorIterationManager.ValueIterator iterator;

    public EvaluatorSingleIterationManager(@NonNull Evaluator invokingEvaluator, @NonNull OCLExpression body, @NonNull CollectionValue collectionValue, @Nullable TypedElement accumulator, @Nullable Object accumulatorValue, @NonNull TypedElement referredIterator) {
        super(invokingEvaluator.createNestedEvaluator(), body, collectionValue, accumulator, accumulatorValue);
        this.referredIterator = referredIterator;
        this.iterator = new AbstractEvaluatorIterationManager.ValueIterator(this.evaluator, collectionValue, referredIterator);
    }

    protected EvaluatorSingleIterationManager(@NonNull EvaluatorSingleIterationManager iterationManager, @NonNull CollectionValue value) {
        super(iterationManager, value);
        this.referredIterator = iterationManager.referredIterator;
        this.iterator = new AbstractEvaluatorIterationManager.ValueIterator(this.evaluator, this.collectionValue, this.referredIterator);
    }

    @Override
    public boolean advanceIterators() {
        this.iterator.next();
        return this.hasCurrent();
    }

    @Override
    @NonNull
    public IterationManager createNestedIterationManager(@NonNull CollectionValue value) {
        return new Nested(this, value);
    }

    @Override
    @Nullable
    public Object get() {
        return this.iterator.get();
    }

    public int getDepth() {
        return 0;
    }

    @NonNull
    public EvaluatorSingleIterationManager getRootIterationManager() {
        return this;
    }

    @Override
    public boolean hasCurrent() {
        return this.iterator.hasCurrent();
    }

    class Nested
    extends EvaluatorSingleIterationManager {
        @NonNull
        protected final EvaluatorSingleIterationManager rootIterationManager;
        protected final int depth;

        protected Nested(@NonNull EvaluatorSingleIterationManager iterationManager, CollectionValue value) {
            super(iterationManager, value);
            this.rootIterationManager = iterationManager.getRootIterationManager();
            this.depth = iterationManager.getDepth() + 1;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        @NonNull
        public EvaluatorSingleIterationManager getRootIterationManager() {
            return this.rootIterationManager;
        }

        @Override
        @NonNull
        public CollectionValue getSourceCollection() {
            return this.rootIterationManager.getSourceCollection();
        }
    }
}

