/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.collection;

import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractBinaryOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.TupleValue;

public class CollectionProductOperation
extends AbstractBinaryOperation {
    @NonNull
    public static final CollectionProductOperation INSTANCE = new CollectionProductOperation();

    @Override
    @NonNull
    public CollectionValue evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceVal, @Nullable Object argVal) {
        CollectionTypeId collTypeId;
        TupleTypeId tupleTypeId;
        CollectionValue argumentValue;
        CollectionValue sourceValue = CollectionProductOperation.asCollectionValue(sourceVal);
        Set<TupleValue> product = sourceValue.product(argumentValue = CollectionProductOperation.asCollectionValue(argVal), tupleTypeId = (TupleTypeId)(collTypeId = (CollectionTypeId)returnTypeId).getElementTypeId());
        if (product != null) {
            return evaluator.getIdResolver().createSetOfAll(collTypeId, product);
        }
        throw new InvalidValueException(PivotMessages.MissingResult, "product");
    }
}

