/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.collection;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.library.AbstractUntypedBinaryOperation;
import org.eclipse.ocl.pivot.values.CollectionValue;

public class CollectionSelectByTypeOperation
extends AbstractUntypedBinaryOperation {
    @NonNull
    public static final CollectionSelectByTypeOperation INSTANCE = new CollectionSelectByTypeOperation();

    @Override
    @NonNull
    public CollectionValue evaluate(@NonNull Evaluator evaluator, @Nullable Object sourceVal, @Nullable Object argVal) {
        CollectionValue collectionValue = CollectionSelectByTypeOperation.asCollectionValue(sourceVal);
        Type requiredElementType = CollectionSelectByTypeOperation.asType(argVal);
        StandardLibrary standardLibrary = evaluator.getStandardLibrary();
        boolean changedContents = false;
        ArrayList<Object> newElements = new ArrayList<Object>();
        for (Object object : collectionValue.iterable()) {
            Type elementType = evaluator.getIdResolver().getDynamicTypeOf(object);
            if (elementType.isEqualTo(standardLibrary, requiredElementType)) {
                newElements.add(object);
                continue;
            }
            changedContents = true;
        }
        if (changedContents) {
            return evaluator.getIdResolver().createCollectionOfAll(collectionValue.isOrdered(), collectionValue.isUnique(), collectionValue.getTypeId(), newElements);
        }
        return collectionValue;
    }
}

