/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.collection;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractUnaryOperation;
import org.eclipse.ocl.pivot.library.numeric.NumericPlusOperation;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.RealValue;

public class CollectionSumOperation
extends AbstractUnaryOperation {
    @NonNull
    public static final CollectionSumOperation INSTANCE = new CollectionSumOperation();

    @Override
    @NonNull
    public Object evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceVal) {
        CollectionValue collectionValue = CollectionSumOperation.asCollectionValue(sourceVal);
        StandardLibrary standardLibrary = evaluator.getStandardLibrary();
        Type returnType = evaluator.getIdResolver().getType(returnTypeId, null);
        RealValue result = returnType.conformsTo(standardLibrary, standardLibrary.getIntegerType()) ? ValueUtil.integerValueOf(0) : ValueUtil.realValueOf(0.0);
        for (Object object : collectionValue.iterable()) {
            result = NumericPlusOperation.INSTANCE.evaluate(result, object);
        }
        return result;
    }
}

