/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractIteration;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class AnyIteration
extends AbstractIteration {
    @NonNull
    public static final AnyIteration INSTANCE = new AnyIteration();

    @Override
    @NonNull
    public Object createAccumulatorValue(@NonNull Evaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return INSTANCE;
    }

    @Override
    @Nullable
    protected Object resolveTerminalValue(@NonNull IterationManager iterationManager) {
        throw new InvalidValueException("No matching content for 'any'", new Object[0]);
    }

    @Override
    @Nullable
    protected Object updateAccumulator(@NonNull IterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        if (bodyVal == null) {
            throw new InvalidValueException(PivotMessages.UndefinedBody, "any");
        }
        if (bodyVal == Boolean.FALSE) {
            return CARRY_ON;
        }
        if (bodyVal != Boolean.TRUE) {
            throw new InvalidValueException(PivotMessages.NonBooleanBody, "any");
        }
        Object value = iterationManager.get();
        return value;
    }
}

