/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractIteration;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class ClosureIteration
extends AbstractIteration {
    @NonNull
    public static final ClosureIteration INSTANCE = new ClosureIteration();

    @Override
    @NonNull
    public CollectionValue.Accumulator createAccumulatorValue(@NonNull Evaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return ClosureIteration.createCollectionAccumulatorValue((CollectionTypeId)accumulatorTypeId);
    }

    @Override
    @Nullable
    protected Object updateAccumulator(@NonNull IterationManager iterationManager) {
        CollectionValue collectionValue;
        Object value = iterationManager.get();
        CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        if (!accumulatorValue.add(value)) {
            return CARRY_ON;
        }
        Object bodyVal = iterationManager.evaluateBody();
        if (bodyVal instanceof InvalidValueException) {
            throw (InvalidValueException)bodyVal;
        }
        if (bodyVal == null) {
            return iterationManager.getAccumulatorValue();
        }
        if (bodyVal instanceof CollectionValue) {
            collectionValue = (CollectionValue)bodyVal;
        } else {
            Evaluator evaluator = iterationManager.getEvaluator();
            Class elementType = evaluator.getStaticTypeOf(bodyVal);
            CollectionTypeId sequenceId = TypeId.SEQUENCE.getSpecializedId(elementType.getTypeId());
            collectionValue = evaluator.getIdResolver().createSequenceOfEach(sequenceId, bodyVal);
        }
        this.evaluateIteration(iterationManager.createNestedIterationManager(collectionValue));
        return CARRY_ON;
    }
}

