/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractIteration;
import org.eclipse.ocl.pivot.values.CollectionValue;

public class CollectIteration
extends AbstractIteration {
    @NonNull
    public static final CollectIteration INSTANCE = new CollectIteration();

    @Override
    @NonNull
    public CollectionValue.Accumulator createAccumulatorValue(@NonNull Evaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return CollectIteration.createCollectionAccumulatorValue((CollectionTypeId)accumulatorTypeId);
    }

    @Override
    @Nullable
    protected Object updateAccumulator(@NonNull IterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        if (bodyVal == null) {
            accumulatorValue.add(bodyVal);
        } else if (bodyVal instanceof CollectionValue) {
            CollectionValue bodyColl = (CollectionValue)bodyVal;
            for (Object object : bodyColl.flatten().iterable()) {
                if (object == null) continue;
                accumulatorValue.add(object);
            }
        } else {
            accumulatorValue.add(bodyVal);
        }
        return CARRY_ON;
    }
}

