/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.iterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.values.ValueImpl;
import org.eclipse.ocl.pivot.library.AbstractIteration;
import org.eclipse.ocl.pivot.library.LibraryBinaryOperation;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.Value;

public class SortedByIteration
extends AbstractIteration {
    @NonNull
    public static final SortedByIteration INSTANCE = new SortedByIteration();

    @Override
    @NonNull
    public SortingValue createAccumulatorValue(@NonNull Evaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        StandardLibrary standardLibrary = evaluator.getStandardLibrary();
        CompleteInheritance comparableType = standardLibrary.getOclComparableType().getInheritance(standardLibrary);
        CompleteInheritance selfType = standardLibrary.getOclSelfType().getInheritance(standardLibrary);
        Operation staticOperation = comparableType.lookupLocalOperation(standardLibrary, "compareTo", selfType);
        if (staticOperation != null) {
            Class bodyType = evaluator.getIdResolver().getClass(bodyTypeId, null);
            LibraryFeature implementation = bodyType.lookupImplementation(standardLibrary, staticOperation);
            return new SortingValue(evaluator, (CollectionTypeId)accumulatorTypeId, (LibraryBinaryOperation)implementation);
        }
        throw new InvalidValueException(PivotMessages.UndefinedOperation, String.valueOf(String.valueOf(comparableType)) + "::" + "compareTo");
    }

    @Override
    @NonNull
    protected Object resolveTerminalValue(@NonNull IterationManager iterationManager) {
        SortingValue accumulatorValue = (SortingValue)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        return accumulatorValue.createSortedValue();
    }

    @Override
    @Nullable
    protected Object updateAccumulator(@NonNull IterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        if (bodyVal == null) {
            throw new InvalidValueException(PivotMessages.UndefinedBody, "sortedBy");
        }
        Object iterValue = iterationManager.get();
        SortingValue accumulatorValue = (SortingValue)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        accumulatorValue.put(iterValue, bodyVal);
        return CARRY_ON;
    }

    protected static class SortingValue
    extends ValueImpl
    implements Comparator<Object> {
        @NonNull
        protected final CollectionTypeId typeId;
        @NonNull
        private final Evaluator evaluator;
        private final boolean isUnique;
        @NonNull
        private final LibraryBinaryOperation implementation;
        @NonNull
        private final Map<Object, Object> content = new HashMap<Object, Object>();
        private Map<Object, Integer> repeatCounts = null;

        public SortingValue(@NonNull Evaluator evaluator, @NonNull CollectionTypeId returnTypeId, @NonNull LibraryBinaryOperation implementation) {
            this.typeId = returnTypeId;
            this.evaluator = evaluator;
            this.implementation = implementation;
            CollectionTypeId generalizedId = this.typeId.getGeneralizedId();
            this.isUnique = generalizedId == TypeId.SET || generalizedId == TypeId.ORDERED_SET;
        }

        @Override
        @NonNull
        public Object asObject() {
            return this.content;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Object v2;
            if (o1 == o2) {
                return 0;
            }
            Object v1 = this.content.get(o1);
            if (v1 == (v2 = this.content.get(o2))) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            try {
                IntegerValue comparison = ValueUtil.asIntegerValue(this.implementation.evaluate(this.evaluator, TypeId.INTEGER, v1, v2));
                return comparison.signum();
            }
            catch (InvalidValueException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidValueException(e);
            }
        }

        @NonNull
        public Value createSortedValue() {
            ArrayList<Object> result = new ArrayList<Object>(this.content.keySet());
            Collections.sort(result, this);
            if (this.isUnique || this.repeatCounts == null) {
                return this.evaluator.getIdResolver().createCollectionOfAll(true, this.isUnique, this.typeId, result);
            }
            ArrayList nonUniqueResult = new ArrayList();
            for (Object e : result) {
                nonUniqueResult.add(e);
                Integer repeatCount = this.repeatCounts.get(e);
                if (repeatCount == null) continue;
                int i = repeatCount;
                while (i > 0) {
                    nonUniqueResult.add(e);
                    --i;
                }
            }
            return this.evaluator.getIdResolver().createCollectionOfAll(true, false, this.typeId, nonUniqueResult);
        }

        @Override
        @NonNull
        public TypeId getTypeId() {
            return this.typeId;
        }

        public void put(@Nullable Object iterVal, @Nullable Object comparable) {
            if (this.content.put(iterVal, comparable) != null && !this.isUnique) {
                Integer repeatCount;
                if (this.repeatCounts == null) {
                    this.repeatCounts = new HashMap<Object, Integer>();
                }
                repeatCount = (repeatCount = this.repeatCounts.get(iterVal)) == null ? Integer.valueOf(1) : Integer.valueOf(repeatCount + 1);
                this.repeatCounts.put(iterVal, repeatCount);
            }
        }

        public String toString() {
            return this.content.toString();
        }
    }
}

