/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.string;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.TupleValue;

public class CGStringLogDiagnosticOperation
extends AbstractOperation {
    @NonNull
    public static final CGStringLogDiagnosticOperation INSTANCE = new CGStringLogDiagnosticOperation();

    @Override
    @Nullable
    public Object dispatch(@NonNull Evaluator evaluator, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " should only be invoked directly.");
    }

    @NonNull
    public Boolean evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object constraintName, @Nullable Object object, @Nullable Object feature, @Nullable Object diagnostics, @Nullable Object context, @Nullable Object message, @Nullable Object severity, @Nullable Object status, @Nullable Object code) {
        TupleTypeId tupleTypeId;
        TuplePartId statusPartId;
        if (status == Boolean.TRUE) {
            return ValueUtil.TRUE_VALUE;
        }
        TupleValue tupleValue = null;
        if (status instanceof TupleValue && (statusPartId = (tupleTypeId = (tupleValue = (TupleValue)status).getTypeId()).getPartId("status")) != null && (status = tupleValue.getValue(statusPartId)) == Boolean.TRUE) {
            return ValueUtil.TRUE_VALUE;
        }
        if (diagnostics != null) {
            Object[] objectArray;
            int emfSeverity;
            String emfMessage = (String)message;
            int emfCode = ValueUtil.asIntegerValue(code).intValue();
            if (tupleValue != null) {
                IntegerValue value;
                int signum;
                TupleTypeId tupleTypeId2 = tupleValue.getTypeId();
                TuplePartId severityPartId = tupleTypeId2.getPartId("severity");
                emfSeverity = severityPartId != null ? ((signum = (value = ValueUtil.integerValueOf(tupleValue.getValue(severityPartId))).signum()) < 0 ? 4 : (signum == 0 ? 1 : 2)) : (status == null ? 4 : 2);
                TuplePartId messagePartId = tupleTypeId2.getPartId("message");
                if (messagePartId != null) {
                    emfMessage = String.valueOf(tupleValue.getValue(messagePartId));
                }
            } else {
                emfSeverity = ValueUtil.asIntegerValue(severity).intValue();
            }
            if (emfMessage == null) {
                String objectLabel;
                if (object instanceof EObject) {
                    Map castContext = (Map)context;
                    objectLabel = EObjectValidator.getObjectLabel((EObject)((EObject)object), (Map)castContext);
                } else {
                    objectLabel = "<<unknown>>";
                }
                emfMessage = StringUtil.bind(PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, constraintName, objectLabel);
            }
            if (feature != null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = object;
                objectArray = objectArray2;
                objectArray2[1] = feature;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = object;
            }
            Object[] emfData = objectArray;
            ((DiagnosticChain)diagnostics).add((Diagnostic)new BasicDiagnostic(emfSeverity, "org.eclipse.ocl.pivot", emfCode, emfMessage, emfData));
        }
        return ValueUtil.FALSE_VALUE;
    }

    @Deprecated
    @NonNull
    public Boolean evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object constraintName, @Nullable Object object, @Nullable Object diagnostics, @Nullable Object context, @Nullable Object severity, @Nullable Object status, @Nullable Object code) {
        return this.evaluate(evaluator, returnTypeId, constraintName, object, null, diagnostics, context, null, severity, status, code);
    }

    @Deprecated
    @NonNull
    public Boolean evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, String strValidateorderedsetki, DiagnosticChain diagnostics, Object cAUGHT_getSeverity, Object cAUGHT_implies) {
        return ValueUtil.TRUE_VALUE;
    }
}

