/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.string;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.library.AbstractSimpleBinaryOperation;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;

public class StringIndexOfOperation
extends AbstractSimpleBinaryOperation {
    @NonNull
    public static final StringIndexOfOperation INSTANCE = new StringIndexOfOperation();

    @Override
    @NonNull
    public IntegerValue evaluate(@Nullable Object left, @Nullable Object right) {
        String leftString = StringIndexOfOperation.asString(left);
        String rightString = StringIndexOfOperation.asString(right);
        if (rightString.length() <= 0) {
            return ValueUtil.integerValueOf(1);
        }
        int index = leftString.indexOf(rightString);
        if (index >= 0) {
            return ValueUtil.integerValueOf(index + 1);
        }
        return ValueUtil.integerValueOf(0);
    }
}

