/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.string;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.library.AbstractSimpleBinaryOperation;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;

public class StringLastIndexOfOperation
extends AbstractSimpleBinaryOperation {
    @NonNull
    public static final StringLastIndexOfOperation INSTANCE = new StringLastIndexOfOperation();

    @Override
    @NonNull
    public IntegerValue evaluate(@Nullable Object left, @Nullable Object right) {
        String leftString = StringLastIndexOfOperation.asString(left);
        String rightString = StringLastIndexOfOperation.asString(right);
        if (rightString.length() <= 0) {
            return ValueUtil.integerValueOf(leftString.length() + 1);
        }
        int index = leftString.lastIndexOf(rightString);
        if (index >= 0) {
            return ValueUtil.integerValueOf(index + 1);
        }
        return ValueUtil.integerValueOf(0);
    }
}

