/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.types;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.InheritanceFragment;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.elements.AbstractExecutorNamedElement;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.library.UnsupportedOperation;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.IndexableIterable;

public abstract class AbstractInheritance
extends AbstractExecutorNamedElement
implements CompleteInheritance {
    public static final int ORDERED = 1;
    public static final int UNIQUE = 2;
    public static final int OCL_ANY = 4;
    public static final int OCL_VOID = 8;
    public static final int OCL_INVALID = 16;
    protected final int flags;

    public static void initStatics() {
    }

    public AbstractInheritance(@NonNull String name, int flags) {
        super(name);
        this.flags = flags;
    }

    @Override
    @NonNull
    public CompleteInheritance getCommonInheritance(@NonNull CompleteInheritance thatInheritance) {
        if (this == thatInheritance) {
            return this;
        }
        if ((this.flags & 0x1C) != 0) {
            if ((this.flags & 4) != 0) {
                return this;
            }
            if ((this.flags & 0x10) != 0) {
                return thatInheritance;
            }
            return thatInheritance.isUndefined() ? this : thatInheritance;
        }
        int thatDepth = thatInheritance.getDepth();
        if (thatDepth == 1 && thatInheritance.isUndefined()) {
            return this;
        }
        int thisDepth = this.getDepth();
        int staticDepth = Math.min(thisDepth, thatDepth);
        while (staticDepth > 0) {
            int iMax = this.getIndex(staticDepth + 1);
            int jMax = thatInheritance.getIndex(staticDepth + 1);
            CompleteInheritance commonInheritance = null;
            int commonInheritances = 0;
            int i = this.getIndex(staticDepth);
            while (i < iMax) {
                CompleteInheritance thisBaseInheritance = this.getFragment(i).getBaseInheritance();
                int j = thatInheritance.getIndex(staticDepth);
                while (j < jMax) {
                    CompleteInheritance thatBaseInheritance = thatInheritance.getFragment(j).getBaseInheritance();
                    if (thisBaseInheritance == thatBaseInheritance) {
                        ++commonInheritances;
                        commonInheritance = thisBaseInheritance;
                        break;
                    }
                    ++j;
                }
                if (commonInheritances > 1) break;
                ++i;
            }
            if (commonInheritances == 1) {
                assert (commonInheritance != null);
                return commonInheritance;
            }
            --staticDepth;
        }
        return this.getFragment(0).getBaseInheritance();
    }

    @Override
    @Nullable
    public InheritanceFragment getFragment(@NonNull CompleteInheritance thatInheritance) {
        int staticDepth = thatInheritance.getDepth();
        if (staticDepth <= this.getDepth()) {
            int iMax = this.getIndex(staticDepth + 1);
            int i = this.getIndex(staticDepth);
            while (i < iMax) {
                InheritanceFragment fragment = this.getFragment(i);
                if (fragment.getBaseInheritance() == thatInheritance) {
                    return fragment;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    @NonNull
    public Class getType() {
        return this.getPivotClass();
    }

    public final boolean isInvalid() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public final boolean isOclAny() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isSubInheritanceOf(@NonNull CompleteInheritance thatInheritance) {
        int theseFlags = this.flags & 0x18;
        int thoseFlags = ((AbstractInheritance)thatInheritance).flags & 0x18;
        if (theseFlags == 0 && thoseFlags == 0) {
            return this.getFragment(thatInheritance) != null;
        }
        return theseFlags >= thoseFlags;
    }

    @Override
    public boolean isSuperInheritanceOf(@NonNull CompleteInheritance thatInheritance) {
        int theseFlags = this.flags & 0x18;
        int thoseFlags = ((AbstractInheritance)thatInheritance).flags & 0x18;
        if (theseFlags == 0 && thoseFlags == 0) {
            return thatInheritance.getFragment(this) != null;
        }
        return theseFlags <= thoseFlags;
    }

    @Override
    public final boolean isUndefined() {
        return (this.flags & 0x18) != 0;
    }

    @Override
    @NonNull
    public Operation lookupActualOperation(@NonNull StandardLibrary standardLibrary, @NonNull Operation apparentOperation) {
        this.getDepth();
        CompleteInheritance apparentInheritance = apparentOperation.getInheritance(standardLibrary);
        int apparentDepth = ClassUtil.nonNullModel(apparentInheritance).getDepth();
        if (apparentDepth + 1 < this.getIndexes()) {
            int iMax = this.getIndex(apparentDepth + 1);
            int i = this.getIndex(apparentDepth);
            while (i < iMax) {
                InheritanceFragment fragment = this.getFragment(i);
                if (fragment.getBaseInheritance() == apparentInheritance) {
                    Operation actualOperation = fragment.getActualOperation(apparentOperation);
                    return actualOperation;
                }
                ++i;
            }
        }
        return apparentOperation;
    }

    @Override
    @NonNull
    public LibraryFeature lookupImplementation(@NonNull StandardLibrary standardLibrary, @NonNull Operation apparentOperation) {
        LibraryFeature implementation;
        this.getDepth();
        CompleteInheritance apparentInheritance = apparentOperation.getInheritance(standardLibrary);
        int apparentDepth = ClassUtil.nonNullModel(apparentInheritance).getDepth();
        if (apparentDepth + 1 < this.getIndexes()) {
            int iMax = this.getIndex(apparentDepth + 1);
            int i = this.getIndex(apparentDepth);
            while (i < iMax) {
                InheritanceFragment fragment = this.getFragment(i);
                if (fragment.getBaseInheritance() == apparentInheritance) {
                    return fragment.getImplementation(apparentOperation);
                }
                ++i;
            }
        }
        if ((implementation = PivotUtilInternal.getImplementation(apparentOperation)) == null) {
            implementation = UnsupportedOperation.INSTANCE;
        }
        return implementation;
    }

    @Override
    @Nullable
    public Operation lookupLocalOperation(@NonNull StandardLibrary standardLibrary, @NonNull String operationName, CompleteInheritance ... argumentTypes) {
        for (Operation localOperation : this.getPivotClass().getOwnedOperations()) {
            ParametersId firstParametersId;
            int iMax;
            if (!localOperation.getName().equals(operationName) || (iMax = (firstParametersId = localOperation.getParametersId()).size()) != argumentTypes.length) continue;
            int i = 0;
            while (i < iMax) {
                Class secondParameterType;
                TypeId firstParameterId = (TypeId)firstParametersId.get(i);
                if (firstParameterId != (secondParameterType = argumentTypes[i].getPivotClass()).getTypeId()) break;
                ++i;
            }
            if (i < iMax) continue;
            return localOperation;
        }
        return null;
    }

    public static class FragmentIterable
    implements IndexableIterable<InheritanceFragment> {
        private final InheritanceFragment[] array;
        private final int firstIndex;
        private final int lastIndex;

        public FragmentIterable(@NonNull InheritanceFragment[] array) {
            this.array = array;
            this.firstIndex = 0;
            this.lastIndex = array.length;
        }

        public FragmentIterable(@NonNull InheritanceFragment[] array, int firstIndex, int lastIndex) {
            this.array = array;
            this.firstIndex = firstIndex;
            this.lastIndex = lastIndex;
        }

        @Override
        @NonNull
        public InheritanceFragment get(int index) {
            return ClassUtil.nonNullState(this.array[this.firstIndex + index]);
        }

        @Override
        @NonNull
        public java.util.Iterator<InheritanceFragment> iterator() {
            return new Iterator();
        }

        @Override
        public int size() {
            return this.lastIndex - this.firstIndex;
        }

        public String toString() {
            StringBuilder s = null;
            int i = this.firstIndex;
            while (i < this.lastIndex) {
                if (s == null) {
                    s = new StringBuilder();
                    s.append("[");
                } else {
                    s.append(", ");
                }
                s.append(this.array[i]);
                ++i;
            }
            if (s == null) {
                return "";
            }
            s.append("]");
            return s.toString();
        }

        protected class Iterator
        implements java.util.Iterator<InheritanceFragment> {
            private int index;

            protected Iterator() {
                this.index = FragmentIterable.this.firstIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index < FragmentIterable.this.lastIndex;
            }

            @Override
            public InheritanceFragment next() {
                return FragmentIterable.this.array[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

