/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.labels.LabelSubstitutionLabelProvider;
import org.eclipse.ocl.pivot.labels.AbstractLabelGenerator;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.labels.LabelGeneratorRegistry;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Labelable;
import org.eclipse.ocl.pivot.utilities.NameUtil;

public class LabelUtil {
    @NonNull
    public static ILabelGenerator.Registry QUALIFIED_NAME_REGISTRY = new LabelGeneratorRegistry(ILabelGenerator.Registry.INSTANCE);
    @NonNull
    public static ILabelGenerator.Registry SIMPLE_NAME_REGISTRY = new LabelGeneratorRegistry(ILabelGenerator.Registry.INSTANCE);
    @NonNull
    public static EValidator.SubstitutionLabelProvider SUBSTITUTION_LABEL_PROVIDER = new LabelSubstitutionLabelProvider();

    static {
        SIMPLE_NAME_REGISTRY.install(ENamedElement.class, new AbstractLabelGenerator<ENamedElement>(ENamedElement.class){

            @Override
            public void buildLabelFor(@NonNull ILabelGenerator.Builder labelBuilder, @NonNull ENamedElement labelledObject) {
                String name = labelledObject.getName();
                if (name != null) {
                    labelBuilder.appendString(name);
                } else {
                    labelBuilder.appendString("<null-named-");
                    labelBuilder.appendString(labelledObject.getClass().getSimpleName());
                    labelBuilder.appendString(">");
                }
            }
        });
        QUALIFIED_NAME_REGISTRY.install(ENamedElement.class, new AbstractLabelGenerator<ENamedElement>(ENamedElement.class){

            @Override
            public void buildLabelFor(@NonNull ILabelGenerator.Builder labelBuilder, @NonNull ENamedElement labelledObject) {
                String name = labelledObject.getName();
                if (name != null) {
                    labelBuilder.appendString(name);
                } else {
                    labelBuilder.appendString("<null-named-");
                    labelBuilder.appendString(labelledObject.getClass().getSimpleName());
                    labelBuilder.appendString(">");
                }
            }
        });
    }

    public static <E extends EObject> E copy(E newObject) {
        return (E)EcoreUtil.copy(newObject);
    }

    @NonNull
    public static Map<Object, Object> createDefaultContext(EValidator eValidator) {
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        context.put(EValidator.SubstitutionLabelProvider.class, SUBSTITUTION_LABEL_PROVIDER);
        context.put(EValidator.class, eValidator);
        return context;
    }

    @Nullable
    public static String diagnoseUnresolvedProxies(@NonNull URI contextURI, @NonNull Map<EObject, Collection<EStructuralFeature.Setting>> map) {
        if (map.isEmpty()) {
            return null;
        }
        HashMap<String, Map.Entry<EObject, Collection<EStructuralFeature.Setting>>> unresolvedURIs = new HashMap<String, Map.Entry<EObject, Collection<EStructuralFeature.Setting>>>(map.size());
        for (Map.Entry<EObject, Collection<EStructuralFeature.Setting>> entry : map.entrySet()) {
            String uriString;
            EObject key = entry.getKey();
            URI uri = EcoreUtil.getURI((EObject)key);
            if (uri == null || unresolvedURIs.containsKey(uriString = uri.toString())) continue;
            unresolvedURIs.put(uriString, entry);
        }
        StringBuilder s = new StringBuilder();
        s.append("Unresolved URIs in '" + String.valueOf(contextURI) + "' :");
        for (Map.Entry unresolvedURI : unresolvedURIs.entrySet()) {
            s.append("\n    '" + (String)unresolvedURI.getKey() + "'");
        }
        return s.toString();
    }

    @Nullable
    public static <T extends Adapter> T getAdapter(@Nullable Notifier notifier, Class<T> adapterClass) {
        if (notifier == null) {
            return null;
        }
        return LabelUtil.getAdapter((List<Adapter>)notifier.eAdapters(), adapterClass);
    }

    public static <T extends Adapter> T getAdapter(List<Adapter> eAdapters, Class<T> adapterClass) {
        return (T)EcoreUtil.getAdapter(eAdapters, adapterClass);
    }

    public static EClassifier getEType(EObject sourceObject, @NonNull EStructuralFeature feature) {
        EGenericType targetGenericType = feature.getEGenericType();
        ETypeParameter targetTypeParameter = targetGenericType.getETypeParameter();
        if (targetTypeParameter != null && sourceObject != null) {
            EClass sourceGenericType = feature.getEContainingClass();
            EObject typeParameterContainer = targetTypeParameter.eContainer();
            EClass sourceClass = sourceObject.eClass();
            EList allSourceGenericSuperTypes = sourceClass.getEAllGenericSuperTypes();
            for (EGenericType sourceGenericSuperType : allSourceGenericSuperTypes) {
                if (sourceGenericSuperType.getERawType() != typeParameterContainer) continue;
                EList sourceTypeArguments = sourceGenericSuperType.getETypeArguments();
                int i = sourceGenericType.getETypeParameters().indexOf((Object)targetTypeParameter);
                if (i < 0 || i >= sourceTypeArguments.size()) continue;
                EGenericType sourceTypeArgument = (EGenericType)sourceTypeArguments.get(i);
                return sourceTypeArgument.getERawType();
            }
        }
        return targetGenericType.getERawType();
    }

    @Nullable
    public static EOperation getEcoreInvariant(@NonNull EClass eClass, @NonNull String name) {
        for (EOperation eOperation : eClass.getEOperations()) {
            if (!ClassUtil.safeEquals(name, eOperation.getName()) || !EcoreUtil.isInvariant((EOperation)eOperation)) continue;
            return eOperation;
        }
        return null;
    }

    public static <T> int getFeatureID(@NonNull Notification notification, @Nullable T expectedNotifier, @NonNull Class<T> featureClass) {
        if (expectedNotifier == null) {
            return -1;
        }
        Object notifier = notification.getNotifier();
        if (notifier != expectedNotifier) {
            return -1;
        }
        T castNotifier = ClassUtil.asClassOrNull(notifier, featureClass);
        if (castNotifier == null) {
            throw new IllegalArgumentException("EcoreUtils.getFeatureID: " + featureClass.getName() + " for a " + notifier.getClass().getName());
        }
        return notification.getFeatureID(featureClass);
    }

    public static String getLabel(@Nullable Object object) {
        String text;
        if (object instanceof Labelable && (text = ((Labelable)object).getText()) != null) {
            return text;
        }
        return NameUtil.qualifiedNameFor(object);
    }

    public static String getLabel(EClassifier eClassifier, Object object, Map<Object, Object> context) {
        if (eClassifier instanceof EDataType) {
            return EObjectValidator.getValueLabel((EDataType)((EDataType)eClassifier), (Object)object, context);
        }
        if (object instanceof EObject) {
            if (context != null) {
                return EObjectValidator.getObjectLabel((EObject)((EObject)object), context);
            }
            return LabelUtil.getLabel(object);
        }
        return String.valueOf(object);
    }
}

