/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.helper.HelperUtil;
import org.eclipse.ocl.pivot.internal.helper.OCLHelperImpl;
import org.eclipse.ocl.pivot.internal.helper.QueryImpl;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.OCLHelper;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.Query;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class OCL {
    @NonNull
    public static final ProjectManager NO_PROJECTS = BasicProjectManager.NO_PROJECTS;
    @NonNull
    public static final ProjectManager CLASS_PATH = BasicProjectManager.CLASS_PATH;
    protected EnvironmentFactoryInternal environmentFactory;
    @Nullable
    private ModelManager modelManager;
    private boolean traceEvaluation = HelperUtil.shouldTrace("org.eclipse.ocl.pivot/debug/evaluation");

    @NonNull
    public static OCL newInstance() {
        return OCLInternal.newInstance();
    }

    @NonNull
    public static OCL newInstance(@NonNull ProjectManager projectManager) {
        return OCLInternal.newInstance(projectManager, null);
    }

    @NonNull
    public static OCL newInstance(@NonNull ProjectManager projectManager, @NonNull ResourceSet resourceSet) {
        OCLInternal ocl = OCLInternal.newInstance(projectManager, resourceSet);
        return ocl;
    }

    @NonNull
    public static OCL newInstance(@NonNull ResourceSet resourceSet) {
        OCLInternal ocl = OCLInternal.newInstance(BasicProjectManager.createDefaultProjectManager(), resourceSet);
        return ocl;
    }

    @NonNull
    public static OCL newInstance(@NonNull EPackage.Registry ePackageRegistry) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setPackageRegistry(ePackageRegistry);
        return OCL.newInstance(NO_PROJECTS, (ResourceSet)resourceSet);
    }

    @Deprecated
    @NonNull
    public static OCL newInstance(@NonNull EnvironmentFactory environmentFactory) {
        return environmentFactory.createOCL();
    }

    protected OCL(@NonNull EnvironmentFactoryInternal environmentFactory) {
        this.environmentFactory = environmentFactory;
        environmentFactory.attach(this);
        environmentFactory.setEvaluationTracingEnabled(this.traceEvaluation);
    }

    public void as2cs(@NonNull ASResource asResource, @NonNull CSResource csResource) {
        csResource.updateFrom(asResource, this.getEnvironmentFactory());
    }

    @NonNull
    public Resource as2ecore(@NonNull Resource asResource, @NonNull URI uri) throws IOException {
        assert (this.environmentFactory != null);
        XMLResource ecoreResource = AS2Ecore.createResource(this.environmentFactory, asResource, uri, null);
        return ecoreResource;
    }

    public boolean check(Object context, @NonNull Constraint constraint) {
        ExpressionInOCL query;
        LanguageExpression specification = constraint.getOwnedSpecification();
        if (specification == null) {
            return false;
        }
        try {
            query = this.getMetamodelManager().parseSpecification(specification);
        }
        catch (ParserException e) {
            return false;
        }
        return this.check(context, query);
    }

    public boolean check(Object context, @NonNull ExpressionInOCL specification) {
        StandardLibrary stdlib = this.getStandardLibrary();
        if (specification.getOwnedBody().getType() != stdlib.getBooleanType()) {
            throw new IllegalArgumentException("constraint is not boolean");
        }
        try {
            Object result = this.evaluate(context, specification);
            return result == ValueUtil.TRUE_VALUE;
        }
        catch (InvalidValueException e) {
            return false;
        }
    }

    @NonNull
    public EvaluationVisitor createEvaluationVisitor(@Nullable Object context, @NonNull ExpressionInOCL expression) {
        return this.environmentFactory.createEvaluationVisitor(context, expression, this.modelManager);
    }

    @NonNull
    public ExpressionInOCL createInvariant(@NonNull EObject contextElement, @NonNull String oclExpression) throws ParserException {
        return this.createOCLHelper(contextElement).createInvariant(oclExpression);
    }

    public ExpressionInOCL createPostcondition(@NonNull EOperation contextOperation, @NonNull String oclExpression) throws ParserException {
        return this.createOCLHelper((EObject)contextOperation).createPostcondition(oclExpression);
    }

    @NonNull
    public OCLHelper createOCLHelper(@Nullable EObject contextElement) {
        return new OCLHelperImpl(this, contextElement);
    }

    @NonNull
    public ExpressionInOCL createQuery(@Nullable EObject contextElement, @NonNull String oclExpression) throws ParserException {
        return this.createOCLHelper(contextElement).createQuery(oclExpression);
    }

    @NonNull
    public Query createQuery(@NonNull ExpressionInOCL query) {
        return new QueryImpl(this, query);
    }

    public Query createQuery(@NonNull Constraint constraint) throws ParserException {
        LanguageExpression specification = ClassUtil.nonNullState(constraint.getOwnedSpecification());
        ExpressionInOCL query = this.getMetamodelManager().parseSpecification(specification);
        return new QueryImpl(this, query);
    }

    @NonNull
    public ASResource cs2as(@NonNull CSResource csResource) {
        ASResource asResource = csResource.getASResource();
        return asResource;
    }

    public synchronized void dispose() {
        EnvironmentFactoryInternal environmentFactory2 = this.environmentFactory;
        if (environmentFactory2 != null) {
            this.environmentFactory = null;
            environmentFactory2.detach(this);
        }
    }

    @NonNull
    public ASResource ecore2as(@NonNull Resource ecoreResource) throws ParserException {
        assert (this.environmentFactory != null);
        Ecore2AS ecore2as = Ecore2AS.getAdapter(ecoreResource, this.environmentFactory);
        Model pivotModel = ecore2as.getASModel();
        ASResource asResource = (ASResource)pivotModel.eResource();
        return ClassUtil.nonNullModel(asResource);
    }

    @Nullable
    public Object evaluate(@Nullable Object context, @NonNull ExpressionInOCL expression) {
        EvaluationVisitor evaluationVisitor = this.createEvaluationVisitor(context, expression);
        return expression.accept(evaluationVisitor);
    }

    public synchronized void finalize() {
        EnvironmentFactoryInternal environmentFactory2 = this.environmentFactory;
        if (environmentFactory2 != null) {
            this.environmentFactory = null;
            environmentFactory2.detach(this);
        }
    }

    @NonNull
    public CSResource getCSResource(@NonNull URI uri) throws IOException {
        Resource resource = this.getResourceSet().createResource(uri);
        if (!(resource instanceof CSResource)) {
            String doSetup = this.environmentFactory.getDoSetupName(uri);
            if (doSetup != null) {
                throw new IllegalStateException("Use of Xtext parsing of '" + uri + "' requires use of " + doSetup);
            }
            throw new IllegalStateException("No Xtext parsing support registered for '" + uri + "'");
        }
        CSResource csResource = (CSResource)resource;
        this.getEnvironmentFactory().adapt((Notifier)csResource);
        csResource.load(null);
        return csResource;
    }

    @NonNull
    public CSResource getCSResource(@NonNull URI uri, @NonNull InputStream inputStream) throws IOException {
        Resource resource = new ResourceSetImpl().createResource(uri);
        if (!(resource instanceof CSResource)) {
            String doSetup = this.environmentFactory.getDoSetupName(uri);
            if (doSetup != null) {
                throw new IllegalStateException("Use of Xtext parsing of '" + uri + "' requires use of " + doSetup);
            }
            throw new IllegalStateException("No Xtext parsing support registered for '" + uri + "'");
        }
        CSResource csResource = (CSResource)resource;
        this.getEnvironmentFactory().adapt((Notifier)csResource);
        csResource.load(inputStream, null);
        return csResource;
    }

    @NonNull
    public CSResource getCSResource(@NonNull URI uri, @NonNull String testDocument) throws IOException {
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(testDocument, "UTF-8");
        return this.getCSResource(uri, (InputStream)inputStream);
    }

    @NonNull
    public CompleteEnvironment getCompleteEnvironment() {
        return this.environmentFactory.getCompleteEnvironment();
    }

    @NonNull
    public Class getContextType(@Nullable Object contextObject) {
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        IdResolver idResolver = this.getIdResolver();
        Class staticTypeOf = idResolver.getStaticTypeOf(contextObject);
        return metamodelManager.getPrimaryClass(staticTypeOf);
    }

    @NonNull
    public EnvironmentFactory getEnvironmentFactory() {
        assert (this.environmentFactory != null);
        return this.environmentFactory;
    }

    @NonNull
    public IdResolver getIdResolver() {
        return this.environmentFactory.getIdResolver();
    }

    @NonNull
    public MetamodelManager getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    @Nullable
    public ModelManager getModelManager() {
        return this.modelManager;
    }

    @NonNull
    public EPackage.Registry getPackageRegistry() {
        return ClassUtil.nonNullEMF(this.getResourceSet().getPackageRegistry());
    }

    @NonNull
    public ProjectManager getProjectManager() {
        return this.environmentFactory.getProjectManager();
    }

    @NonNull
    public ResourceSet getResourceSet() {
        return this.environmentFactory.getResourceSet();
    }

    @Nullable
    public ExpressionInOCL getSpecification(@NonNull Constraint constraint) throws ParserException {
        ExpressionInOCL query;
        LanguageExpression specification = constraint.getOwnedSpecification();
        if (specification == null) {
            return null;
        }
        if (specification instanceof ExpressionInOCL && ((query = (ExpressionInOCL)specification).getOwnedBody() != null || query.getBody() == null)) {
            return query;
        }
        return this.getMetamodelManager().parseSpecification(specification);
    }

    @NonNull
    public StandardLibrary getStandardLibrary() {
        return this.getEnvironmentFactory().getStandardLibrary();
    }

    @Deprecated
    public boolean isEvaluationTracingEnabled() {
        return this.traceEvaluation;
    }

    @Deprecated
    @Nullable
    public CSResource load(@NonNull URI uri) {
        ResourceSet externalResourceSet = this.getResourceSet();
        return (CSResource)externalResourceSet.getResource(uri, true);
    }

    @Nullable
    public ASResource parse(@NonNull URI uri) {
        CSResource csResource = this.load(uri);
        return csResource != null ? this.cs2as(csResource) : null;
    }

    @NonNull
    public ExpressionInOCL parseSpecification(@NonNull LanguageExpression specification) throws ParserException {
        return this.getMetamodelManager().parseSpecification(specification);
    }

    @Deprecated
    @NonNull
    public ExpressionInOCL parseSpecification(@Nullable Object unusedObject, @NonNull LanguageExpression specification) throws ParserException {
        return this.getMetamodelManager().parseSpecification(specification);
    }

    @Deprecated
    public void setEvaluationTracingEnabled(boolean b) {
        this.traceEvaluation = b;
        this.environmentFactory.setEvaluationTracingEnabled(this.traceEvaluation);
    }

    public void setModelManager(@Nullable ModelManager modelManager) {
        this.modelManager = modelManager;
    }

    @Deprecated
    public void validate(@NonNull OCLExpression expression) throws SemanticException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".validate");
    }

    @Deprecated
    public void validate(@NonNull Constraint constraint) throws SemanticException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".validate");
    }
}

