/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.AssociativityKind;
import org.eclipse.ocl.pivot.BagType;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.OrderedSetType;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.SelfType;
import org.eclipse.ocl.pivot.SequenceType;
import org.eclipse.ocl.pivot.SetType;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.internal.PackageImpl;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class PivotUtil {
    public static void checkExpression(@NonNull ExpressionInOCL expressionInOCL) {
        OCLExpression bodyExpression;
        Variable contextVariable = expressionInOCL.getOwnedContext();
        if (contextVariable == null && (bodyExpression = expressionInOCL.getOwnedBody()) instanceof StringLiteralExp) {
            throw new InvalidValueException(((StringLiteralExp)bodyExpression).getStringSymbol(), new Object[0]);
        }
    }

    public static void checkResourceErrors(@NonNull String message, @NonNull Resource resource) throws ParserException {
        EList errors = resource.getErrors();
        if (errors.size() > 0) {
            throw new SemanticException(PivotUtil.formatResourceDiagnostics((List)ClassUtil.nonNullEMF(resource.getErrors()), message, "\n"));
        }
    }

    public static boolean conformsTo(@Nullable EClassifier targetType, @NonNull EClassifier contentType) {
        if (targetType == contentType) {
            return true;
        }
        if (!(targetType instanceof EClass)) {
            return false;
        }
        if (!(contentType instanceof EClass)) {
            return false;
        }
        return ((EClass)targetType).isSuperTypeOf((EClass)contentType);
    }

    public static boolean conformsTo(@Nullable EStructuralFeature eStructuralFeature, @NonNull EClassifier contentType) {
        if (eStructuralFeature == null) {
            return true;
        }
        EClassifier targetType = eStructuralFeature.getEType();
        if (targetType == contentType) {
            return true;
        }
        if (!(targetType instanceof EClass)) {
            return false;
        }
        if (!(contentType instanceof EClass)) {
            return false;
        }
        return PivotUtil.conformsTo(targetType, contentType);
    }

    @NonNull
    public static AnyType createAnyType(@NonNull String name) {
        AnyType pivotType = PivotFactory.eINSTANCE.createAnyType();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    public static BagType createBagType(@NonNull BagType unspecializedType, @NonNull Type elementType) {
        return PivotUtil.createCollectionType(PivotFactory.eINSTANCE.createBagType(), unspecializedType, elementType);
    }

    @NonNull
    public static Class createClass(EClass eClass) {
        Class pivotType = PivotFactory.eINSTANCE.createClass();
        pivotType.setName(eClass.getName());
        ((PivotObjectImpl)((Object)pivotType)).setESObject((EObject)eClass);
        return pivotType;
    }

    @NonNull
    public static Class createClass(@NonNull String name) {
        Class pivotType = PivotFactory.eINSTANCE.createClass();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    public static CollectionType createCollectionType(@NonNull CollectionType unspecializedType, @NonNull Type elementType) {
        return PivotUtil.createCollectionType(PivotFactory.eINSTANCE.createCollectionType(), unspecializedType, elementType);
    }

    @NonNull
    protected static <T extends CollectionType> T createCollectionType(T specializedType, @NonNull T unspecializedType, @NonNull Type instanceType) {
        specializedType.setName(unspecializedType.getName());
        specializedType.setLower(unspecializedType.getLower());
        specializedType.setUpper(unspecializedType.getUpper());
        specializedType.setUnspecializedElement(unspecializedType);
        specializedType.setElementType(instanceType);
        return specializedType;
    }

    @NonNull
    public static DataType createDataType(EDataType eDataType) {
        DataType pivotType = PivotFactory.eINSTANCE.createDataType();
        pivotType.setName(eDataType.getName());
        ((PivotObjectImpl)((Object)pivotType)).setESObject((EObject)eDataType);
        return pivotType;
    }

    @NonNull
    public static DataType createDataType(@NonNull String name) {
        DataType pivotType = PivotFactory.eINSTANCE.createDataType();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    public static Enumeration createEnumeration(EEnum eEnum) {
        Enumeration pivotType = PivotFactory.eINSTANCE.createEnumeration();
        pivotType.setName(eEnum.getName());
        ((PivotObjectImpl)((Object)pivotType)).setESObject((EObject)eEnum);
        return pivotType;
    }

    @NonNull
    public static Enumeration createEnumeration(@NonNull String name) {
        Enumeration pivotType = PivotFactory.eINSTANCE.createEnumeration();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    public static EnumerationLiteral createEnumerationLiteral(EEnumLiteral eEnumLiteral) {
        EnumerationLiteral pivotEnumerationLiteral = PivotFactory.eINSTANCE.createEnumerationLiteral();
        pivotEnumerationLiteral.setName(eEnumLiteral.getName());
        ((PivotObjectImpl)((Object)pivotEnumerationLiteral)).setESObject((EObject)eEnumLiteral);
        return pivotEnumerationLiteral;
    }

    @NonNull
    public static EnumerationLiteral createEnumerationLiteral(@NonNull String name) {
        EnumerationLiteral pivotEnumerationLiteral = PivotFactory.eINSTANCE.createEnumerationLiteral();
        pivotEnumerationLiteral.setName(name);
        return pivotEnumerationLiteral;
    }

    @NonNull
    public static ExpressionInOCL createExpressionInOCL(@Nullable Variable asContextVariable, @NonNull OCLExpression asExpression, Variable ... asParameterVariables) {
        ExpressionInOCL asExpressionInOCL = PivotFactory.eINSTANCE.createExpressionInOCL();
        asExpressionInOCL.setOwnedContext(asContextVariable);
        if (asParameterVariables != null) {
            Variable[] variableArray = asParameterVariables;
            int n = asParameterVariables.length;
            int n2 = 0;
            while (n2 < n) {
                Variable asParameterVariable = variableArray[n2];
                asExpressionInOCL.getOwnedParameters().add(asParameterVariable);
                ++n2;
            }
        }
        asExpressionInOCL.setOwnedBody(asExpression);
        asExpressionInOCL.setType(asExpression.getType());
        asExpressionInOCL.setIsRequired(asExpression.isIsRequired());
        return asExpressionInOCL;
    }

    @NonNull
    public static ExpressionInOCL createExpressionInOCLError(@NonNull String string) {
        ExpressionInOCL expressionInOCL = PivotFactory.eINSTANCE.createExpressionInOCL();
        StringLiteralExp stringLiteral = PivotFactory.eINSTANCE.createStringLiteralExp();
        stringLiteral.setStringSymbol(string);
        expressionInOCL.setOwnedBody(stringLiteral);
        expressionInOCL.setType(stringLiteral.getType());
        return expressionInOCL;
    }

    @NonNull
    public static InvalidType createInvalidType(@NonNull String name) {
        InvalidType pivotType = PivotFactory.eINSTANCE.createInvalidType();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    public static Iteration createIteration(@NonNull String name, @NonNull Type type, @Nullable String implementationClass, @NonNull LibraryFeature implementation) {
        Iteration pivotIteration = PivotFactory.eINSTANCE.createIteration();
        pivotIteration.setName(name);
        pivotIteration.setType(type);
        pivotIteration.setImplementationClass(implementationClass);
        pivotIteration.setImplementation(implementation);
        return pivotIteration;
    }

    @NonNull
    public static LambdaType createLambdaType(@NonNull String name) {
        LambdaType pivotType = PivotFactory.eINSTANCE.createLambdaType();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    public static LetExp createLetExp(@NonNull Variable asVariable, @NonNull OCLExpression asIn) {
        LetExp asLetExp = PivotFactory.eINSTANCE.createLetExp();
        asLetExp.setOwnedIn(asIn);
        asLetExp.setType(asIn.getType());
        asLetExp.setIsRequired(asIn.isIsRequired());
        asLetExp.setOwnedVariable(asVariable);
        return asLetExp;
    }

    @NonNull
    public static Model createModel(String externalURI) {
        Model pivotModel = PivotFactory.eINSTANCE.createModel();
        pivotModel.setExternalURI(externalURI);
        return pivotModel;
    }

    @NonNull
    public static MapType createMapType(@NonNull MapType unspecializedType, @NonNull Type keyType, @NonNull Type valueType) {
        return PivotUtil.createMapType(PivotFactory.eINSTANCE.createMapType(), unspecializedType, keyType, valueType);
    }

    @NonNull
    protected static <T extends MapType> T createMapType(T specializedType, @NonNull T unspecializedType, @NonNull Type keyType, @NonNull Type valueType) {
        specializedType.setName(unspecializedType.getName());
        specializedType.setUnspecializedElement(unspecializedType);
        specializedType.setKeyType(keyType);
        specializedType.setValueType(valueType);
        return specializedType;
    }

    @NonNull
    public static <T extends Model> T createModel(@NonNull java.lang.Class<T> pivotClass, EClass pivotEClass, String externalURI) {
        assert (pivotEClass != null);
        Model pivotModel = (Model)pivotEClass.getEPackage().getEFactoryInstance().create(pivotEClass);
        pivotModel.setExternalURI(externalURI);
        return (T)pivotModel;
    }

    @NonNull
    public static Operation createOperation(@NonNull String name, @NonNull Type type, @Nullable String implementationClass, @Nullable LibraryFeature implementation) {
        Operation pivotOperation = PivotFactory.eINSTANCE.createOperation();
        pivotOperation.setName(name);
        pivotOperation.setType(type);
        pivotOperation.setImplementationClass(implementationClass);
        pivotOperation.setImplementation(implementation);
        return pivotOperation;
    }

    @NonNull
    public static Operation createOperation(EOperation eOperation, @NonNull Type type, @Nullable String implementationClass, @Nullable LibraryFeature implementation) {
        Operation pivotOperation = PivotFactory.eINSTANCE.createOperation();
        pivotOperation.setName(eOperation.getName());
        pivotOperation.setType(type);
        pivotOperation.setImplementationClass(implementationClass);
        pivotOperation.setImplementation(implementation);
        ((PivotObjectImpl)((Object)pivotOperation)).setESObject((EObject)eOperation);
        return pivotOperation;
    }

    @NonNull
    public static Operation createOperation(@NonNull String name, @NonNull ExpressionInOCL asExpressionInOCL) {
        Operation asOperation = PivotFactory.eINSTANCE.createOperation();
        asOperation.setName(name);
        PivotUtil.initOperation(asOperation, asExpressionInOCL);
        return asOperation;
    }

    @NonNull
    public static OperationCallExp createOperationCallExp(@NonNull OCLExpression asSource, @NonNull Operation asOperation, OCLExpression ... asArguments) {
        OperationCallExp asCallExp = PivotFactory.eINSTANCE.createOperationCallExp();
        asCallExp.setReferredOperation(asOperation);
        asCallExp.setOwnedSource(asSource);
        if (asArguments != null) {
            List<OCLExpression> asCallArguments = asCallExp.getOwnedArguments();
            OCLExpression[] oCLExpressionArray = asArguments;
            int n = asArguments.length;
            int n2 = 0;
            while (n2 < n) {
                OCLExpression asArgument = oCLExpressionArray[n2];
                asCallArguments.add(ClassUtil.nonNullState(asArgument));
                ++n2;
            }
        }
        asCallExp.setType(asOperation.getType());
        asCallExp.setIsRequired(asOperation.isIsRequired());
        return asCallExp;
    }

    @NonNull
    public static OrderedSetType createOrderedSetType(@NonNull OrderedSetType unspecializedType, @NonNull Type elementType) {
        return PivotUtil.createCollectionType(PivotFactory.eINSTANCE.createOrderedSetType(), unspecializedType, elementType);
    }

    @NonNull
    public static Package createOwnedPackage(@NonNull Model parentRoot, @NonNull String name) {
        Package aPackage = PivotUtil.createPackage(Package.class, PivotPackage.Literals.PACKAGE, name, null, null);
        parentRoot.getOwnedPackages().add(aPackage);
        return aPackage;
    }

    @NonNull
    public static Package createOwnedPackage(@NonNull Package parentPackage, @NonNull String name) {
        Package aPackage = PivotUtil.createPackage(Package.class, PivotPackage.Literals.PACKAGE, name, null, null);
        parentPackage.getOwnedPackages().add(aPackage);
        return aPackage;
    }

    @NonNull
    public static Package createPackage(EPackage ePackage, @Nullable String nsPrefix, @NonNull String nsURI) {
        Package pivotPackage = PivotFactory.eINSTANCE.createPackage();
        pivotPackage.setName(ePackage.getName());
        pivotPackage.setNsPrefix(nsPrefix);
        pivotPackage.setURI(nsURI);
        ((PivotObjectImpl)((Object)pivotPackage)).setESObject((EObject)ePackage);
        return pivotPackage;
    }

    @NonNull
    public static Package createPackage(@NonNull String name, @Nullable String nsPrefix, @NonNull String nsURI, @Nullable PackageId packageId) {
        Package pivotPackage = PivotFactory.eINSTANCE.createPackage();
        pivotPackage.setName(name);
        pivotPackage.setNsPrefix(nsPrefix);
        if (packageId != null) {
            ((PackageImpl)pivotPackage).setPackageId(packageId);
        }
        pivotPackage.setURI(nsURI);
        return pivotPackage;
    }

    @NonNull
    public static <T extends Package> T createPackage(@NonNull java.lang.Class<T> pivotClass, @NonNull EClass pivotEClass, @NonNull String name, @Nullable String nsURI, @Nullable PackageId packageId) {
        Package asPackage = (Package)pivotEClass.getEPackage().getEFactoryInstance().create(pivotEClass);
        asPackage.setName(name);
        if (packageId != null) {
            ((PackageImpl)asPackage).setPackageId(packageId);
        }
        asPackage.setURI(nsURI);
        return (T)asPackage;
    }

    @NonNull
    public static Parameter createParameter(@NonNull String name, @NonNull Type asType, boolean isRequired) {
        Parameter asParameter = PivotFactory.eINSTANCE.createParameter();
        asParameter.setName(name);
        asParameter.setType(asType);
        asParameter.setIsRequired(isRequired);
        return asParameter;
    }

    @NonNull
    public static Precedence createPrecedence(@NonNull String name, AssociativityKind kind) {
        assert (kind != null);
        Precedence pivotPrecedence = PivotFactory.eINSTANCE.createPrecedence();
        pivotPrecedence.setName(name);
        pivotPrecedence.setAssociativity(kind);
        return pivotPrecedence;
    }

    @NonNull
    public static PrimitiveType createPrimitiveType(@NonNull String name) {
        PrimitiveType pivotType = PivotFactory.eINSTANCE.createPrimitiveType();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    public static Property createProperty(EStructuralFeature eFeature, @NonNull Type type) {
        Property pivotProperty = PivotFactory.eINSTANCE.createProperty();
        pivotProperty.setName(eFeature.getName());
        pivotProperty.setType(type);
        ((PivotObjectImpl)((Object)pivotProperty)).setESObject((EObject)eFeature);
        return pivotProperty;
    }

    @NonNull
    public static Property createProperty(@NonNull String name, @NonNull Type type) {
        Property pivotProperty = PivotFactory.eINSTANCE.createProperty();
        pivotProperty.setName(name);
        pivotProperty.setType(type);
        return pivotProperty;
    }

    @NonNull
    public static PropertyCallExp createPropertyCallExp(@NonNull OCLExpression asSource, @NonNull Property asProperty) {
        PropertyCallExp asChild = PivotFactory.eINSTANCE.createPropertyCallExp();
        asChild.setOwnedSource(asSource);
        asChild.setReferredProperty(asProperty);
        asChild.setType(asProperty.getType());
        asChild.setIsRequired(asProperty.isIsRequired());
        return asChild;
    }

    @NonNull
    public static SelfType createSelfType(@NonNull String name) {
        SelfType pivotType = PivotFactory.eINSTANCE.createSelfType();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    public static SequenceType createSequenceType(@NonNull SequenceType unspecializedType, @NonNull Type elementType) {
        return PivotUtil.createCollectionType(PivotFactory.eINSTANCE.createSequenceType(), unspecializedType, elementType);
    }

    @NonNull
    public static SetType createSetType(@NonNull SetType unspecializedType, @NonNull Type elementType) {
        return PivotUtil.createCollectionType(PivotFactory.eINSTANCE.createSetType(), unspecializedType, elementType);
    }

    @NonNull
    public static TemplateBinding createTemplateBinding(TemplateParameterSubstitution ... templateParameterSubstitutions) {
        TemplateBinding pivotTemplateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
        List<TemplateParameterSubstitution> parameterSubstitutions = pivotTemplateBinding.getOwnedSubstitutions();
        TemplateParameterSubstitution[] templateParameterSubstitutionArray = templateParameterSubstitutions;
        int n = templateParameterSubstitutions.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateParameterSubstitution templateParameterSubstitution = templateParameterSubstitutionArray[n2];
            parameterSubstitutions.add(templateParameterSubstitution);
            ++n2;
        }
        return pivotTemplateBinding;
    }

    @NonNull
    public static TemplateParameter createTemplateParameter(@NonNull String name, Class ... lowerBounds) {
        TemplateParameter pivotTemplateParameter = PivotFactory.eINSTANCE.createTemplateParameter();
        pivotTemplateParameter.setName(name);
        if (lowerBounds != null) {
            List<Class> constrainingClasses = pivotTemplateParameter.getConstrainingClasses();
            Class[] classArray = lowerBounds;
            int n = lowerBounds.length;
            int n2 = 0;
            while (n2 < n) {
                Class lowerBound = classArray[n2];
                constrainingClasses.add(lowerBound);
                ++n2;
            }
        }
        return pivotTemplateParameter;
    }

    @NonNull
    public static TemplateParameterSubstitution createTemplateParameterSubstitution(@NonNull TemplateParameter formal, @NonNull Type actual) {
        TemplateParameterSubstitution pivotTemplateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
        pivotTemplateParameterSubstitution.setFormal(formal);
        pivotTemplateParameterSubstitution.setActual(actual);
        return pivotTemplateParameterSubstitution;
    }

    @NonNull
    public static TemplateSignature createTemplateSignature(@NonNull TemplateableElement templateableElement, TemplateParameter ... templateParameters) {
        TemplateSignature pivotTemplateSignature = PivotFactory.eINSTANCE.createTemplateSignature();
        List<TemplateParameter> parameters = pivotTemplateSignature.getOwnedParameters();
        TemplateParameter[] templateParameterArray = templateParameters;
        int n = templateParameters.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateParameter templateParameter = templateParameterArray[n2];
            parameters.add(templateParameter);
            ++n2;
        }
        pivotTemplateSignature.setOwningElement(templateableElement);
        return pivotTemplateSignature;
    }

    @NonNull
    public static TupleType createTupleType(@NonNull String name, Property ... properties) {
        TupleType pivotType = PivotFactory.eINSTANCE.createTupleType();
        pivotType.setName(name);
        List<Property> ownedProperties = pivotType.getOwnedProperties();
        Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            ownedProperties.add(property);
            ++n2;
        }
        return pivotType;
    }

    @NonNull
    public static String createTupleValuedConstraint(@NonNull String statusText, @Nullable Integer severity, @Nullable String messageText) {
        if (severity == null && messageText == null) {
            return statusText;
        }
        StringBuilder s = new StringBuilder();
        s.append("Tuple {");
        if (messageText != null) {
            s.append("\n\tmessage : String = " + messageText + ",");
        }
        if (severity != null) {
            s.append("\n\tseverity : Integer = " + severity + ",");
        }
        s.append("\n\tstatus : Boolean = " + statusText);
        s.append("\n}.status");
        String string = s.toString();
        return string;
    }

    @NonNull
    public static Variable createVariable(@NonNull String name, @NonNull OCLExpression asInitExpression) {
        Variable asVariable = PivotFactory.eINSTANCE.createVariable();
        asVariable.setName(name);
        asVariable.setType(asInitExpression.getType());
        asVariable.setIsRequired(asInitExpression.isIsRequired());
        asVariable.setOwnedInit(asInitExpression);
        return asVariable;
    }

    @NonNull
    public static Variable createVariable(@NonNull String name, @NonNull Type asType, boolean isRequired, @Nullable OCLExpression asInitExpression) {
        Variable asVariable = PivotFactory.eINSTANCE.createVariable();
        asVariable.setName(name);
        asVariable.setType(asType);
        asVariable.setIsRequired(isRequired);
        asVariable.setOwnedInit(asInitExpression);
        return asVariable;
    }

    @NonNull
    public static VariableExp createVariableExp(@NonNull Variable asVariable) {
        VariableExp asVariableExp = PivotFactory.eINSTANCE.createVariableExp();
        asVariableExp.setReferredVariable(asVariable);
        asVariableExp.setType(asVariable.getType());
        asVariableExp.setIsRequired(asVariable.isIsRequired());
        return asVariableExp;
    }

    @NonNull
    public static VoidType createVoidType(@NonNull String name) {
        VoidType pivotType = PivotFactory.eINSTANCE.createVoidType();
        pivotType.setName(name);
        return pivotType;
    }

    public static void debugObjectUsage(String prefix, EObject element) {
        StringBuilder s = new StringBuilder();
        s.append(prefix);
        if (element != null) {
            s.append(element.eClass().getName());
            s.append("@");
            s.append(Integer.toHexString(element.hashCode()));
            Resource eResource = element.eResource();
            if (eResource != null) {
                if (element instanceof Element) {
                    s.append(" ");
                    s.append(AS2Moniker.toString((Element)element));
                }
                s.append(" ");
                s.append(eResource.getURI());
            } else if (element instanceof NamedElement) {
                s.append(" ");
                s.append(String.valueOf(((NamedElement)element).getName()));
            }
        } else {
            s.append("null");
        }
        System.out.println(s.toString());
    }

    public static boolean debugWellContainedness(Type type) {
        Type elementType;
        if (type.eResource() == null) {
            PivotUtil.debugObjectUsage("Badly contained ", type);
            return false;
        }
        if (type instanceof CollectionType && (elementType = ((CollectionType)type).getElementType()) != null && !PivotUtil.debugWellContainedness(elementType)) {
            PivotUtil.debugObjectUsage("Badly contained ", type);
            return false;
        }
        return true;
    }

    public static String formatDiagnostics(@NonNull Diagnostic diagnostic, @NonNull String newLine) {
        StringBuilder s = new StringBuilder();
        PivotUtil.formatDiagnostic(s, diagnostic, newLine);
        return s.toString();
    }

    public static void formatDiagnostic(@NonNull StringBuilder s, @NonNull Diagnostic diagnostic, @NonNull String newLine) {
        if (diagnostic.getSeverity() != 0) {
            s.append(newLine);
            s.append(String.valueOf(diagnostic.getSeverity()) + " - ");
            String location = diagnostic.getSource();
            if (location != null) {
                s.append(location);
                s.append(": ");
            }
            s.append(diagnostic.getMessage());
            for (Object obj : diagnostic.getData()) {
                s.append(newLine);
                s.append("\t");
                s.append(obj);
            }
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (childDiagnostic == null) continue;
                PivotUtil.formatDiagnostic(s, childDiagnostic, String.valueOf(newLine) + "\t");
            }
        }
    }

    public static String formatResourceDiagnostics(@NonNull List<Resource.Diagnostic> diagnostics, @NonNull String messagePrefix, @NonNull String newLine) {
        if (diagnostics.size() <= 0) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(messagePrefix);
        for (Resource.Diagnostic diagnostic : diagnostics) {
            if (diagnostic instanceof Diagnostic) {
                PivotUtil.formatDiagnostic(s, (Diagnostic)diagnostic, newLine);
                continue;
            }
            s.append(newLine);
            String location = diagnostic.getLocation();
            if (location != null) {
                s.append(location);
                s.append(":");
            }
            s.append(diagnostic.getLine());
            try {
                int column = diagnostic.getColumn();
                if (column > 0) {
                    s.append(":");
                    s.append(column);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            s.append(": ");
            s.append(diagnostic.getMessage());
        }
        return s.toString();
    }

    @Nullable
    public static Constraint getContainingConstraint(@Nullable Element element) {
        Element eObject = element;
        while (eObject != null) {
            if (eObject instanceof Constraint) {
                return (Constraint)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static ExpressionInOCL getContainingExpressionInOCL(@Nullable Element element) {
        Element eObject = element;
        while (eObject != null) {
            if (eObject instanceof ExpressionInOCL) {
                return (ExpressionInOCL)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static Model getContainingModel(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Model) {
                return (Model)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static Namespace getContainingNamespace(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Namespace) {
                return (Namespace)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static Operation getContainingOperation(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Operation) {
                return (Operation)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static Package getContainingPackage(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Package) {
                return (Package)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Model getContainingRoot(@Nullable EObject element) {
        return PivotUtil.getContainingModel(element);
    }

    @Nullable
    public static Type getContainingType(@Nullable EObject element) {
        if (element != null) {
            EObject eObject = element;
            while (true) {
                if (eObject instanceof Type) {
                    return (Type)eObject;
                }
                EObject eContainer = eObject.eContainer();
                if (eContainer == null) {
                    if (!(eObject instanceof ExpressionInOCL)) break;
                    return ((ExpressionInOCL)eObject).getOwnedContext().getType();
                }
                eObject = eContainer;
            }
        }
        return null;
    }

    public static int getContainmentDepth(EObject eObject) {
        int depth = 0;
        EObject eContainer = eObject.eContainer();
        while (eContainer != null) {
            if (++depth > 100000) {
                return depth;
            }
            eContainer = eContainer.eContainer();
        }
        return depth;
    }

    @Nullable
    public static java.lang.Class<?> getEcoreInstanceClass(@Nullable Property asProperty) {
        EClassifier eType;
        EObject eTarget;
        java.lang.Class instanceClass = null;
        if (asProperty != null && (eTarget = asProperty.getESObject()) instanceof EStructuralFeature && (eType = ((EStructuralFeature)eTarget).getEType()) != null) {
            instanceClass = eType.getInstanceClass();
        }
        return instanceClass;
    }

    @Nullable
    public static Namespace getNamespace(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Model) {
                return null;
            }
            if (eObject instanceof Type) {
                return (Namespace)eObject;
            }
            if (eObject instanceof Package) {
                return (Namespace)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @NonNull
    public static String getNavigationOperator(boolean isSafe, boolean isAggregate) {
        if (isAggregate) {
            return isSafe ? "?->" : "->";
        }
        return isSafe ? "?." : ".";
    }

    @Nullable
    public static Package getPackage(@NonNull EObject object) {
        EObject eObject = object;
        while (eObject != null) {
            if (eObject instanceof Package) {
                return (Package)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static <T extends Element> T getPivot(@NonNull java.lang.Class<T> pivotClass, @Nullable Pivotable pivotableElement) {
        if (pivotableElement == null) {
            return null;
        }
        Element pivotElement = pivotableElement.getPivot();
        if (pivotElement == null) {
            return null;
        }
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException(String.valueOf(pivotElement.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        Element castElement = pivotElement;
        return (T)castElement;
    }

    public static Feature getReferredFeature(CallExp callExp) {
        Feature feature = null;
        if (callExp instanceof LoopExp) {
            feature = ((LoopExp)callExp).getReferredIteration();
        } else if (callExp instanceof OperationCallExp) {
            feature = ((OperationCallExp)callExp).getReferredOperation();
        } else if (callExp instanceof OppositePropertyCallExp) {
            Property referredOppositeProperty = ((OppositePropertyCallExp)callExp).getReferredProperty();
            feature = referredOppositeProperty != null ? referredOppositeProperty.getOpposite() : null;
        } else if (callExp instanceof PropertyCallExp) {
            feature = ((PropertyCallExp)callExp).getReferredProperty();
        }
        return feature;
    }

    public static Operation getReferredOperation(CallExp callExp) {
        Operation operation = null;
        if (callExp instanceof LoopExp) {
            operation = ((LoopExp)callExp).getReferredIteration();
        } else if (callExp instanceof OperationCallExp) {
            operation = ((OperationCallExp)callExp).getReferredOperation();
        }
        return operation;
    }

    @NonNull
    public static <T extends TemplateableElement> T getUnspecializedTemplateableElement(@NonNull T templateableElement) {
        TemplateableElement unspecializedElement = templateableElement.getUnspecializedElement();
        if (unspecializedElement == null) {
            return templateableElement;
        }
        TemplateableElement castUnspecializedElement = unspecializedElement;
        return (T)castUnspecializedElement;
    }

    @NonNull
    public static Operation initOperation(@NonNull Operation asOperation, @NonNull ExpressionInOCL asExpressionInOCL) {
        for (Variable asParameterVariable : asExpressionInOCL.getOwnedParameters()) {
            String parameterName = ClassUtil.nonNullState(asParameterVariable.getName());
            Type parameterType = ClassUtil.nonNullState(asParameterVariable.getType());
            Parameter asParameter = PivotUtil.createParameter(parameterName, parameterType, asParameterVariable.isIsRequired());
            asParameterVariable.setRepresentedParameter(asParameter);
            asOperation.getOwnedParameters().add(asParameter);
        }
        asOperation.setBodyExpression(asExpressionInOCL);
        asOperation.setType(asExpressionInOCL.getType());
        asOperation.setIsRequired(asExpressionInOCL.isIsRequired());
        return asOperation;
    }

    public static boolean isAggregate(Type type) {
        return type instanceof CollectionType || type instanceof MapType;
    }

    public static boolean isAggregateNavigationOperator(String operatorName) {
        return "->".equals(operatorName) || "?->".equals(operatorName);
    }

    public static boolean isObjectNavigationOperator(String operatorName) {
        return ".".equals(operatorName) || "?.".equals(operatorName);
    }

    public static boolean isSafeNavigationOperator(String operatorName) {
        return "?->".equals(operatorName) || "?.".equals(operatorName);
    }

    public static void setBody(@NonNull ExpressionInOCL expressionInOCL, @Nullable OCLExpression oclExpression, @Nullable String stringExpression) {
        expressionInOCL.setBody(stringExpression);
        expressionInOCL.setOwnedBody(oclExpression);
    }

    public static boolean setParserContext(@NonNull CSResource csResource, @NonNull EObject eObject, Object ... todoParameters) throws ParserException {
        EnvironmentFactoryAdapter adapter = OCLInternal.adapt((Notifier)csResource);
        EnvironmentFactoryInternal environmentFactory = adapter.getEnvironmentFactory();
        Element pivotElement = environmentFactory.getTechnology().getParseableElement(environmentFactory, eObject);
        if (pivotElement == null) {
            return false;
        }
        ParserContext parserContext = environmentFactory.getMetamodelManager().createParserContext(pivotElement, todoParameters);
        if (parserContext == null) {
            return false;
        }
        csResource.setParserContext(parserContext);
        return true;
    }

    public static class PrecedenceComparator
    implements Comparator<Precedence> {
        public static final PrecedenceComparator INSTANCE = new PrecedenceComparator();

        @Override
        public int compare(Precedence p1, Precedence p2) {
            int o1 = p1 != null ? p1.getOrder().intValue() : -1;
            int o2 = p2 != null ? p2.getOrder().intValue() : -1;
            return o1 - o2;
        }
    }

    public static class TemplateParameterSubstitutionComparator
    implements Comparator<TemplateParameterSubstitution> {
        public static Comparator<? super TemplateParameterSubstitution> INSTANCE = new TemplateParameterSubstitutionComparator();

        @Override
        public int compare(TemplateParameterSubstitution o1, TemplateParameterSubstitution o2) {
            TemplateParameter f1 = o1.getFormal();
            TemplateParameter f2 = o2.getFormal();
            int i1 = f1.getOwningSignature().getOwnedParameters().indexOf(f1);
            int i2 = f2.getOwningSignature().getOwnedParameters().indexOf(f2);
            return i1 - i2;
        }
    }
}

