/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.as2cs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PathElement;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.xtext.basecs.ImportCS;
import org.eclipse.ocl.xtext.basecs.NamedElementCS;
import org.eclipse.ocl.xtext.basecs.RootPackageCS;

public class AliasAnalysis
extends AdapterImpl {
    @NonNull
    protected final EnvironmentFactoryInternal environmentFactory;
    @NonNull
    private Map<String, Object> allNames = new HashMap<String, Object>();
    @NonNull
    private Map<CompletePackage, String> allAliases = new HashMap<CompletePackage, String>();

    public static void dispose(@NonNull Resource resource) {
        List eAdapters = (List)ClassUtil.nonNullEMF((Object)resource.eAdapters());
        AliasAnalysis adapter = (AliasAnalysis)((Object)ClassUtil.getAdapter(AliasAnalysis.class, (List)eAdapters));
        if (adapter != null) {
            adapter.dispose();
        }
    }

    @NonNull
    public static AliasAnalysis getAdapter(@NonNull Resource resource) {
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.findEnvironmentFactory((Resource)resource);
        if (environmentFactory == null) {
            throw new IllegalStateException("No EnvironmentFactory");
        }
        return AliasAnalysis.getAdapter(resource, environmentFactory);
    }

    @NonNull
    public static AliasAnalysis getAdapter(@NonNull Resource resource, @NonNull EnvironmentFactoryInternal environmentFactory) {
        EList eAdapters = resource.eAdapters();
        for (Adapter adapter : eAdapters) {
            if (!(adapter instanceof AliasAnalysis)) continue;
            AliasAnalysis aliasAnalysis = (AliasAnalysis)adapter;
            if (aliasAnalysis.environmentFactory != environmentFactory) continue;
            return aliasAnalysis;
        }
        AliasAnalysis aliasAnalysis = new AliasAnalysis(resource, environmentFactory);
        HashSet<Package> localPackages = new HashSet<Package>();
        HashSet<Package> otherPackages = new HashSet<Package>();
        aliasAnalysis.computePackages(localPackages, otherPackages);
        aliasAnalysis.computeAliases(localPackages, otherPackages);
        return aliasAnalysis;
    }

    public AliasAnalysis(@NonNull Resource resource, @NonNull EnvironmentFactoryInternal environmentFactory) {
        resource.eAdapters().add((Object)this);
        this.environmentFactory = environmentFactory;
    }

    private void computeAliases(@NonNull Set<Package> localPackages, @NonNull Set<Package> otherPackages) {
        String alias;
        CompletePackage primaryPackage;
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        for (Package localPackage : localPackages) {
            if (localPackage == null || (primaryPackage = metamodelManager.getCompletePackage(localPackage)).getNsPrefix() == null && primaryPackage.getOwningCompletePackage() != null || this.allAliases.containsKey(primaryPackage)) continue;
            alias = this.computeAlias(primaryPackage);
            this.allAliases.put(primaryPackage, alias);
        }
        for (Package otherPackage : otherPackages) {
            if (otherPackage == null || this.allAliases.containsKey(primaryPackage = metamodelManager.getCompletePackage(otherPackage))) continue;
            alias = this.computeAlias(primaryPackage);
            this.allAliases.put(primaryPackage, alias);
        }
    }

    private void addName(@NonNull String name, @NonNull Object primaryElement) {
        if (!this.allNames.containsKey(name)) {
            this.allNames.put(name, primaryElement);
        } else if (this.allNames.get(name) != primaryElement) {
            this.allNames.put(name, null);
        }
    }

    private String computeAlias(@NonNull CompletePackage primaryPackage) {
        String nsPrefix = primaryPackage.getNsPrefix();
        String aliasBase = nsPrefix != null ? nsPrefix : this.getDefaultAlias(primaryPackage.getName());
        int index = 0;
        String alias = aliasBase;
        while (this.allNames.containsKey(alias) && this.allNames.get(alias) != primaryPackage) {
            Object debugObject = this.allNames.get(alias);
            alias = String.valueOf(aliasBase) + "_" + index++;
        }
        this.addName(alias, primaryPackage);
        return alias;
    }

    private void computePackages(@NonNull Set<Package> localPackages, @NonNull Set<Package> otherPackages) {
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        TreeIterator tit = ((Resource)this.target).getAllContents();
        block0: while (tit.hasNext()) {
            String name;
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof ImportCS) {
                String name2 = ((ImportCS)eObject).getName();
                Namespace namespace = ((ImportCS)eObject).getReferredNamespace();
                if (namespace instanceof Package) {
                    Package namespace2 = (Package)namespace;
                    CompletePackage completePackage = metamodelManager.getCompletePackage(namespace2);
                    this.allAliases.put(completePackage, name2);
                }
            }
            EObject csObject = eObject;
            if (eObject instanceof Pivotable) {
                eObject = ((Pivotable)eObject).getPivot();
            }
            if (!(eObject instanceof NamedElement)) continue;
            NamedElement domainNamedElement = (NamedElement)eObject;
            if (!(eObject instanceof CompletePackage) && !(eObject instanceof CompletePackage) && eObject instanceof Package) {
                domainNamedElement = metamodelManager.getCompletePackage((Package)eObject);
            }
            if ((name = domainNamedElement.getName()) != null) {
                this.addName(name, domainNamedElement);
            }
            if (eObject instanceof Package && csObject instanceof RootPackageCS) {
                Package pivotPackage = (Package)eObject;
                String nsPrefix = pivotPackage.getNsPrefix();
                if (nsPrefix != null) {
                    this.addName(nsPrefix, domainNamedElement);
                }
                localPackages.add(pivotPackage);
                continue;
            }
            EObject eContainer = eObject;
            while (eContainer != null) {
                if (eContainer instanceof Package) {
                    otherPackages.add((Package)eContainer);
                    continue block0;
                }
                if (eContainer instanceof Class) {
                    eContainer = PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)((Class)eContainer));
                }
                eContainer = eContainer.eContainer();
            }
        }
        otherPackages.removeAll(localPackages);
        HashSet<Package> nestedPackages = new HashSet<Package>();
        for (Package localPackage : localPackages) {
            EObject eContainerContainer;
            EObject eContainer = localPackage.eContainer();
            if (!(eContainer instanceof Package) || !((eContainerContainer = eContainer.eContainer()) instanceof Package)) continue;
            nestedPackages.add(localPackage);
        }
        localPackages.removeAll(nestedPackages);
    }

    public void dispose() {
        this.target.eAdapters().remove((Object)this);
    }

    @Nullable
    public String getAlias(@NonNull EObject eObject, @Nullable String hint) {
        EObject eObject2 = eObject;
        if (eObject2 instanceof Pivotable) {
            eObject2 = ((Pivotable)eObject2).getPivot();
        }
        if (eObject2 instanceof Package) {
            CompletePackage completePackage = this.environmentFactory.getMetamodelManager().getCompletePackage((Package)eObject2);
            String alias = this.allAliases.get(completePackage);
            if (alias != null) {
                return alias;
            }
            if (hint != null) {
                if (this.allNames.get(hint) != null) {
                    int counter = 0;
                    while (this.allNames.get(String.valueOf(hint) + "_" + counter) != null) {
                        ++counter;
                    }
                    hint = String.valueOf(hint) + "_" + counter;
                }
                this.allNames.put(hint, completePackage);
                this.allAliases.put(completePackage, hint);
                return hint;
            }
        }
        return null;
    }

    @NonNull
    public Iterable<CompletePackage> getAliases() {
        return this.allAliases.keySet();
    }

    @NonNull
    protected String getDefaultAlias(@Nullable String name) {
        if (name == null) {
            return "anon";
        }
        int iMax = name.length();
        if (iMax <= 0) {
            return "anon";
        }
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < iMax) {
            char c = name.charAt(i);
            if (!Character.isUpperCase(c)) {
                s.append(name.substring(i));
                break;
            }
            s.append(Character.toLowerCase(c));
            ++i;
        }
        String string = s.toString();
        return string;
    }

    @NonNull
    public List<PathElement> getPath(@NonNull Element eObject) {
        EObject eContainer = eObject.eContainer();
        if (eContainer == null) {
            return new ArrayList<PathElement>();
        }
        List<PathElement> result = this.getPath((Element)eContainer);
        if (eObject instanceof NamedElement) {
            result.add(new PathElement(((NamedElement)eObject).getName(), eObject));
        } else if (eObject instanceof ENamedElement) {
            result.add(new PathElement(((ENamedElement)eObject).getName(), eObject));
        } else if (eObject instanceof NamedElementCS) {
            result.add(new PathElement(((NamedElementCS)eObject).getName(), eObject));
        }
        return result;
    }

    public boolean isAdapterForType(Object type) {
        return type == AliasAnalysis.class;
    }
}

