/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.completeocl.utilities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.internal.validation.PivotEObjectValidator;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;

public abstract class CompleteOCLLoader {
    @NonNull
    protected final OCLInternal ocl;
    @NonNull
    protected final List<Model> oclModels = new ArrayList<Model>();
    @NonNull
    protected final Set<EPackage> mmPackages;

    public CompleteOCLLoader(@NonNull EnvironmentFactory environmentFactory) {
        this.ocl = OCLInternal.newInstance((EnvironmentFactoryInternal)((EnvironmentFactoryInternal)environmentFactory));
        this.mmPackages = new HashSet<EPackage>();
    }

    public void dispose() {
        this.ocl.dispose();
    }

    @NonNull
    public EnvironmentFactory getEnvironmentFactory() {
        return this.ocl.getEnvironmentFactory();
    }

    @NonNull
    public MetamodelManager getMetamodelManager() {
        return this.ocl.getMetamodelManager();
    }

    public boolean loadMetamodels() {
        for (Resource resource : this.ocl.getResourceSet().getResources()) {
            assert (resource != null);
            External2AS ecore2as = Ecore2AS.findAdapter((Resource)resource, (EnvironmentFactoryInternal)this.ocl.getEnvironmentFactory());
            if (ecore2as != null) continue;
            TreeIterator tit = resource.getAllContents();
            while (tit.hasNext()) {
                EPackage mmPackage;
                EObject eObject = (EObject)tit.next();
                EClass eClass = eObject.eClass();
                if (eClass == null || (mmPackage = eClass.getEPackage()) == null) continue;
                this.mmPackages.add(mmPackage);
            }
        }
        HashSet<Resource> mmResources = new HashSet<Resource>();
        for (EPackage mmPackage : this.mmPackages) {
            Resource mmResource = EcoreUtil.getRootContainer((EObject)mmPackage).eResource();
            if (mmResource == null) continue;
            mmResources.add(mmResource);
        }
        for (Resource mmResource : mmResources) {
            assert (mmResource != null);
            try {
                Element pivotModel = this.ocl.getEnvironmentFactory().loadResource(mmResource, null);
                if (pivotModel != null) {
                    EList errors = pivotModel.eResource().getErrors();
                    assert (errors != null);
                    String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
                    if (message == null) continue;
                    return this.error("Failed to load Pivot from '" + mmResource.getURI(), message);
                }
                return this.error("Failed to load Pivot from '" + mmResource.getURI(), "");
            }
            catch (ParserException e) {
                return this.error("Failed to load Pivot from '" + mmResource.getURI(), e.getMessage());
            }
        }
        return true;
    }

    protected abstract boolean error(@NonNull String var1, @Nullable String var2);

    public void installPackages() {
        PivotEObjectValidator.install((ResourceSet)this.ocl.getResourceSet(), (EnvironmentFactoryInternal)this.ocl.getEnvironmentFactory());
        for (EPackage mmPackage : this.mmPackages) {
            assert (mmPackage != null);
            PivotEObjectValidator.install((EPackage)mmPackage, this.oclModels);
        }
    }

    public boolean loadDocument(@NonNull URI oclURI) {
        Resource resource = this.loadResource(oclURI);
        if (resource == null) {
            return false;
        }
        MetamodelManagerInternal metamodelManager = this.ocl.getMetamodelManager();
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof Package) {
                EObject mmPackage;
                Package aPackage = metamodelManager.getPrimaryPackage((Package)eObject);
                if (!(aPackage instanceof PivotObjectImpl) || !((mmPackage = ((PivotObjectImpl)aPackage).getESObject()) instanceof EPackage)) continue;
                this.mmPackages.add((EPackage)mmPackage);
                continue;
            }
            if (eObject instanceof Type) {
                tit.prune();
                continue;
            }
            if (!(eObject instanceof Model)) continue;
            this.oclModels.add((Model)eObject);
        }
        return true;
    }

    public Resource loadResource(@NonNull URI oclURI) {
        CSResource xtextResource = null;
        CompleteOCLStandaloneSetup.init();
        ResourceSet resourceSet = this.ocl.getResourceSet();
        try {
            xtextResource = (CSResource)resourceSet.getResource(oclURI, true);
        }
        catch (WrappedException e) {
            IStatus status;
            URI retryURI = null;
            Throwable cause = e.getCause();
            if (cause instanceof CoreException && (status = ((CoreException)cause).getStatus()).getCode() == 368 && status.getPlugin().equals("org.eclipse.core.resources") && oclURI.isPlatformResource()) {
                retryURI = URI.createPlatformPluginURI((String)oclURI.toPlatformString(false), (boolean)false);
            }
            if (retryURI != null) {
                xtextResource = (CSResource)resourceSet.getResource(retryURI, true);
            }
            throw e;
        }
        EList errors = xtextResource.getErrors();
        assert (errors != null);
        String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            this.error("Failed to load '" + oclURI, message);
            return null;
        }
        ASResource asResource = xtextResource.getASResource();
        errors = asResource.getErrors();
        assert (errors != null);
        message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            this.error("Failed to load Pivot from '" + oclURI, message);
            return null;
        }
        return asResource;
    }
}

