/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.essentialocl.attributes;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.ocl.xtext.basecs.PathElementCS;
import org.eclipse.ocl.xtext.basecs.PathNameCS;
import org.eclipse.ocl.xtext.essentialoclcs.AbstractNameExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.ExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.InfixExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NameExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.xtext.essentialoclcs.NavigationRole;
import org.eclipse.ocl.xtext.essentialoclcs.OperatorExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.RoundBracketedClauseCS;

public class NavigationUtil {
    @Nullable
    public static InfixExpCS getNavigationInfixExp(@NonNull AbstractNameExpCS csExp) {
        EObject eContainer = csExp.eContainer();
        if (eContainer instanceof NameExpCS) {
            csExp = (NameExpCS)eContainer;
        }
        ExpCS csChild = csExp;
        while (csChild != null) {
            OperatorExpCS csOperator = csChild.getLocalParent();
            if (csOperator == null) {
                return null;
            }
            ExpCS csSource = csOperator.getSource();
            if (csSource != csChild) {
                if (NavigationUtil.isNavigationInfixExp((EObject)csOperator)) {
                    return (InfixExpCS)csOperator;
                }
                return null;
            }
            csChild = csChild.getLocalParent();
        }
        return null;
    }

    public static boolean isIteration(@NonNull PivotMetamodelManager metamodelManager, @NonNull RoundBracketedClauseCS csRoundBracketedClause, @NonNull CollectionType type) {
        for (NavigatingArgCS csArg : csRoundBracketedClause.getOwnedArguments()) {
            if (csArg.getRole() == NavigationRole.EXPRESSION) continue;
            return true;
        }
        AbstractNameExpCS csNameExp = csRoundBracketedClause.getOwningNameExp();
        PathNameCS pathName = csNameExp.getOwnedPathName();
        EList path = pathName.getOwnedPathElements();
        if (path.size() != 1) {
            return false;
        }
        PathElementCS csPathElement = (PathElementCS)path.get(0);
        Element unresolvedElement = csPathElement.basicGetReferredElement();
        if (unresolvedElement != null && !unresolvedElement.eIsProxy()) {
            return unresolvedElement instanceof Iteration;
        }
        String name = csPathElement.toString();
        assert (name != null);
        Iterator iterator = metamodelManager.getAllOperations((Type)type, FeatureFilter.SELECT_NON_STATIC, name).iterator();
        if (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            return operation instanceof Iteration;
        }
        return false;
    }

    public static boolean isNavigationInfixExp(@Nullable EObject eObject) {
        if (eObject instanceof InfixExpCS) {
            String name = ((InfixExpCS)eObject).getName();
            return NavigationUtil.isNavigationOperator(name);
        }
        return false;
    }

    public static boolean isNavigationOperator(String name) {
        return ".".equals(name) || "->".equals(name) || "?.".equals(name) || "?->".equals(name) || "^".equals(name) || "^^".equals(name);
    }
}

