/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.markup.ui.hover;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.ReferringElement;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.HTMLBuffer;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.markup.MarkupUtils;
import org.eclipse.ocl.xtext.markupcs.Markup;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.ui.editor.hover.IEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlInput;

public class MarkupHoverProvider
extends DefaultEObjectHoverProvider {
    protected String getDocumentation(EObject o) {
        EnvironmentFactoryInternal environmentFactory;
        Markup markup;
        block18: {
            String documentation;
            Resource resource = o.eResource();
            if (resource == null) {
                return null;
            }
            if (o instanceof Pivotable) {
                TemplateableElement o3;
                Element o2;
                Element o1 = ((Pivotable)o).getPivot();
                if (o1 != null) {
                    o = o1;
                }
                if (o instanceof ReferringElement && (o2 = ((ReferringElement)o).getReferredElement()) != null) {
                    o = o2;
                }
                if (o instanceof TemplateableElement && (o3 = ((TemplateableElement)o).getUnspecializedElement()) != null) {
                    o = o3;
                }
            }
            if ((documentation = super.getDocumentation(o)) == null) {
                return null;
            }
            IParseResult parseResult = MarkupUtils.decode((String)documentation);
            if (parseResult == null) {
                return null;
            }
            markup = (Markup)parseResult.getRootASTElement();
            if (markup == null) {
                return null;
            }
            Iterable parseErrors = parseResult.getSyntaxErrors();
            Map<Integer, Integer> errorMap = this.getErrorMap(parseErrors);
            if (errorMap != null) {
                HTMLBuffer htmlBuffer = new HTMLBuffer();
                int i = 0;
                ArrayList<Integer> starts = new ArrayList<Integer>(errorMap.keySet());
                Collections.sort(starts);
                Iterator<Object> iterator = starts.iterator();
                while (iterator.hasNext()) {
                    int start = (Integer)iterator.next();
                    int end = errorMap.get(start);
                    while (i < start) {
                        htmlBuffer.append(documentation.charAt(i++));
                    }
                    htmlBuffer.startFontColor("red");
                    htmlBuffer.startUnderline();
                    while (i < end) {
                        htmlBuffer.append(documentation.charAt(i++));
                    }
                    htmlBuffer.endUnderline();
                    htmlBuffer.endFontColor();
                }
                htmlBuffer.startFontColor("red");
                htmlBuffer.startParagraph();
                htmlBuffer.endParagraph();
                for (INode parseError : parseErrors) {
                    htmlBuffer.startParagraph();
                    htmlBuffer.append(parseError.getSyntaxErrorMessage().getMessage());
                    htmlBuffer.endParagraph();
                }
                htmlBuffer.endFontColor();
                return htmlBuffer.toString();
            }
            if (o instanceof Pivotable) {
                o = ((Pivotable)o).getPivot();
            }
            if (o == null) {
                return null;
            }
            try {
                environmentFactory = PivotUtilInternal.findEnvironmentFactory((Resource)resource);
                if (environmentFactory != null) break block18;
                return null;
            }
            catch (Exception e) {
                StringWriter s = new StringWriter();
                e.printStackTrace(new PrintWriter(s));
                return s.toString().replace("\n", "\n<br>");
            }
        }
        return MarkupUtils.toHTML((EnvironmentFactoryInternal)environmentFactory, (Object)o, (Markup)markup);
    }

    protected Map<Integer, Integer> getErrorMap(Iterable<INode> parseErrors) {
        HashMap<Integer, Integer> errorMap = null;
        for (INode parseError : parseErrors) {
            if (errorMap == null) {
                errorMap = new HashMap<Integer, Integer>();
            }
            int start = parseError.getOffset();
            errorMap.put(start, start + parseError.getLength());
        }
        if (errorMap != null) {
            ArrayList starts = new ArrayList(errorMap.keySet());
            Collections.sort(starts);
            Integer currentStart = null;
            int currentEnd = 0;
            int i = 0;
            while (i < starts.size()) {
                Integer start = (Integer)starts.get(i);
                if (currentStart == null) {
                    currentStart = start;
                    currentEnd = (Integer)errorMap.get(start);
                } else {
                    currentEnd = (Integer)errorMap.get(start);
                    if (start > currentEnd) {
                        currentStart = start;
                    } else {
                        errorMap.remove(start);
                        errorMap.put(currentStart, currentEnd);
                    }
                }
                ++i;
            }
        }
        return errorMap;
    }

    protected String getFirstLine(EObject eObject) {
        Element pivotElement = null;
        if (eObject instanceof Pivotable) {
            pivotElement = PivotUtil.getPivot(Element.class, (Pivotable)((Pivotable)eObject));
        } else if (eObject instanceof Element) {
            pivotElement = (Element)eObject;
        }
        if (pivotElement != null) {
            Type type;
            EnvironmentFactoryInternal environmentFactory;
            Namespace namespace = MarkupHoverProvider.getNamespace((EObject)pivotElement);
            if (namespace != null && namespace.eContainer() instanceof Namespace) {
                namespace = (Namespace)namespace.eContainer();
            }
            String description = null;
            PrettyPrintOptions.Global prettyPrintOptions = new PrettyPrintOptions.Global(namespace){

                @Nullable
                public Set<String> getReservedNames() {
                    return null;
                }

                @Nullable
                public Set<String> getRestrictedNames() {
                    return null;
                }
            };
            if (namespace != null && (environmentFactory = PivotUtilInternal.findEnvironmentFactory((EObject)namespace)) != null) {
                prettyPrintOptions.setEnvironmentFactory((EnvironmentFactory)environmentFactory);
            }
            if (pivotElement instanceof CallExp) {
                description = PrettyPrinter.printType((Element)pivotElement, (PrettyPrintOptions)prettyPrintOptions);
            } else if (pivotElement instanceof VariableExp) {
                VariableDeclaration referredVariable = ((VariableExp)pivotElement).getReferredVariable();
                if (referredVariable != null) {
                    description = PrettyPrinter.print((Element)referredVariable, (PrettyPrintOptions)prettyPrintOptions);
                }
            } else if (pivotElement instanceof OCLExpression && (type = ((OCLExpression)pivotElement).getType()) != null) {
                description = PrettyPrinter.printType((Element)type, (PrettyPrintOptions)prettyPrintOptions);
            }
            if (description == null) {
                description = PrettyPrinter.print((Element)pivotElement, (PrettyPrintOptions)prettyPrintOptions);
            }
            return String.valueOf(pivotElement.eClass().getName()) + " <b>" + description + "</b>";
        }
        String firstLine = super.getFirstLine(eObject);
        return String.valueOf(firstLine) + "\n<br>" + eObject.eClass().getName();
    }

    public static Namespace getNamespace(EObject element) {
        int count = 0;
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Namespace && count++ >= 2) {
                return (Namespace)eObject;
            }
            if (eObject instanceof Type) {
                ++count;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    protected boolean hasHover(EObject o) {
        if (o instanceof Element) {
            return true;
        }
        if (o instanceof ElementCS) {
            return true;
        }
        return super.hasHover(o);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return super.getHoverControlCreator();
    }

    public IEObjectHoverProvider.IInformationControlCreatorProvider getHoverInfo(final EObject object, final ITextViewer viewer, final IRegion region) {
        return new IEObjectHoverProvider.IInformationControlCreatorProvider(){

            public IInformationControlCreator getHoverControlCreator() {
                return MarkupHoverProvider.this.getHoverControlCreator();
            }

            public Object getInfo() {
                return MarkupHoverProvider.this.getHoverInfo(object, viewer, region, null);
            }
        };
    }

    protected XtextBrowserInformationControlInput getHoverInfo(EObject element, ITextViewer viewer, IRegion hoverRegion, XtextBrowserInformationControlInput previous) {
        return super.getHoverInfo(element, hoverRegion, previous);
    }
}

