/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.markup;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.xtext.markupcs.BulletElement;
import org.eclipse.ocl.xtext.markupcs.CompoundElement;
import org.eclipse.ocl.xtext.markupcs.FigureElement;
import org.eclipse.ocl.xtext.markupcs.FigureRefElement;
import org.eclipse.ocl.xtext.markupcs.FontElement;
import org.eclipse.ocl.xtext.markupcs.HeadingElement;
import org.eclipse.ocl.xtext.markupcs.MarkupElement;
import org.eclipse.ocl.xtext.markupcs.NewLineElement;
import org.eclipse.ocl.xtext.markupcs.TextElement;
import org.eclipse.ocl.xtext.markupcs.util.MarkupSwitch;

public class MarkupToTree
extends MarkupSwitch<StringBuilder> {
    @NonNull
    protected final StringBuilder s = new StringBuilder();
    private int depth = 0;

    @NonNull
    public static String toString(@NonNull MarkupElement element) {
        MarkupToTree toString = new MarkupToTree();
        String result = ((StringBuilder)toString.doSwitch(element)).toString();
        assert (result != null);
        return result;
    }

    protected void appendClass(@NonNull EObject object) {
        int i = 0;
        while (i < this.depth) {
            this.s.append("  ");
            ++i;
        }
        this.s.append(object.eClass().getName());
        this.s.append(": ");
    }

    protected void appendIndented(@NonNull MarkupElement object) {
        this.s.append("\n");
        ++this.depth;
        this.doSwitch(object);
        --this.depth;
    }

    protected void appendIndented(@NonNull Iterable<MarkupElement> objects) {
        this.s.append("\n");
        ++this.depth;
        for (MarkupElement element : objects) {
            this.doSwitch(element);
        }
        --this.depth;
    }

    @Override
    public StringBuilder caseBulletElement(BulletElement object) {
        assert (object != null);
        this.appendClass(object);
        this.s.append(" ");
        this.s.append(object.getLevel());
        EList<MarkupElement> elements = object.getElements();
        assert (elements != null);
        this.appendIndented((Iterable<MarkupElement>)elements);
        return this.s;
    }

    @Override
    public StringBuilder caseCompoundElement(CompoundElement object) {
        assert (object != null);
        this.appendClass(object);
        EList<MarkupElement> elements = object.getElements();
        assert (elements != null);
        this.appendIndented((Iterable<MarkupElement>)elements);
        return this.s;
    }

    @Override
    public StringBuilder caseFigureElement(FigureElement object) {
        assert (object != null);
        this.appendClass(object);
        this.s.append(" ");
        this.s.append(object.getSrc());
        this.s.append(" ");
        this.s.append(object.getAlt());
        this.s.append(" ");
        this.s.append(object.getRequiredWidth());
        this.s.append(" ");
        this.s.append(object.getRequiredHeight());
        this.s.append("\n");
        return this.s;
    }

    @Override
    public StringBuilder caseFigureRefElement(FigureRefElement object) {
        assert (object != null);
        this.appendClass(object);
        this.s.append(" ");
        this.s.append(object.getRef().getDef());
        this.s.append("\n");
        return this.s;
    }

    @Override
    public StringBuilder caseFontElement(FontElement object) {
        assert (object != null);
        String font = object.getFont();
        this.appendClass(object);
        this.s.append(font);
        EList<MarkupElement> elements = object.getElements();
        assert (elements != null);
        this.appendIndented((Iterable<MarkupElement>)elements);
        return this.s;
    }

    @Override
    public StringBuilder caseHeadingElement(HeadingElement object) {
        assert (object != null);
        this.appendClass(object);
        this.s.append(" ");
        this.s.append(object.getLevel());
        EList<MarkupElement> elements = object.getElements();
        assert (elements != null);
        this.appendIndented((Iterable<MarkupElement>)elements);
        return this.s;
    }

    @Override
    public StringBuilder caseNewLineElement(NewLineElement object) {
        assert (object != null);
        this.appendClass(object);
        this.s.append(object.getText().replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t"));
        this.s.append("\n");
        return this.s;
    }

    @Override
    public StringBuilder caseTextElement(TextElement object) {
        assert (object != null);
        this.appendClass(object);
        for (String text : object.getText()) {
            this.s.append(text.replace("\t", "\\t"));
        }
        this.s.append("\n");
        return this.s;
    }

    @Override
    public StringBuilder defaultCase(EObject object) {
        assert (object != null);
        this.appendClass(object);
        this.s.append("\n");
        return this.s;
    }

    public String toString() {
        return this.s.toString();
    }
}

