/*******************************************************************************
 * Copyright (c) 2013, 2014 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
/*
 * generated by Xtext
 */
package org.eclipse.ocl.xtext.oclstdlib.scoping;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.xtext.base.scoping.AbstractJavaClassScope;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.essentialocl.scoping.EssentialOCLScopeProvider;
import org.eclipse.ocl.xtext.oclstdlibcs.OCLstdlibCSPackage;
import org.eclipse.xtext.scoping.IScope;

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation/latest/xtext.html#scoping
 * on how and when to use it 
 *
 */
public class OCLstdlibScopeProvider extends EssentialOCLScopeProvider
{
	@Override
	public IScope getScope(EObject context, EReference reference) {
		if (context == null) {
			return IScope.NULLSCOPE;
		}
		Resource csResource = context.eResource();
		if (csResource == null) {
			return IScope.NULLSCOPE;
		}
		EClass eReferenceType = reference.getEReferenceType();
		if (eReferenceType == OCLstdlibCSPackage.Literals.JAVA_CLASS_CS) {
			if (csResource instanceof BaseCSResource) {
				AbstractJavaClassScope adapter = JavaClassScope.findAdapter((BaseCSResource)csResource);
				if (adapter == null) {
					// Should already be there so this fall-back classLoader is not used.
					@SuppressWarnings("null")@NonNull ClassLoader classLoader = csResource.getClass().getClassLoader();
					adapter = JavaClassScope.getAdapter((BaseCSResource)csResource, classLoader);
				}
				return adapter;
			}
			return IScope.NULLSCOPE;
		}
		return super.getScope(context, reference);
	}
}
