/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import lpg.runtime.ParseErrorCodes;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.ProblemHandler;

public abstract class AbstractProblemHandler
implements ProblemHandler,
ParseErrorCodes {
    private AbstractParser parser;
    private int errorReportLineOffset = 0;

    protected AbstractProblemHandler(AbstractParser parser) {
        this.parser = parser;
    }

    protected void addProblem(String message) {
        System.out.println(message);
    }

    public void analyzerProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        this.handleProblem(problemSeverity, ProblemHandler.Phase.ANALYZER, problemMessage, processingContext, startOffset, endOffset);
    }

    public void beginParse() {
    }

    public void endParse() {
    }

    public void beginValidation() {
    }

    public void endValidation() {
    }

    public void flush(Monitor monitor) {
    }

    public void setParser(AbstractParser parser) {
        this.parser = parser;
    }

    public AbstractParser getParser() {
        return this.parser;
    }

    public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
        int lineNumber = this.parser.getIPrsStream().getTokenAtCharacter(startOffset).getLine();
        String message = OCLMessages.bind(OCLMessages.ProblemMessage_ERROR_, new Object[]{processingPhase != null ? processingPhase : "?", problemSeverity != null ? problemSeverity : "?", processingContext != null ? processingContext : "?", lineNumber, problemMessage != null ? problemMessage : "?"});
        this.addProblem(message);
    }

    public void lexerProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        this.handleProblem(problemSeverity, ProblemHandler.Phase.LEXER, problemMessage, processingContext, startOffset, endOffset);
    }

    public void parserProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        this.handleProblem(problemSeverity, ProblemHandler.Phase.PARSER, problemMessage, processingContext, startOffset, endOffset);
    }

    public void utilityProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        this.handleProblem(problemSeverity, ProblemHandler.Phase.UTILITY, problemMessage, processingContext, startOffset, endOffset);
    }

    public void validatorProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        this.handleProblem(problemSeverity, ProblemHandler.Phase.VALIDATOR, problemMessage, processingContext, startOffset, endOffset);
    }

    public void setErrorReportLineOffset(int offset) {
        this.errorReportLineOffset = offset;
    }

    public int getErrorReportLineOffset() {
        return this.errorReportLineOffset;
    }
}

