/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.log;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class LogHelper {
    private String pluginId;
    private Plugin activator;
    private boolean tracing;
    private Map<String, Boolean> traceOptions;

    public LogHelper() {
    }

    public LogHelper(Plugin activator) {
        this.setPlugin(activator);
    }

    public void setPlugin(Plugin activator) {
        this.pluginId = activator.getBundle().getSymbolicName();
        this.activator = activator;
        this.tracing = Boolean.valueOf(Platform.getDebugOption((String)String.format("%s/debug", this.pluginId)));
        if (this.tracing) {
            this.traceOptions = new ConcurrentHashMap<String, Boolean>(32, 0.75f, 4);
        }
    }

    public void info(String message) {
        this.log(message, 1);
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.log("[DEBUG] " + message, 1);
        }
    }

    public boolean isDebugEnabled() {
        if (this.activator != null) {
            return Platform.inDebugMode();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTraceEnabled(String option) {
        if (this.tracing) {
            Boolean result;
            String key = String.format("%s/debug/%s", this.pluginId, option);
            Map<String, Boolean> map = this.traceOptions;
            synchronized (map) {
                result = this.traceOptions.get(key);
                if (result == null) {
                    result = Boolean.valueOf(Platform.getDebugOption((String)key));
                    this.traceOptions.put(key, result);
                }
            }
            return result;
        }
        return false;
    }

    public void trace(String option, String message) {
        if (this.isTraceEnabled(option)) {
            System.out.printf("[TRACE:%s] %s%n", option, message);
        }
    }

    private void log(String message, int level) {
        this.log((IStatus)new Status(level, this.pluginId, message));
    }

    public void log(IStatus status) {
        if (this.activator != null) {
            this.activator.getLog().log(status);
        }
    }

    public void warn(String message) {
        this.log(message, 2);
    }

    public void error(Throwable e) {
        this.error("Unexpected Error", e);
    }

    public void error(String message, Throwable e) {
        Throwable t = e;
        if (e instanceof InvocationTargetException) {
            t = ((InvocationTargetException)e).getTargetException();
        }
        Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, this.pluginId, message, e);
        this.log((IStatus)status);
    }

    public String getCallerMethod() {
        StackTraceElement[] stack = new Exception().fillInStackTrace().getStackTrace();
        return stack == null || stack.length < 3 ? "<unknown caller>" : stack[2].toString();
    }
}

