/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.editor;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editor.reload.CompositeReloadContext;
import org.eclipse.papyrus.infra.core.editor.reload.DelegatingReloadContext;
import org.eclipse.papyrus.infra.core.editor.reload.EMFSelectionContext;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IComponentPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;

class MultiDiagramEditorSelectionContext
extends CompositeReloadContext {
    private ISashWindowsContainer sashContainer;
    private final List<URI> resourcesToLoad;

    MultiDiagramEditorSelectionContext(IMultiDiagramEditor editor) {
        this.init(editor);
        this.resourcesToLoad = this.computeResourcesToLoad(editor);
        IPage active = this.sashContainer.getActiveSashWindowsPage();
        DiagramPageContext activePage = null;
        Set visiblePages = Sets.newIdentityHashSet();
        visiblePages.addAll(this.sashContainer.getVisiblePages());
        List<IPage> allPages = this.getAllPages(this.sashContainer);
        for (IPage page : allPages) {
            DiagramPageContext context;
            DelegatingReloadContext delegator;
            DelegatingReloadContext delegatingReloadContext = delegator = page instanceof IEditorPage ? this.add(new DelegatingReloadContext(((IEditorPage)page).getIEditorPart())) : null;
            if (page == active) {
                activePage = context = new DiagramPageContext(new VisiblePageSelectionProvider(page), page, delegator);
                continue;
            }
            context = visiblePages.contains(page) ? new DiagramPageContext(new VisiblePageSelectionProvider(page), page, delegator) : new DiagramPageContext(EmptySelectionProvider.INSTANCE, page, delegator);
            this.add(context);
        }
        if (activePage != null) {
            this.add(activePage);
        }
    }

    @Override
    public void dispose() {
        this.sashContainer = null;
        super.dispose();
    }

    private List<IPage> getAllPages(ISashWindowsContainer container) {
        final ArrayList result = Lists.newArrayList();
        container.visit(new IPageVisitor(){

            public void accept(IEditorPage page) {
                result.add(page);
            }

            public void accept(IComponentPage page) {
                result.add(page);
            }
        });
        return result;
    }

    private void init(IMultiDiagramEditor editor) {
        this.sashContainer = AdapterUtils.adapt(editor, ISashWindowsContainer.class, null);
    }

    void restore(IMultiDiagramEditor editor) {
        this.init(editor);
        this.reloadResources(editor);
        VisiblePageSelectionProvider selectionProvider = new VisiblePageSelectionProvider();
        for (DiagramPageContext next : this.getReloadContexts(DiagramPageContext.class)) {
            next.restore(selectionProvider);
        }
    }

    protected List<URI> computeResourcesToLoad(IMultiDiagramEditor editor) {
        ArrayList result = null;
        ResourceSet rset = this.getResourceSet(editor);
        if (rset != null) {
            result = Lists.newArrayListWithCapacity((int)rset.getResources().size());
            for (Resource next : rset.getResources()) {
                if (!next.isLoaded()) continue;
                result.add(next.getURI());
            }
        }
        return result;
    }

    protected void reloadResources(IMultiDiagramEditor editor) {
        ResourceSet rset;
        if (this.resourcesToLoad != null && (rset = this.getResourceSet(editor)) != null) {
            for (URI next : this.resourcesToLoad) {
                try {
                    rset.getResource(next, true);
                }
                catch (Exception e) {
                    Activator.log.error("Failed to restore loaded resource: " + next, (Throwable)e);
                }
            }
        }
    }

    protected final ResourceSet getResourceSet(IMultiDiagramEditor editor) {
        ResourceSet result = null;
        EditingDomain editingDomain = (EditingDomain)editor.getAdapter(EditingDomain.class);
        if (editingDomain != null) {
            result = editingDomain.getResourceSet();
        }
        return result;
    }

    private class DiagramPageContext
    extends EMFSelectionContext {
        private URI pageRef;
        private DelegatingReloadContext pageContext;

        DiagramPageContext(ISelectionProvider structuredSelectionProvider, IPage page, DelegatingReloadContext pageContext) {
            super(structuredSelectionProvider);
            this.pageContext = pageContext;
            this.pageRef = this.getToken(page.getRawModel());
        }

        @Override
        public void restore(ISelectionProvider structuredSelectionProvider) {
            IPage page = MultiDiagramEditorSelectionContext.this.sashContainer.lookupModelPage(this.resolveToken(this.pageRef));
            if (this.pageContext != null && page instanceof IEditorPage) {
                this.pageContext.restore(((IEditorPage)page).getIEditorPart());
            }
            super.restore(structuredSelectionProvider);
        }

        @Override
        protected Object deresolveSelectableElement(Object selectableElement) {
            return selectableElement instanceof IPage ? ((IPage)selectableElement).getRawModel() : super.deresolveSelectableElement(selectableElement);
        }

        @Override
        protected Object resolveSelectableElement(Object deresolved) {
            return MultiDiagramEditorSelectionContext.this.sashContainer.lookupModelPage(deresolved);
        }
    }

    private static class EmptySelectionProvider
    implements ISelectionProvider {
        static final EmptySelectionProvider INSTANCE = new EmptySelectionProvider();

        EmptySelectionProvider() {
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void setSelection(ISelection selection) {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }
    }

    private class VisiblePageSelectionProvider
    implements ISelectionProvider {
        private final IStructuredSelection selection;

        VisiblePageSelectionProvider() {
            this(null);
        }

        VisiblePageSelectionProvider(IPage visible) {
            this.selection = visible == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)visible);
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void setSelection(ISelection selection) {
            if (!selection.isEmpty()) {
                IPage page = (IPage)((IStructuredSelection)selection).getFirstElement();
                MultiDiagramEditorSelectionContext.this.sashContainer.selectPage(page);
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }
    }
}

