/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.editor;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.papyrus.infra.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editor.IReloadableEditor;
import org.eclipse.papyrus.infra.core.editor.reload.EditorReloadEvent;
import org.eclipse.papyrus.infra.core.editor.reload.IEditorReloadListener;
import org.eclipse.papyrus.infra.core.operation.DelegatingUndoContext;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.properties.PropertyShowInContext;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

class MultiDiagramPropertySheetPage
extends TabbedPropertySheetPage
implements IEditorReloadListener {
    private final CoreMultiDiagramEditor multiDiagramEditor;
    private UndoActionHandler undo;
    private RedoActionHandler redo;
    private DelegatingUndoContext undoContext;

    public MultiDiagramPropertySheetPage(CoreMultiDiagramEditor editor) {
        super((ITabbedPropertySheetPageContributor)editor);
        this.multiDiagramEditor = editor;
        IReloadableEditor.Adapter.getAdapter(editor).addEditorReloadListener(this);
    }

    public void dispose() {
        IReloadableEditor.Adapter.getAdapter(this.multiDiagramEditor).removeEditorReloadListener(this);
        if (this.undo != null) {
            this.undo.dispose();
        }
        if (this.redo != null) {
            this.redo.dispose();
        }
        super.dispose();
    }

    @Override
    public void editorAboutToReload(EditorReloadEvent event) {
        IWorkbenchPart inputPart;
        ShowInContext context;
        Object propertySheet = this.getSite().getService(IViewPart.class);
        if (propertySheet instanceof IShowInSource && (context = ((IShowInSource)propertySheet).getShowInContext()) instanceof PropertyShowInContext && (inputPart = ((PropertyShowInContext)context).getPart()) != null) {
            event.putContext(inputPart);
        }
    }

    @Override
    public void editorReloaded(EditorReloadEvent event) {
        Object propertySheet;
        final IWorkbenchPart inputPart = (IWorkbenchPart)event.getContext();
        if (inputPart != null && (propertySheet = this.getSite().getService(IViewPart.class)) instanceof IPartListener) {
            ((IPartListener)propertySheet).partActivated(inputPart);
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ISelectionProvider selectionProvider = inputPart.getSite().getSelectionProvider();
                    if (selectionProvider != null) {
                        ((ISelectionListener)propertySheet).selectionChanged(inputPart, selectionProvider.getSelection());
                    }
                }
            });
        }
        if (this.undoContext != null) {
            this.undoContext.setDelegate(AdapterUtils.adapt(this.multiDiagramEditor, IUndoContext.class, null));
        }
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        this.undoContext = new DelegatingUndoContext();
        this.undoContext.setDelegate(AdapterUtils.adapt(this.multiDiagramEditor, IUndoContext.class, null));
        this.undo = new UndoActionHandler(this.multiDiagramEditor.getSite(), (IUndoContext)this.undoContext);
        this.redo = new RedoActionHandler(this.multiDiagramEditor.getSite(), (IUndoContext)this.undoContext);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redo);
    }
}

