/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.language;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.language.ILanguage;
import org.eclipse.papyrus.infra.core.language.ILanguageProvider;
import org.eclipse.papyrus.infra.core.language.ILanguageService;

public class DefaultLanguageProvider
implements ILanguageProvider {
    private final Set<IContentType> contentTypes = Sets.newHashSet();
    private final List<ILanguage> languages = Lists.newArrayList();
    private List<LanguageProxy> languageProxies;

    @Override
    public synchronized Iterable<ILanguage> getLanguages(ILanguageService languageService, URI modelURI, boolean uriHasFileExtension) {
        Set<URI> allURIs;
        try {
            allURIs = this.resolveURIs(modelURI, uriHasFileExtension);
        }
        catch (CoreException e) {
            Activator.log.log(e.getStatus());
            return Collections.emptyList();
        }
        if (!this.matchContentType(allURIs)) {
            return Collections.emptyList();
        }
        this.resolveProxies();
        return Collections.unmodifiableList(this.languages);
    }

    void addContentType(String id) {
        IContentType contentType = Platform.getContentTypeManager().getContentType(id);
        if (contentType == null) {
            Activator.log.warn("No such content-type in language provider extension: " + id);
        } else {
            this.contentTypes.add(contentType);
        }
    }

    synchronized void addLanguage(ILanguage language) {
        this.languages.add(language);
    }

    synchronized void addLanguage(IConfigurationElement config, String attribute) {
        if (this.languageProxies == null) {
            this.languageProxies = Lists.newArrayList();
        }
        this.languageProxies.add(new LanguageProxy(config, attribute));
    }

    private void resolveProxies() {
        if (this.languageProxies != null) {
            try {
                for (LanguageProxy next : this.languageProxies) {
                    ILanguage resolved = next.resolve();
                    if (resolved == null) continue;
                    this.addLanguage(resolved);
                }
            }
            finally {
                this.languageProxies = null;
            }
        }
    }

    private Set<URI> resolveURIs(URI modelURI, boolean uriHasFileExtension) throws CoreException {
        HashSet result;
        block6: {
            block5: {
                if (uriHasFileExtension) {
                    return Collections.singleton(modelURI);
                }
                result = Sets.newHashSet();
                if (!modelURI.isPlatformResource()) break block5;
                String baseName = modelURI.lastSegment();
                Path path = new Path(modelURI.trimSegments(1).toPlatformString(true));
                IFolder container = path.segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path) : ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath nextPath;
                    String name;
                    IResource next = iResourceArray[n2];
                    if (next.getType() == 1 && (name = (nextPath = next.getFullPath()).removeFileExtension().lastSegment()).equals(baseName)) {
                        result.add(URI.createPlatformResourceURI((String)nextPath.toString(), (boolean)true));
                    }
                    ++n2;
                }
                break block6;
            }
            if (!modelURI.isFile()) break block6;
            String baseName = modelURI.lastSegment();
            File directory = new File(modelURI.trimSegments(1).toFileString());
            File[] fileArray = directory.listFiles();
            int n = fileArray.length;
            int n3 = 0;
            while (n3 < n) {
                IPath nextPath;
                String name;
                File next = fileArray[n3];
                if (next.isFile() && (name = (nextPath = new Path(directory.getPath()).append(next.getName())).removeFileExtension().lastSegment()).equals(baseName)) {
                    result.add(URI.createPlatformResourceURI((String)nextPath.toString(), (boolean)true));
                }
                ++n3;
            }
        }
        return result;
    }

    private boolean matchContentType(Set<URI> uris) {
        boolean result = false;
        block2: for (URI next : uris) {
            try {
                IContentType contentType;
                Map desc = URIConverter.INSTANCE.contentDescription(next, null);
                String contentTypeID = (String)desc.get("org.eclipse.emf.ecore:contentType");
                if (contentTypeID == null || (contentType = Platform.getContentTypeManager().getContentType(contentTypeID)) == null) continue;
                for (IContentType type : this.contentTypes) {
                    if (!contentType.isKindOf(type)) continue;
                    result = true;
                    break block2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private static class LanguageProxy {
        private final IConfigurationElement config;
        private final String attribute;

        LanguageProxy(IConfigurationElement config, String attribute) {
            this.config = config;
            this.attribute = attribute;
        }

        ILanguage resolve() {
            try {
                return (ILanguage)this.config.createExecutableExtension(this.attribute);
            }
            catch (Exception e) {
                Activator.log.error("Failed to instantiate language in provider extension from contributor " + this.config.getContributor().getName(), (Throwable)e);
                return null;
            }
        }
    }
}

