/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.language;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.language.ILanguage;
import org.eclipse.papyrus.infra.core.language.ILanguageChangeListener;
import org.eclipse.papyrus.infra.core.language.ILanguageProvider;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.language.LanguageChangeEvent;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;

public class LanguageService
extends PlatformObject
implements ILanguageService,
IService {
    private final CopyOnWriteArrayList<ILanguageProvider> languageProviders = Lists.newCopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ILanguageChangeListener> languageListeners = Lists.newCopyOnWriteArrayList();
    private ServicesRegistry registry;

    @Override
    public Set<ILanguage> getLanguages(URI modelURI, boolean uriHasFileExtension) {
        HashSet result = Sets.newHashSet();
        for (ILanguageProvider next : this.languageProviders) {
            Iterables.addAll((Collection)result, next.getLanguages(this, modelURI, uriHasFileExtension));
        }
        return result;
    }

    @Override
    public void addLanguageChangeListener(ILanguageChangeListener listener) {
        this.languageListeners.addIfAbsent(listener);
    }

    @Override
    public void removeLanguageChangeListener(ILanguageChangeListener listener) {
        this.languageListeners.remove(listener);
    }

    @Override
    public void addLanguageProvider(ILanguageProvider provider) {
        this.languageProviders.addIfAbsent(provider);
    }

    @Override
    public void removeLanguageProvider(ILanguageProvider provider) {
        if (provider != null) {
            this.languageProviders.remove(provider);
        }
    }

    @Override
    public void languagesChanged(LanguageChangeEvent event) {
        if (!this.languageListeners.isEmpty()) {
            event = new LanguageChangeEvent(this, event.getType(), event.getModelURI(), event.getURIHasExtension(), event.getLanguages());
            for (ILanguageChangeListener next : this.languageListeners) {
                try {
                    next.languagesChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in language change listener", (Throwable)e);
                }
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object result = adapter.isInstance(this.registry) ? adapter.cast(this.registry) : (this.registry == null ? null : ServiceUtils.getInstance().getService(adapter, this.registry, null));
        return (T)(result != null ? result : super.getAdapter(adapter));
    }

    @Override
    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    @Override
    public void startService() throws ServiceException {
        this.languageProviders.addAllAbsent(ILanguageProvider.Registry.INSTANCE.getProviders());
    }

    @Override
    public void disposeService() throws ServiceException {
        this.languageProviders.clear();
        this.languageListeners.clear();
        this.registry = null;
    }
}

