/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource.additional;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.papyrus.infra.core.resource.AbstractModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;

public class AdditionalResourcesModel
extends AbstractModel
implements IModel {
    public static String MODEL_ID = "org.eclipse.papyrus.infra.core.resource.additional";

    @Override
    public String getIdentifier() {
        return MODEL_ID;
    }

    @Override
    @Deprecated
    public void createModel(IPath fullPath) {
    }

    @Override
    public void createModel(URI uri) {
    }

    @Override
    @Deprecated
    public void loadModel(IPath path) {
        this.snippets.performStart(this);
    }

    @Override
    public void loadModel(URI uri) {
        this.snippets.performStart(this);
    }

    @Override
    @Deprecated
    public void importModel(IPath fullPathWithoutExtension) {
        this.loadModel(fullPathWithoutExtension);
    }

    @Override
    public void importModel(URI uriWithoutExtension) {
        this.loadModel(uriWithoutExtension);
    }

    @Override
    public void saveModel() throws IOException {
        for (Resource r : this.modelSet.getResources()) {
            if (!AdditionalResourcesModel.isAdditionalResource(this.getModelManager(), r.getURI()) || !this.modelSet.shouldSave(r) || !this.modelSet.isUserModelResource(r.getURI())) continue;
            if (r instanceof XMIResource) {
                r.save(Collections.singletonMap("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware()));
                continue;
            }
            r.save(Collections.EMPTY_MAP);
        }
    }

    @Override
    @Deprecated
    public void changeModelPath(IPath fullPath) {
    }

    @Override
    public void setModelURI(URI uri) {
    }

    @Override
    public void unload() {
        this.snippets.performDispose(this);
        int i = 0;
        while (i < this.modelSet.getResources().size()) {
            Resource next = (Resource)this.modelSet.getResources().get(i);
            if (AdditionalResourcesModel.isAdditionalResource(this.getModelManager(), next.getURI())) {
                next.unload();
            }
            ++i;
        }
    }

    public static boolean isAdditionalResource(ModelSet modelSet, URI uri) {
        if (uri != null) {
            URI uriWithoutExt = uri.trimFileExtension();
            return !modelSet.getURIWithoutExtension().equals(uriWithoutExt);
        }
        return false;
    }

    @Override
    public Set<URI> getModifiedURIs() {
        HashSet<URI> res = new HashSet<URI>();
        for (Resource r : this.modelSet.getResources()) {
            if (!AdditionalResourcesModel.isAdditionalResource(this.getModelManager(), r.getURI()) || r.isTrackingModification() && !r.isModified()) continue;
            res.add(r.getURI());
        }
        return res;
    }

    @Override
    public void cleanModel(Set<URI> resourcesToDelete) {
        if (!resourcesToDelete.isEmpty()) {
            Iterator modelResourcesIterator = this.modelSet.getResources().iterator();
            ArrayList<Resource> referencedDeletedResources = new ArrayList<Resource>();
            while (modelResourcesIterator.hasNext()) {
                Resource currentResource = (Resource)modelResourcesIterator.next();
                if (!resourcesToDelete.contains(currentResource.getURI())) continue;
                referencedDeletedResources.add(currentResource);
            }
            if (!referencedDeletedResources.isEmpty()) {
                this.modelSet.getResources().removeAll(referencedDeletedResources);
            }
        }
    }
}

