/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource.sasheditor;

import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.AbstractModelWithSharedResource;
import org.eclipse.papyrus.infra.core.resource.IEMFModel;
import org.eclipse.papyrus.infra.core.resource.IModel;

public class DiModel
extends AbstractModelWithSharedResource<EObject>
implements IModel {
    public static final String MODEL_FILE_EXTENSION = "di";
    public static final String DI_FILE_EXTENSION = "di";
    @Deprecated
    public static final String MODEL_ID = "org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel";
    public static final String DI_MODEL_ID = "org.eclipse.papyrus.infra.core.resource.DiModel";
    private boolean checkingControlState = false;

    public DiModel() {
        super(AbstractModelWithSharedResource.ModelKind.master);
    }

    @Override
    protected String getModelFileExtension() {
        return "di";
    }

    @Override
    public String getIdentifier() {
        return DI_MODEL_ID;
    }

    @Override
    public void loadModel(URI uriWithoutExtension) {
        if (this.exists(uriWithoutExtension)) {
            try {
                super.loadModel(uriWithoutExtension);
            }
            catch (Exception ex) {
                this.createModel(uriWithoutExtension);
            }
        }
        if (this.resource == null) {
            this.createModel(uriWithoutExtension);
        }
    }

    @Override
    protected Map<Object, Object> getSaveOptions() {
        Map<Object, Object> saveOptions = super.getSaveOptions();
        saveOptions.put("USE_XMI_TYPE", Boolean.FALSE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.FALSE);
        return saveOptions;
    }

    @Override
    protected boolean isModelRoot(EObject object) {
        return false;
    }

    @Override
    public void setModelURI(URI uriWithoutExtension) {
        for (Resource resource : this.getResources()) {
            if (!this.isControlled(resource)) continue;
            URI newBaseUri = uriWithoutExtension.trimSegments(1).appendSegment(resource.getURI().lastSegment());
            resource.setURI(newBaseUri);
        }
        super.setModelURI(uriWithoutExtension);
    }

    @Override
    public void handle(Resource resource) {
        super.handle(resource);
        if (resource == null) {
            return;
        }
        if (!this.isRelatedResource(resource)) {
            URIConverter converter;
            URI diUri = resource.getURI().trimFileExtension().appendFileExtension("di");
            ResourceSet resourceSet = this.getResourceSet();
            boolean diAlreadyLoaded = false;
            for (Resource loadedResource : resourceSet.getResources()) {
                if (!loadedResource.getURI().equals(diUri)) continue;
                diAlreadyLoaded = true;
                break;
            }
            if (!diAlreadyLoaded && resourceSet.getURIConverter() != null && (converter = resourceSet.getURIConverter()).exists(diUri, Collections.emptyMap())) {
                try {
                    resourceSet.getResource(diUri, true);
                }
                catch (Exception ex) {
                    Activator.log.error((Throwable)ex);
                }
            }
        }
    }

    @Override
    public boolean isControlled(Resource resource) {
        if (this.checkingControlState) {
            return false;
        }
        try {
            this.checkingControlState = true;
            for (Resource resourceInModelSet : this.modelSet.getResources()) {
                EObject eObject;
                IModel iModel;
                if (!resource.getURI().trimFileExtension().equals(resourceInModelSet.getURI().trimFileExtension()) || this.isRelatedResource(resourceInModelSet) || resourceInModelSet.getContents().isEmpty() || !((iModel = this.modelSet.getModelFor(eObject = (EObject)resourceInModelSet.getContents().get(0))) instanceof IEMFModel) || !((IEMFModel)iModel).isControlled(resourceInModelSet)) continue;
                return true;
            }
        }
        finally {
            this.checkingControlState = false;
        }
        return false;
    }
}

