/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource.sasheditor;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.EMFLogicalModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelProviderManager;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;

public class SashModel
extends EMFLogicalModel
implements IModel {
    private SashModelProviderManager providerManager;
    @Deprecated
    public static final String MODEL_FILE_EXTENSION = "di";
    public static final String SASH_MODEL_FILE_EXTENSION = "sash";
    public static final String MODEL_ID = "org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel";

    @Override
    protected String getModelFileExtension() {
        if (this.isLegacy(this.resourceURI == null ? this.resourceURI : this.resourceURI.trimFileExtension())) {
            return MODEL_FILE_EXTENSION;
        }
        return SASH_MODEL_FILE_EXTENSION;
    }

    @Override
    public void init(ModelSet modelSet) {
        super.init(modelSet);
        this.providerManager = new SashModelProviderManager(modelSet);
    }

    @Override
    public void unload() {
        if (this.providerManager != null) {
            this.providerManager.dispose();
            this.providerManager = null;
        }
        super.unload();
    }

    @Override
    protected boolean isRelatedResource(Resource resource) {
        return resource != null && this.resource == resource;
    }

    @Override
    public String getIdentifier() {
        return MODEL_ID;
    }

    @Override
    public void loadModel(URI uriWithoutExtension) {
        URI sashModelURI;
        this.resourceURI = sashModelURI = this.getSashModelURI(uriWithoutExtension);
        try {
            super.loadModel(sashModelURI.trimFileExtension());
        }
        catch (Exception ex) {
            this.createModel(sashModelURI.trimFileExtension());
        }
        if (this.resource == null) {
            this.createModel(sashModelURI.trimFileExtension());
        }
    }

    @Override
    public void createModel(URI uriWithoutExtension) {
        if (this.isLegacy(uriWithoutExtension)) {
            super.createModel(this.getSashModelStoreURI(uriWithoutExtension).trimFileExtension());
        } else {
            super.createModel(uriWithoutExtension);
        }
    }

    @Override
    public void setModelURI(URI uriWithoutExtension) {
        URI newURI = this.resourceURI != null && this.isLegacy(this.resourceURI.trimFileExtension()) ? this.getLegacyURI(uriWithoutExtension) : this.getSashModelStoreURI(uriWithoutExtension);
        super.setModelURI(newURI.trimFileExtension());
    }

    protected boolean isLegacy(URI uriWithoutExtension) {
        if (uriWithoutExtension == null) {
            return false;
        }
        return Objects.equal((Object)uriWithoutExtension, (Object)this.getModelManager().getURIWithoutExtension());
    }

    protected URI getSashModelURI(URI uriWithoutExtension) {
        URI legacyURI;
        URIConverter converter = this.getModelManager().getURIConverter();
        if (converter.exists(legacyURI = this.getLegacyURI(uriWithoutExtension), Collections.emptyMap())) {
            try {
                Resource diResource = this.getModelManager().getResource(legacyURI, true);
                if (DiUtils.lookupSashWindowsMngr((Resource)diResource) != null) {
                    return legacyURI;
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        URI preferenceStoreURI = this.getSashModelStoreURI(uriWithoutExtension);
        return preferenceStoreURI;
    }

    protected URI getLegacyURI(URI uriWithoutExtension) {
        return uriWithoutExtension.appendFileExtension(MODEL_FILE_EXTENSION);
    }

    protected URI getSashModelStoreURI(URI uriWithoutExtension) {
        URI fullURI = uriWithoutExtension.appendFileExtension(SASH_MODEL_FILE_EXTENSION);
        return this.providerManager.getSashModelProvider(fullURI).getSashModelURI(fullURI);
    }

    @Override
    protected Map<Object, Object> getSaveOptions() {
        Map<Object, Object> saveOptions = super.getSaveOptions();
        saveOptions.put("USE_XMI_TYPE", Boolean.FALSE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.FALSE);
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return saveOptions;
    }
}

