/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public abstract class JobBasedFuture<V>
extends Job
implements ListenableFuture<V> {
    private static final ScheduledThreadPoolExecutor TIMEOUT_EXECUTOR = new ScheduledThreadPoolExecutor(1);
    private final CountDownLatch started = new CountDownLatch(1);
    private final ILock runningLock = Job.getJobManager().newLock();
    private final ISchedulingRule rule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private final AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
    private volatile Throwable exception;
    private final ExecutionList executions = new ExecutionList();
    private volatile V value;

    static {
        TIMEOUT_EXECUTOR.setKeepAliveTime(10L, TimeUnit.SECONDS);
        TIMEOUT_EXECUTOR.allowCoreThreadTimeOut(true);
    }

    public JobBasedFuture(String name) {
        super(name);
        this.setSystem(true);
        this.setRule(this.rule);
    }

    final boolean transition(State from, State to) {
        return this.state.compareAndSet(from, to);
    }

    final State state() {
        return this.state.get();
    }

    final boolean isInState(State state) {
        return this.state.get() == state;
    }

    /*
     * Exception decompiling
     */
    protected final IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract V compute(IProgressMonitor var1) throws Exception;

    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = this.transition(State.RUNNING, State.CANCELLED);
        if (result) {
            try {
                this.cancel();
            }
            finally {
                this.executions.execute();
            }
        }
        return result;
    }

    boolean fail(Throwable t) {
        boolean result = this.transition(State.RUNNING, State.FAILED);
        if (result) {
            this.exception = t;
            this.executions.execute();
        }
        return result;
    }

    public boolean isCancelled() {
        return this.isInState(State.CANCELLED);
    }

    public boolean isDone() {
        return !this.isInState(State.RUNNING);
    }

    public V get() throws InterruptedException, ExecutionException {
        this.awaitDone(0L);
        return this.getValue();
    }

    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.awaitDone(unit.toMillis(timeout))) {
            throw new TimeoutException();
        }
        return this.getValue();
    }

    final boolean awaitDone(long timeoutMillis) throws InterruptedException {
        boolean result = this.isDone();
        if (!result) {
            Job current = Job.getJobManager().currentJob();
            result = current == null || current.getRule() == null ? this.uiSafeAwaitDone(timeoutMillis) : this.lockBasedAwaitDone(timeoutMillis);
        }
        return result;
    }

    private boolean lockBasedAwaitDone(long timeoutMillis) throws InterruptedException {
        long remaining;
        boolean result = false;
        if (timeoutMillis <= 0L) {
            this.started.await();
            this.runningLock.acquire();
            try {
                result = this.isDone();
            }
            finally {
                this.runningLock.release();
            }
        }
        long startedWaiting = System.currentTimeMillis();
        if (this.started.await(timeoutMillis, TimeUnit.MILLISECONDS) && (remaining = timeoutMillis - (System.currentTimeMillis() - startedWaiting)) > 0L && this.runningLock.acquire(remaining)) {
            try {
                result = this.isDone();
            }
            finally {
                this.runningLock.release();
            }
        }
        return result;
    }

    private boolean uiSafeAwaitDone(long timeoutMillis) throws InterruptedException {
        boolean result = false;
        if (timeoutMillis <= 0L) {
            this.started.await();
            try {
                Job.getJobManager().beginRule(this.rule, null);
                result = this.isDone();
            }
            finally {
                Job.getJobManager().endRule(this.rule);
            }
        }
        long startedWaiting = System.currentTimeMillis();
        if (this.started.await(timeoutMillis, TimeUnit.MILLISECONDS)) {
            long remaining = timeoutMillis - (System.currentTimeMillis() - startedWaiting);
            TimeoutMonitor monitor = new TimeoutMonitor();
            ScheduledFuture<?> timeout = TIMEOUT_EXECUTOR.schedule(new Runnable((IProgressMonitor)monitor){
                private final /* synthetic */ IProgressMonitor val$monitor;
                {
                    this.val$monitor = iProgressMonitor;
                }

                @Override
                public void run() {
                    this.val$monitor.setCanceled(true);
                }
            }, remaining, TimeUnit.MILLISECONDS);
            try {
                try {
                    Job.getJobManager().beginRule(this.rule, (IProgressMonitor)monitor);
                    timeout.cancel(false);
                    result = this.isDone();
                }
                finally {
                    Job.getJobManager().endRule(this.rule);
                    Thread.interrupted();
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                // empty catch block
            }
        }
        return result;
    }

    final boolean setValue(V value) {
        boolean result = this.transition(State.RUNNING, State.DONE);
        if (result) {
            this.value = value;
            this.executions.execute();
        }
        return result;
    }

    final V getValue() throws ExecutionException {
        V result = null;
        State state = this.state();
        switch (state) {
            case CANCELLED: {
                throw new CancellationException(String.format("Job \"%s\" was cancelled", this.getName()));
            }
            case FAILED: {
                throw new ExecutionException(this.exception);
            }
            case DONE: {
                result = this.value;
                break;
            }
            default: {
                throw new IllegalStateException(state.name());
            }
        }
        return result;
    }

    public void addListener(Runnable listener, Executor executor) {
        this.executions.add(listener, executor);
    }

    private static enum State {
        RUNNING,
        CANCELLED,
        FAILED,
        DONE;

    }

    private static class TimeoutMonitor
    extends ProgressMonitorWrapper {
        private Thread thread = Thread.currentThread();

        TimeoutMonitor() {
            super((IProgressMonitor)new NullProgressMonitor());
        }

        public void setCanceled(boolean b) {
            boolean wasCanceled = this.isCanceled();
            super.setCanceled(b);
            if (!wasCanceled && b) {
                this.thread.interrupt();
            }
        }
    }
}

