/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.Window;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractTreeAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.ITreeItemAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.tree.ITreeItemAxisHelper;

public class EObjectTreeAxisManagerForEventList
extends AbstractTreeAxisManagerForEventList
implements IAxisManagerForEventList,
ITreeItemAxisManagerForEventList {
    public static final boolean DISPLAY_CATEOGORY = true;

    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        ArrayList<EObjectTreeItemAxis> toAdd = new ArrayList<EObjectTreeItemAxis>();
        for (Object object : objectToAdd) {
            if (!this.isAllowedContents(object, null, null, 0) || this.isAlreadyManaged(object)) continue;
            EObjectTreeItemAxis horizontalAxis = NattableaxisFactory.eINSTANCE.createEObjectTreeItemAxis();
            horizontalAxis.setElement((EObject)object);
            horizontalAxis.setManager(this.representedAxisManager);
            toAdd.add(horizontalAxis);
        }
        if (!toAdd.isEmpty()) {
            return AddCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), toAdd);
        }
        return null;
    }

    public boolean isAllowedContents(Object objectToTest, Object semanticParent, TreeFillingConfiguration conf, int depth) {
        return objectToTest instanceof EObject;
    }

    public boolean isAllowedContents(Object object) {
        return object instanceof EObject;
    }

    protected ITreeItemAxis createITreeItemAxis(ITreeItemAxis parentAxis, Object objectToAdd) {
        return ITreeItemAxisHelper.createITreeItemAxis((TransactionalEditingDomain)this.getTableEditingDomain(), (ITreeItemAxis)parentAxis, (Object)objectToAdd, (AxisManagerRepresentation)this.representedAxisManager);
    }

    protected boolean ignoreEvent(Notification notification) {
        boolean res = super.ignoreEvent(notification);
        if (res) {
            return res;
        }
        Object notifier = notification.getNotifier();
        Object feature = notification.getFeature();
        if (feature == null) {
            return true;
        }
        return notifier instanceof PageRef || notifier instanceof Window;
    }
}

