/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.providers;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.messages.Messages;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.PlatformUI;

public class ResourceFilteredLabelProvider
extends EMFLabelProvider
implements IFilteredLabelProvider {
    private ResourceManager images;

    public boolean accept(Object element) {
        return element instanceof Resource;
    }

    public void dispose() {
        if (this.images != null) {
            this.images.dispose();
            this.images = null;
        }
        super.dispose();
    }

    @Override
    public String getText(Object element) {
        return element instanceof Resource ? this.getText((Resource)element) : super.getText(element);
    }

    protected String getText(Resource resource) {
        String ext;
        URI uri = resource.getURI();
        String result = uri.isPlatformResource() ? ((ext = uri.fileExtension()) == null ? NLS.bind((String)Messages.ResourceFilteredLabelProvider_workspace, (Object)uri.toPlatformString(true)) : NLS.bind((String)Messages.ResourceFilteredLabelProvider_workspaceExt, (Object)uri.toPlatformString(true), (Object)uri.fileExtension())) : (uri.isFile() ? ((ext = uri.fileExtension()) == null ? NLS.bind((String)Messages.ResourceFilteredLabelProvider_local, (Object)uri.toFileString()) : NLS.bind((String)Messages.ResourceFilteredLabelProvider_localExt, (Object)uri.toFileString(), (Object)uri.fileExtension())) : (uri.isHierarchical() ? NLS.bind((String)Messages.ResourceFilteredLabelProvider_system, (Object)uri.lastSegment()) : NLS.bind((String)Messages.ResourceFilteredLabelProvider_systemExt, (Object)uri.toString())));
        return result;
    }

    @Override
    public Image getImage(Object element) {
        return element instanceof Resource ? this.getImage((Resource)element) : super.getImage(element);
    }

    protected Image getImage(Resource resource) {
        URI uri = resource.getURI();
        URIConverter converter = resource.getResourceSet() == null ? URIConverter.INSTANCE : resource.getResourceSet().getURIConverter();
        IContentType contentType = null;
        try {
            Map description = converter.contentDescription(uri, null);
            contentType = description.get("org.eclipse.emf.ecore:contentType") == null ? null : Platform.getContentTypeManager().getContentType((String)description.get("org.eclipse.emf.ecore:contentType"));
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        IEditorDescriptor[] editors = contentType != null ? PlatformUI.getWorkbench().getEditorRegistry().getEditors(uri.lastSegment(), contentType) : PlatformUI.getWorkbench().getEditorRegistry().getEditors(uri.lastSegment());
        ImageDescriptor result = null;
        int i = 0;
        while (result == null && i < editors.length) {
            result = editors[0].getImageDescriptor();
            ++i;
        }
        return this.convert(result);
    }

    protected Image convert(ImageDescriptor descriptor) {
        Image result = null;
        if (descriptor != null) {
            if (this.images == null) {
                this.images = new LocalResourceManager(JFaceResources.getResources());
            }
            result = (Image)this.images.get((DeviceResourceDescriptor)descriptor);
        }
        return result;
    }
}

