/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.providers.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.swt.widgets.TreeItem;

public class ContainmentBrowseStrategy
extends ProviderBasedBrowseStrategy {
    protected IAdaptableContentProvider adaptableProvider;
    protected TreeViewer viewer;

    public ContainmentBrowseStrategy(ITreeContentProvider provider) {
        if (!(provider instanceof IAdaptableContentProvider)) {
            throw new IllegalArgumentException("The provider must be an IAdaptableContentProvider");
        }
        this.setProvider(provider);
        this.adaptableProvider = (IAdaptableContentProvider)this.provider;
    }

    protected boolean browseElement(Object containerElement) {
        Object semanticElement = this.adaptableProvider.getAdaptedValue(containerElement);
        if (semanticElement instanceof EReference) {
            return ((EReference)semanticElement).isContainment() && !((EReference)semanticElement).isDerived();
        }
        return true;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.viewer = (TreeViewer)viewer;
        }
        super.inputChanged(viewer, oldInput, newInput);
    }

    public void revealSemanticElement(List<?> elementList) {
        Iterator<?> elementListIterator = elementList.iterator();
        ArrayList<Object> treeElementToSelect = new ArrayList<Object>();
        while (elementListIterator.hasNext()) {
            Object currentElement = elementListIterator.next();
            if (currentElement instanceof EObject) {
                Object root;
                List<Object> path;
                EObject currentEObject = (EObject)currentElement;
                if (currentEObject.eIsProxy()) continue;
                if (this.provider != null && (path = this.searchPath(currentEObject, Arrays.asList(this.provider.getElements(root = this.provider.getElements(null)[0])))).size() > 0) {
                    this.expandItems(path, this.viewer.getTree().getItems());
                    treeElementToSelect.add(path.get(path.size() - 1));
                }
            }
            this.selectReveal((ISelection)new StructuredSelection(treeElementToSelect));
        }
    }

    public void expandItems(List<Object> treeElementList, TreeItem[] list) {
        this.viewer.getTree().setRedraw(false);
        if (treeElementList.size() > 0) {
            int i = 0;
            while (i < list.length) {
                if (list[i].getData() != null && list[i].getData().equals(treeElementList.get(0))) {
                    if (treeElementList.size() > 1) {
                        Object[] toexpand = new Object[]{treeElementList.get(0)};
                        this.viewer.setExpandedElements(toexpand);
                    }
                    ArrayList<Object> tmpList = new ArrayList<Object>();
                    tmpList.addAll(treeElementList);
                    tmpList.remove(tmpList.get(0));
                    this.expandItems(tmpList, list[i].getItems());
                }
                ++i;
            }
        }
        this.viewer.getTree().setRedraw(true);
    }

    public void selectReveal(ISelection selection) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection, true);
        }
    }

    protected List<Object> searchDirectContainmentPath(EObject eobject, List<Object> wrappedElements) {
        ArrayList<Object> path = new ArrayList<Object>();
        List<EObject> emfPath = EMFHelper.getContainmentPath(eobject);
        for (Object wrappedElement : wrappedElements) {
            List<Object> wrappedChildren;
            List<Object> childPath;
            EObject element = EMFHelper.getEObject(wrappedElement);
            if (eobject.equals(element)) {
                return Collections.singletonList(wrappedElement);
            }
            if (!this.browseElementForDirectContainment(emfPath, element) || (childPath = this.searchDirectContainmentPath(eobject, wrappedChildren = Arrays.asList(this.provider.getChildren(wrappedElement)))).isEmpty()) continue;
            path.add(wrappedElement);
            path.addAll(childPath);
            break;
        }
        return path;
    }

    protected boolean browseElementForDirectContainment(List<EObject> emfPath, EObject element) {
        EReference reference;
        if (emfPath.contains(element)) {
            return true;
        }
        return element instanceof EReference && (reference = (EReference)element).isContainment() && !reference.isDerived();
    }

    protected List<Object> searchPath(EObject eobject, List<Object> objects) {
        List<Object> path = this.searchDirectContainmentPath(eobject, objects);
        if (!path.isEmpty()) {
            return path;
        }
        path = new ArrayList<Object>();
        for (Object o : objects) {
            if (!(o instanceof Diagram) && eobject.equals(EMFHelper.getEObject(o))) {
                path.add(o);
                return path;
            }
            int i = 0;
            while (i < this.provider.getChildren(o).length) {
                Object last;
                EObject lastEObject;
                Object treeItem = this.provider.getChildren(o)[i];
                List<Object> tmppath = new ArrayList();
                EObject element = EMFHelper.getEObject(treeItem);
                if (this.browseElement(element)) {
                    ArrayList<Object> childs = new ArrayList<Object>();
                    childs.add(treeItem);
                    tmppath = this.searchPath(eobject, childs);
                }
                if (tmppath.size() > 0 && eobject.equals(lastEObject = EMFHelper.getEObject(last = tmppath.get(tmppath.size() - 1)))) {
                    path.add(o);
                    path.addAll(tmppath);
                    return path;
                }
                ++i;
            }
        }
        return new ArrayList<Object>();
    }
}

