/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.resource.index;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.utils.JobBasedFuture;
import org.eclipse.papyrus.infra.core.utils.JobExecutorService;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexListener;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndexEvent;
import org.eclipse.papyrus.infra.tools.util.ReferenceCounted;

public class WorkspaceModelIndex<T> {
    private static final int MAX_INDEX_RETRIES = 3;
    private final IndexHandler<? extends T> indexer;
    private final QualifiedName indexKey;
    private final IContentType contentType;
    private final SetMultimap<IProject, IFile> index = HashMultimap.create();
    private final IResourceChangeListener workspaceListener = new WorkspaceListener();
    private final Map<IProject, AbstractIndexJob> activeJobs = Maps.newHashMap();
    private final ContentTypeService contentTypeService;
    private final Set<String> fileExtensions;
    private final JobWrangler jobWrangler;
    private final CopyOnWriteArrayList<IWorkspaceModelIndexListener> listeners = Lists.newCopyOnWriteArrayList();

    public WorkspaceModelIndex(String name, String contentType, IndexHandler<? extends T> indexer) {
        this(name, contentType, indexer, 0);
    }

    public WorkspaceModelIndex(String name, String contentType, IndexHandler<? extends T> indexer, int maxConcurrentJobs) {
        this.indexKey = new QualifiedName("org.eclipse.papyrus.modelindex", name);
        this.contentType = Platform.getContentTypeManager().getContentType(contentType);
        this.indexer = indexer;
        Object[] fileSpecs = this.contentType.getFileSpecs(8);
        this.fileExtensions = fileSpecs != null && fileSpecs.length > 0 ? ImmutableSet.copyOf((Object[])fileSpecs) : null;
        this.contentTypeService = ContentTypeService.getInstance();
        this.jobWrangler = new JobWrangler(maxConcurrentJobs);
        this.startIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceListener);
        Job.getJobManager().cancel((Object)this);
        ContentTypeService.dispose(this.contentTypeService);
        SetMultimap<IProject, IFile> setMultimap = this.index;
        synchronized (setMultimap) {
            for (IFile next : this.index.values()) {
                try {
                    next.setSessionProperty(this.indexKey, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            this.index.clear();
        }
    }

    private void startIndex() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(this.workspaceListener, 1);
        this.index(Arrays.asList(workspace.getRoot().getProjects()));
    }

    void index(Collection<? extends IProject> projects) {
        ArrayList jobs = Lists.newArrayListWithCapacity((int)projects.size());
        for (IProject iProject : projects) {
            jobs.add(new IndexProjectJob(iProject));
        }
        this.schedule(jobs);
    }

    void index(IProject project) {
        this.schedule(new IndexProjectJob(project));
    }

    public <V> ListenableFuture<V> afterIndex(Function<? super Map<IFile, T>, V> function) {
        return Futures.transform(this.getIndex(), function);
    }

    public <V> ListenableFuture<V> afterIndex(final Callable<V> callable) {
        Object result;
        if (Job.getJobManager().find((Object)this).length == 0) {
            try {
                result = Futures.immediateFuture(callable.call());
            }
            catch (Exception e) {
                result = Futures.immediateFailedFuture((Throwable)e);
            }
        } else {
            JobBasedFuture job = new JobBasedFuture<V>(NLS.bind((String)"Wait for model index \"{0}\"", (Object)this.indexKey.getLocalName())){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected V compute(IProgressMonitor monitor) throws Exception {
                    Object result;
                    Job.getJobManager().join((Object)WorkspaceModelIndex.this, monitor);
                    SetMultimap setMultimap = WorkspaceModelIndex.this.index;
                    synchronized (setMultimap) {
                        result = callable.call();
                    }
                    return result;
                }
            };
            job.schedule();
            result = job;
        }
        return result;
    }

    public void afterIndex(final Runnable runnable) {
        this.afterIndex(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    public ListenableFuture<Map<IFile, T>> getIndex() {
        return this.afterIndex(new Callable<Map<IFile, T>>(){

            @Override
            public Map<IFile, T> call() {
                return WorkspaceModelIndex.this.map();
            }
        });
    }

    private Map<IFile, T> map() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (IFile next : this.index.values()) {
            try {
                Object value = next.getSessionProperty(this.indexKey);
                if (value == null) continue;
                result.put((Object)next, value);
            }
            catch (CoreException e) {
                Activator.log.error("Failed to access index data for file " + next.getFullPath(), (Throwable)e);
            }
        }
        return result.build();
    }

    void process(IFile file) throws CoreException {
        IProject project = file.getProject();
        if (this.match(file)) {
            this.add(project, file);
        } else {
            this.remove(project, file);
        }
    }

    boolean match(IFile file) {
        IContentType[] contentTypes;
        boolean result = false;
        if (file.isAccessible() && (this.fileExtensions == null || this.fileExtensions.contains(file.getFileExtension())) && file.isSynchronized(0) && (contentTypes = this.contentTypeService.getContentTypes(file)) != null) {
            int i = 0;
            while (i < contentTypes.length && !result) {
                result = contentTypes[i].isKindOf(this.contentType);
                ++i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(IProject project, IFile file) throws CoreException {
        SetMultimap<IProject, IFile> setMultimap = this.index;
        synchronized (setMultimap) {
            this.index.put((Object)project, (Object)file);
            file.setSessionProperty(this.indexKey, this.indexer.index(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(IProject project, IFile file) throws CoreException {
        SetMultimap<IProject, IFile> setMultimap = this.index;
        synchronized (setMultimap) {
            this.index.remove((Object)project, (Object)file);
            this.indexer.unindex(file);
            if (file.exists()) {
                file.setSessionProperty(this.indexKey, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(IProject project) throws CoreException {
        SetMultimap<IProject, IFile> setMultimap = this.index;
        synchronized (setMultimap) {
            if (this.index.containsKey((Object)project)) {
                for (IFile next : this.index.get((Object)project)) {
                    this.indexer.unindex(next);
                }
                this.index.removeAll((Object)project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReindexProjectJob reindex(IProject project, Iterable<? extends IndexDelta> deltas) {
        ReindexProjectJob result = null;
        Map<IProject, AbstractIndexJob> map = this.activeJobs;
        synchronized (map) {
            AbstractIndexJob active = this.activeJobs.get(project);
            if (active != null) {
                switch (active.kind()) {
                    case REINDEX: {
                        ReindexProjectJob reindex = (ReindexProjectJob)active;
                        reindex.addDeltas(deltas);
                        break;
                    }
                    case INDEX: {
                        IndexProjectJob index = (IndexProjectJob)active;
                        ReindexProjectJob followup = index.getFollowup();
                        if (followup != null) {
                            followup.addDeltas(deltas);
                            break;
                        }
                        followup = new ReindexProjectJob(project, deltas);
                        index.setFollowup(followup);
                        break;
                    }
                    case MASTER: {
                        throw new IllegalStateException("Master job is in the active table.");
                    }
                }
            } else {
                result = new ReindexProjectJob(project, deltas);
            }
        }
        return result;
    }

    IResourceVisitor getWorkspaceVisitor(final IProgressMonitor monitor) {
        return new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 1) {
                    WorkspaceModelIndex.this.process((IFile)resource);
                }
                return !monitor.isCanceled();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(Collection<? extends AbstractIndexJob> jobs) {
        Map<IProject, AbstractIndexJob> map = this.activeJobs;
        synchronized (map) {
            this.jobWrangler.add(jobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(AbstractIndexJob job) {
        Map<IProject, AbstractIndexJob> map = this.activeJobs;
        synchronized (map) {
            this.jobWrangler.add(job);
        }
    }

    public void addListener(IWorkspaceModelIndexListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeListener(IWorkspaceModelIndexListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyStarting(AbstractIndexJob indexJob) {
        if (!this.listeners.isEmpty()) {
            switch (indexJob.kind()) {
                case INDEX: {
                    WorkspaceModelIndexEvent event = new WorkspaceModelIndexEvent(this, 2, indexJob.getProject());
                    for (IWorkspaceModelIndexListener next : this.listeners) {
                        try {
                            next.indexAboutToCalculate(event);
                        }
                        catch (Exception e) {
                            Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                        }
                    }
                    break;
                }
                case REINDEX: {
                    WorkspaceModelIndexEvent event = new WorkspaceModelIndexEvent(this, 0, indexJob.getProject());
                    for (IWorkspaceModelIndexListener next : this.listeners) {
                        try {
                            next.indexAboutToRecalculate(event);
                        }
                        catch (Exception e) {
                            Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                        }
                    }
                    break;
                }
            }
        }
    }

    private void notifyFinished(AbstractIndexJob indexJob, IStatus status) {
        if (!this.listeners.isEmpty()) {
            if (status != null && status.getSeverity() >= 4) {
                WorkspaceModelIndexEvent event = new WorkspaceModelIndexEvent(this, 4, indexJob.getProject());
                for (IWorkspaceModelIndexListener next : this.listeners) {
                    try {
                        next.indexFailed(event);
                    }
                    catch (Exception e) {
                        Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                    }
                }
            } else {
                switch (indexJob.kind()) {
                    case INDEX: {
                        WorkspaceModelIndexEvent event = new WorkspaceModelIndexEvent(this, 3, indexJob.getProject());
                        for (IWorkspaceModelIndexListener next : this.listeners) {
                            try {
                                next.indexCalculated(event);
                            }
                            catch (Exception e) {
                                Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                            }
                        }
                        break;
                    }
                    case REINDEX: {
                        WorkspaceModelIndexEvent event = new WorkspaceModelIndexEvent(this, 1, indexJob.getProject());
                        for (IWorkspaceModelIndexListener next : this.listeners) {
                            try {
                                next.indexRecalculated(event);
                            }
                            catch (Exception e) {
                                Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    private abstract class AbstractIndexJob
    extends Job {
        private final IProject project;
        private volatile Semaphore permit;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbstractIndexJob(String name, IProject project) {
            super(name);
            this.project = project;
            this.permit = this.permit;
            if (project != null) {
                this.setRule((ISchedulingRule)project);
                Map map = WorkspaceModelIndex.this.activeJobs;
                synchronized (map) {
                    if (!WorkspaceModelIndex.this.activeJobs.containsKey(project)) {
                        WorkspaceModelIndex.this.activeJobs.put(project, this);
                    }
                }
            }
            this.setSystem(this.kind().isSystem());
        }

        public boolean belongsTo(Object family) {
            return family == WorkspaceModelIndex.this;
        }

        final IProject getProject() {
            return this.project;
        }

        abstract JobKind kind();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final IStatus run(IProgressMonitor monitor) {
            IStatus result;
            try {
                result = this.doRun(monitor);
            }
            catch (Throwable throwable) {
                Map map = WorkspaceModelIndex.this.activeJobs;
                synchronized (map) {
                    AbstractIndexJob followup = this.getFollowup();
                    if (this.project != null) {
                        if (followup == null) {
                            WorkspaceModelIndex.this.activeJobs.remove(this.project);
                        } else {
                            WorkspaceModelIndex.this.activeJobs.put(this.project, followup);
                        }
                    }
                    if (followup != null) {
                        WorkspaceModelIndex.this.schedule(followup);
                    }
                }
                throw throwable;
            }
            Map map = WorkspaceModelIndex.this.activeJobs;
            synchronized (map) {
                AbstractIndexJob followup = this.getFollowup();
                if (this.project != null) {
                    if (followup == null) {
                        WorkspaceModelIndex.this.activeJobs.remove(this.project);
                    } else {
                        WorkspaceModelIndex.this.activeJobs.put(this.project, followup);
                    }
                }
                if (followup != null) {
                    WorkspaceModelIndex.this.schedule(followup);
                }
            }
            return result;
        }

        final Semaphore getPermit() {
            return this.permit;
        }

        final void setPermit(Semaphore permit) {
            this.permit = permit;
        }

        protected abstract IStatus doRun(IProgressMonitor var1);

        protected AbstractIndexJob getFollowup() {
            return null;
        }
    }

    private static final class ContentTypeService
    extends ReferenceCounted<ContentTypeService> {
        private static ContentTypeService instance = null;
        private final ExecutorService serialExecution = new JobExecutorService();
        private final IContentTypeManager mgr = Platform.getContentTypeManager();

        private ContentTypeService() {
        }

        static synchronized ContentTypeService getInstance() {
            ContentTypeService result = instance;
            if (result == null) {
                instance = result = new ContentTypeService();
            }
            return (ContentTypeService)((Object)result.retain());
        }

        static synchronized void dispose(ContentTypeService service) {
            service.release();
        }

        protected void dispose() {
            this.serialExecution.shutdownNow();
            if (instance == this) {
                instance = null;
            }
        }

        IContentType[] getContentTypes(final IFile file) {
            Future<IContentType[]> futureResult = this.serialExecution.submit(new Callable<IContentType[]>(){

                @Override
                public IContentType[] call() {
                    IContentType[] result;
                    block13: {
                        result = null;
                        InputStream input = null;
                        if (file.isAccessible()) {
                            try {
                                try {
                                    input = file.getContents(true);
                                    result = ContentTypeService.this.mgr.findContentTypesFor(input, file.getName());
                                }
                                catch (Exception e) {
                                    Activator.log.error("Failed to index file " + file.getFullPath(), (Throwable)e);
                                    if (input == null) break block13;
                                    try {
                                        input.close();
                                    }
                                    catch (IOException e2) {
                                        Activator.log.error("Failed to close indexed file " + file.getFullPath(), (Throwable)e2);
                                    }
                                }
                            }
                            finally {
                                if (input != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (IOException e) {
                                        Activator.log.error("Failed to close indexed file " + file.getFullPath(), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    return result;
                }
            });
            return (IContentType[])Futures.getUnchecked(futureResult);
        }
    }

    private static class IndexDelta {
        private final IFile file;
        private final DeltaKind kind;

        IndexDelta(IFile file, DeltaKind kind) {
            this.file = file;
            this.kind = kind;
        }

        static enum DeltaKind {
            INDEX,
            REINDEX,
            UNINDEX;

        }
    }

    public static interface IndexHandler<T> {
        public T index(IFile var1);

        public void unindex(IFile var1);
    }

    private class IndexProjectJob
    extends AbstractIndexJob {
        private ReindexProjectJob followup;

        IndexProjectJob(IProject project) {
            super("Indexing project " + project.getName(), project);
        }

        @Override
        JobKind kind() {
            return JobKind.INDEX;
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            IStatus result = Status.OK_STATUS;
            IProject project = this.getProject();
            monitor.beginTask("Indexing models in project " + project.getName(), -1);
            try {
                try {
                    if (project.isAccessible()) {
                        project.accept(WorkspaceModelIndex.this.getWorkspaceVisitor(monitor));
                    } else {
                        WorkspaceModelIndex.this.remove(project);
                    }
                    if (monitor.isCanceled()) {
                        result = Status.CANCEL_STATUS;
                    }
                }
                catch (CoreException e) {
                    result = e.getStatus();
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return result;
        }

        void setFollowup(ReindexProjectJob followup) {
            this.followup = followup;
        }

        @Override
        protected ReindexProjectJob getFollowup() {
            return this.followup;
        }
    }

    private static enum JobKind {
        MASTER,
        INDEX,
        REINDEX;


        boolean isSystem() {
            return this != MASTER;
        }
    }

    private class JobWrangler
    extends AbstractIndexJob {
        private final Lock lock;
        private final Deque<AbstractIndexJob> queue;
        private final AtomicBoolean active;
        private final int maxConcurrentJobs;

        JobWrangler(int maxConcurrentJobs) {
            super("Workspace model indexer", null);
            this.lock = new ReentrantLock();
            this.queue = Queues.newArrayDeque();
            this.active = new AtomicBoolean();
            this.maxConcurrentJobs = maxConcurrentJobs;
        }

        @Override
        JobKind kind() {
            return JobKind.MASTER;
        }

        void add(AbstractIndexJob job) {
            this.lock.lock();
            try {
                this.scheduleIfNeeded();
                this.queue.add(job);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void scheduleIfNeeded() {
            if (this.active.compareAndSet(false, true)) {
                this.schedule();
            }
        }

        void add(Iterable<? extends AbstractIndexJob> jobs) {
            this.lock.lock();
            try {
                for (AbstractIndexJob abstractIndexJob : jobs) {
                    this.add(abstractIndexJob);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        protected IStatus doRun(IProgressMonitor progressMonitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class ReindexProjectJob
    extends AbstractIndexJob {
        private final IProject project;
        private final ConcurrentLinkedQueue<IndexDelta> deltas;

        ReindexProjectJob(IProject project, Iterable<? extends IndexDelta> deltas) {
            super("Re-indexing project " + project.getName(), project);
            this.project = project;
            this.deltas = Queues.newConcurrentLinkedQueue(deltas);
        }

        @Override
        JobKind kind() {
            return JobKind.REINDEX;
        }

        void addDeltas(Iterable<? extends IndexDelta> deltas) {
            Iterables.addAll(this.deltas, deltas);
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            IStatus result = Status.OK_STATUS;
            monitor.beginTask("Re-indexing models in project " + this.project.getName(), -1);
            try {
                IndexDelta next = this.deltas.poll();
                while (next != null) {
                    if (monitor.isCanceled()) {
                        result = Status.CANCEL_STATUS;
                        break;
                    }
                    try {
                        try {
                            switch (next.kind) {
                                case INDEX: 
                                case REINDEX: {
                                    WorkspaceModelIndex.this.process(next.file);
                                    break;
                                }
                                case UNINDEX: {
                                    WorkspaceModelIndex.this.remove(this.project, next.file);
                                }
                            }
                        }
                        catch (CoreException e) {
                            result = e.getStatus();
                            monitor.worked(1);
                            break;
                        }
                    }
                    finally {
                        monitor.worked(1);
                    }
                    next = this.deltas.poll();
                }
            }
            finally {
                monitor.done();
            }
            return result;
        }

        @Override
        protected AbstractIndexJob getFollowup() {
            return this.deltas.isEmpty() ? null : this;
        }
    }

    private class WorkspaceListener
    implements IResourceChangeListener {
        private WorkspaceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            ArrayListMultimap deltas = ArrayListMultimap.create();
            try {
                event.getDelta().accept(new IResourceDeltaVisitor((Multimap)deltas){
                    private final /* synthetic */ Multimap val$deltas;
                    {
                        this.val$deltas = multimap;
                    }

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getResource().getType() == 1) {
                            IFile file = (IFile)delta.getResource();
                            switch (delta.getKind()) {
                                case 4: {
                                    if ((delta.getFlags() & 0x50100) == 0) break;
                                    this.val$deltas.put((Object)file.getProject(), (Object)new IndexDelta(file, IndexDelta.DeltaKind.REINDEX));
                                    break;
                                }
                                case 2: {
                                    this.val$deltas.put((Object)file.getProject(), (Object)new IndexDelta(file, IndexDelta.DeltaKind.UNINDEX));
                                    break;
                                }
                                case 1: {
                                    this.val$deltas.put((Object)file.getProject(), (Object)new IndexDelta(file, IndexDelta.DeltaKind.INDEX));
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                Activator.log.error("Failed to analyze resource changes for re-indexing.", (Throwable)e);
            }
            if (!deltas.isEmpty()) {
                ArrayList jobs = Lists.newArrayListWithCapacity((int)deltas.keySet().size());
                for (IProject next : deltas.keySet()) {
                    ReindexProjectJob reindex = WorkspaceModelIndex.this.reindex(next, deltas.get((Object)next));
                    if (reindex == null) continue;
                    jobs.add(reindex);
                }
                WorkspaceModelIndex.this.schedule(jobs);
            }
        }
    }
}

