/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.extendedtypes.Activator;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.HierarchyPermission;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.InvariantContainerConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.IInvariantContainerDescriptor;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvariantContainerConfigurationContainerDescriptor
implements IInvariantContainerDescriptor<InvariantContainerConfiguration> {
    protected EList<HierarchyPermission> permissions;
    private IClientContext sharedContext;
    private IElementMatcher matcher;

    public IElementMatcher getMatcher() {
        if (this.matcher == null) {
            this.matcher = this.createMatcher();
        }
        return this.matcher;
    }

    protected IElementMatcher createMatcher() {
        return new IElementMatcher(){

            public boolean matches(EObject eObject) {
                if (eObject == null) {
                    return false;
                }
                IElementType objectMetamodelType = ElementTypeRegistry.getInstance().getElementType(eObject, InvariantContainerConfigurationContainerDescriptor.this.sharedContext);
                boolean isValid = false;
                for (HierarchyPermission permission : InvariantContainerConfigurationContainerDescriptor.this.permissions) {
                    boolean matchesSpecialization;
                    IElementMatcher matcher;
                    boolean isPermitted = permission.isIsPermitted();
                    String childType = permission.getChildType();
                    boolean isStrict = permission.isIsStrict();
                    IElementType type = ElementTypeRegistry.getInstance().getType(childType);
                    if (type instanceof IMetamodelType) {
                        if (isStrict) {
                            isValid = type.equals(objectMetamodelType) ? isPermitted : !isPermitted;
                            continue;
                        }
                        isValid = Arrays.asList(objectMetamodelType.getAllSuperTypes()).contains(type) ? isPermitted : !isPermitted;
                        continue;
                    }
                    if (!(type instanceof ISpecializationType) || (matcher = ((ISpecializationType)type).getMatcher()) == null) continue;
                    boolean bl = matchesSpecialization = matcher.matches(eObject) && objectMetamodelType.equals(((ISpecializationType)type).getMetamodelType());
                    if (matchesSpecialization) {
                        if (isStrict) {
                            ISpecializationType[] subtypes = ElementTypeRegistry.getInstance().getSpecializationsOf(childType);
                            if (subtypes != null && subtypes.length > 0) {
                                ISpecializationType[] iSpecializationTypeArray = subtypes;
                                int n = subtypes.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ISpecializationType subType = iSpecializationTypeArray[n2];
                                    isValid = subType.getMatcher().matches(eObject) ? isPermitted : !isPermitted;
                                    ++n2;
                                }
                                continue;
                            }
                            isValid = isPermitted;
                            continue;
                        }
                        isValid = isPermitted;
                        continue;
                    }
                    boolean bl2 = isValid = !isPermitted;
                }
                return isValid;
            }
        };
    }

    public EReference[] getContainmentFeatures() {
        return null;
    }

    @Override
    public void init(InvariantContainerConfiguration ruleConfiguration) {
        this.permissions = ruleConfiguration.getPermissions();
        try {
            this.sharedContext = TypeContext.getContext();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

